/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.ExecException;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.RegistryAuthConfiguration;
import io.fabric8.maven.docker.config.VolumeConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.service.DockerAccessFactory;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.ServiceHubFactory;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.PomLabel;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractDockerMojo
extends AbstractMojo
implements Contextualizable,
ConfigHelper.Customizer {
    public static final String CONTEXT_KEY_START_CALLED = "CONTEXT_KEY_DOCKER_START_CALLED";
    public static final String CONTEXT_KEY_LOG_DISPATCHER = "CONTEXT_KEY_DOCKER_LOG_DISPATCHER";
    public static final String CONTEXT_KEY_BUILD_TIMESTAMP = "CONTEXT_KEY_BUILD_TIMESTAMP";
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="session")
    protected MavenSession session;
    @Parameter(property="mojoExecution")
    protected MojoExecution execution;
    @Component
    protected ImageConfigResolver imageConfigResolver;
    @Component
    protected ServiceHubFactory serviceHubFactory;
    @Component
    protected DockerAccessFactory dockerAccessFactory;
    @Parameter(property="docker.autoPull")
    protected String autoPull;
    @Parameter(property="docker.imagePullPolicy")
    protected String imagePullPolicy;
    @Parameter(property="docker.keepContainer", defaultValue="false")
    protected boolean keepContainer;
    @Parameter(property="docker.removeVolumes", defaultValue="false")
    protected boolean removeVolumes;
    @Parameter(property="docker.autoConfiguration.imageName", defaultValue="")
    protected String imageName;
    @Parameter(property="docker.apiVersion")
    private String apiVersion;
    @Parameter(property="docker.host")
    private String dockerHost;
    @Parameter(property="docker.certPath")
    private String certPath;
    @Parameter(property="docker.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="docker.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="docker.logDate")
    private String logDate;
    @Parameter(property="docker.logStdout", defaultValue="false")
    private boolean logStdout;
    @Parameter(property="docker.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="docker.skip.machine", defaultValue="false")
    private boolean skipMachine;
    @Parameter(property="docker.filter")
    private String filter;
    @Parameter(property="docker.registry")
    protected String registry;
    @Parameter(property="docker.skip.extendedAuth", defaultValue="false")
    protected boolean skipExtendedAuth;
    @Parameter(property="docker.maxConnections", defaultValue="100")
    private int maxConnections;
    @Parameter
    private RegistryAuthConfiguration authConfig;
    @Parameter
    private List<VolumeConfiguration> volumes;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter
    private DockerMachineConfiguration machine;
    private List<ImageConfiguration> resolvedImages;
    private AuthConfigFactory authConfigFactory;
    protected Logger log;
    private String minimalApiVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.log = new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.settings.getInteractiveMode() == false, this.getLogPrefix());
            this.authConfigFactory.setLog(this.log);
            LogOutputSpecFactory logSpecFactory = new LogOutputSpecFactory(this.useColor, this.logStdout, this.logDate);
            ConfigHelper.validateExternalPropertyActivation(this.project, this.images);
            this.minimalApiVersion = this.initImageConfiguration(this.getBuildTimestamp());
            DockerAccess access = null;
            try {
                if (this.isDockerAccessRequired()) {
                    DockerAccessFactory.DockerAccessContext dockerAccessContext = this.getDockerAccessContext();
                    access = this.dockerAccessFactory.createDockerAccess(dockerAccessContext);
                }
                ServiceHub serviceHub = this.serviceHubFactory.createServiceHub(this.project, this.session, access, this.log, logSpecFactory);
                this.executeInternal(serviceHub);
            }
            catch (DockerAccessException | ExecException exp) {
                this.logException(exp);
                throw new MojoExecutionException(this.log.errorMessage(exp.getMessage()), exp);
            }
            catch (MojoExecutionException exp) {
                this.logException((Exception)((Object)exp));
                throw exp;
            }
            finally {
                if (access != null) {
                    access.shutdown();
                }
            }
        }
    }

    private void logException(Exception exp) {
        if (exp.getCause() != null) {
            this.log.error("%s [%s]", exp.getMessage(), exp.getCause().getMessage());
        } else {
            this.log.error("%s", exp.getMessage());
        }
    }

    protected DockerAccessFactory.DockerAccessContext getDockerAccessContext() {
        return new DockerAccessFactory.DockerAccessContext.Builder().dockerHost(this.dockerHost).certPath(this.certPath).machine(this.machine).maxConnections(this.maxConnections).minimalApiVersion(this.minimalApiVersion).projectProperties(this.project.getProperties()).skipMachine(this.skipMachine).log(this.log).build();
    }

    protected RegistryService.RegistryConfig getRegistryConfig(String specificRegistry) throws MojoExecutionException {
        return new RegistryService.RegistryConfig.Builder().settings(this.settings).authConfig(this.authConfig != null ? this.authConfig.toMap() : null).authConfigFactory(this.authConfigFactory).skipExtendedAuth(this.skipExtendedAuth).registry(specificRegistry != null ? specificRegistry : this.registry).build();
    }

    protected synchronized Date getBuildTimestamp() throws MojoExecutionException {
        Date now = (Date)this.getPluginContext().get(CONTEXT_KEY_BUILD_TIMESTAMP);
        if (now == null) {
            now = this.getReferenceDate();
            this.getPluginContext().put(CONTEXT_KEY_BUILD_TIMESTAMP, now);
        }
        return now;
    }

    protected Date getReferenceDate() throws MojoExecutionException {
        Date referenceDate = EnvUtil.loadTimestamp(this.getBuildTimestampFile());
        return referenceDate != null ? referenceDate : new Date();
    }

    protected File getBuildTimestampFile() {
        return new File(this.project.getBuild().getDirectory(), DOCKER_BUILD_TIMESTAMP);
    }

    protected String getLogPrefix() {
        return "DOCKER> ";
    }

    private String initImageConfiguration(Date buildTimeStamp) {
        this.resolvedImages = ConfigHelper.resolveImages(this.log, this.images, new ConfigHelper.Resolver(){

            @Override
            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return AbstractDockerMojo.this.imageConfigResolver.resolve(image, AbstractDockerMojo.this.project, AbstractDockerMojo.this.session);
            }
        }, this.filter, this);
        return ConfigHelper.initAndValidate(this.resolvedImages, this.apiVersion, new ImageNameFormatter(this.project, buildTimeStamp), this.log);
    }

    @Override
    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> imageConfigs) {
        return imageConfigs;
    }

    protected boolean isDockerAccessRequired() {
        return true;
    }

    protected abstract void executeInternal(ServiceHub var1) throws DockerAccessException, ExecException, MojoExecutionException;

    protected List<ImageConfiguration> getResolvedImages() {
        return this.resolvedImages;
    }

    protected List<VolumeConfiguration> getVolumes() {
        return this.volumes;
    }

    public void contextualize(Context context) throws ContextException {
        this.authConfigFactory = new AuthConfigFactory((PlexusContainer)context.get((Object)"plexus"));
    }

    protected PomLabel getPomLabel() {
        return new PomLabel(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    protected LogDispatcher getLogDispatcher(ServiceHub hub) {
        LogDispatcher dispatcher = (LogDispatcher)this.getPluginContext().get(CONTEXT_KEY_LOG_DISPATCHER);
        if (dispatcher == null) {
            dispatcher = new LogDispatcher(hub.getDockerAccess());
            this.getPluginContext().put(CONTEXT_KEY_LOG_DISPATCHER, dispatcher);
        }
        return dispatcher;
    }

    public ImagePullManager getImagePullManager(String imagePullPolicy, String autoPull) {
        return new ImagePullManager(this.getSessionCacheStore(), imagePullPolicy, autoPull);
    }

    private ImagePullManager.CacheStore getSessionCacheStore() {
        return new ImagePullManager.CacheStore(){

            @Override
            public String get(String key) {
                Properties userProperties = AbstractDockerMojo.this.session.getUserProperties();
                return userProperties.getProperty(key);
            }

            @Override
            public void put(String key, String value) {
                Properties userProperties = AbstractDockerMojo.this.session.getUserProperties();
                userProperties.setProperty(key, value);
            }
        };
    }
}

