/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.ImagePullPolicy;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Settings;

public class RegistryService {
    private final DockerAccess docker;
    private final Logger log;

    RegistryService(DockerAccess docker, Logger log) {
        this.docker = docker;
        this.log = log;
    }

    public void pushImages(Collection<ImageConfiguration> imageConfigs, int retries, RegistryConfig registryConfig) throws DockerAccessException, MojoExecutionException {
        for (ImageConfiguration imageConfig : imageConfigs) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            String name = imageConfig.getName();
            if (buildConfig == null) continue;
            String configuredRegistry = EnvUtil.fistRegistryOf(new ImageName(imageConfig.getName()).getRegistry(), imageConfig.getRegistry(), registryConfig.getRegistry());
            AuthConfig authConfig = this.createAuthConfig(true, new ImageName(name).getUser(), configuredRegistry, registryConfig);
            long start = System.currentTimeMillis();
            this.docker.pushImage(name, authConfig, configuredRegistry, retries);
            this.log.info("Pushed %s in %s", name, EnvUtil.formatDurationTill(start));
            for (String tag : imageConfig.getBuildConfiguration().getTags()) {
                if (tag == null) continue;
                this.docker.pushImage(new ImageName(name, tag).getFullName(), authConfig, configuredRegistry, retries);
            }
        }
    }

    public void pullImageWithPolicy(String image, ImagePullManager pullManager, RegistryConfig registryConfig, boolean hasImage) throws DockerAccessException, MojoExecutionException {
        if (pullManager.hasAlreadyPulled(image)) {
            return;
        }
        if (!this.imageRequiresPull(hasImage, pullManager.getImagePullPolicy(), image)) {
            return;
        }
        ImageName imageName = new ImageName(image);
        long time = System.currentTimeMillis();
        String actualRegistry = EnvUtil.fistRegistryOf(imageName.getRegistry(), registryConfig.getRegistry());
        this.docker.pullImage(imageName.getFullName(), this.createAuthConfig(false, null, actualRegistry, registryConfig), actualRegistry);
        this.log.info("Pulled %s in %s", imageName.getFullName(), EnvUtil.formatDurationTill(time));
        pullManager.pulled(image);
        if (actualRegistry != null && !imageName.hasRegistry()) {
            this.docker.tag(imageName.getFullName(actualRegistry), image, false);
        }
    }

    private boolean imageRequiresPull(boolean hasImage, ImagePullPolicy pullPolicy, String imageName) throws MojoExecutionException {
        if (pullPolicy == ImagePullPolicy.Never) {
            if (!hasImage) {
                throw new MojoExecutionException(String.format("No image '%s' found and pull policy 'Never' is set. Please chose another pull policy or pull the image yourself)", imageName));
            }
            return false;
        }
        if (!hasImage) {
            return true;
        }
        return pullPolicy == ImagePullPolicy.Always;
    }

    private AuthConfig createAuthConfig(boolean isPush, String user, String registry, RegistryConfig config) throws MojoExecutionException {
        return config.getAuthConfigFactory().createAuthConfig(isPush, config.isSkipExtendedAuth(), config.getAuthConfig(), config.getSettings(), user, registry);
    }

    public static class RegistryConfig
    implements Serializable {
        private String registry;
        private Settings settings;
        private AuthConfigFactory authConfigFactory;
        private boolean skipExtendedAuth;
        private Map authConfig;

        public String getRegistry() {
            return this.registry;
        }

        public Settings getSettings() {
            return this.settings;
        }

        public AuthConfigFactory getAuthConfigFactory() {
            return this.authConfigFactory;
        }

        public boolean isSkipExtendedAuth() {
            return this.skipExtendedAuth;
        }

        public Map getAuthConfig() {
            return this.authConfig;
        }

        public static class Builder {
            private RegistryConfig context = new RegistryConfig();

            public Builder() {
                this.context = new RegistryConfig();
            }

            public Builder(RegistryConfig context) {
                this.context = context;
            }

            public Builder registry(String registry) {
                this.context.registry = registry;
                return this;
            }

            public Builder settings(Settings settings) {
                this.context.settings = settings;
                return this;
            }

            public Builder authConfigFactory(AuthConfigFactory authConfigFactory) {
                this.context.authConfigFactory = authConfigFactory;
                return this;
            }

            public Builder skipExtendedAuth(boolean skipExtendedAuth) {
                this.context.skipExtendedAuth = skipExtendedAuth;
                return this;
            }

            public Builder authConfig(Map authConfig) {
                this.context.authConfig = authConfig;
                return this;
            }

            public RegistryConfig build() {
                return this.context;
            }
        }
    }
}

