/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.log;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.UrlBuilder;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.access.util.RequestUtil;
import io.fabric8.maven.docker.util.Timestamp;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class LogRequestor
extends Thread
implements LogGetHandle {
    static final Pattern LOG_LINE = Pattern.compile("^\\[?(?<timestamp>[^\\s\\]]*)]? (?<entry>.*?)\\s*$", 32);
    private final CloseableHttpClient client;
    private final String containerId;
    private LogCallback callback;
    private DockerAccessException exception;
    private HttpUriRequest request;
    private final UrlBuilder urlBuilder;
    private final Object lock = new Object();

    public LogRequestor(CloseableHttpClient client, UrlBuilder urlBuilder, String containerId, LogCallback callback) {
        this.client = client;
        this.containerId = containerId;
        this.urlBuilder = urlBuilder;
        this.callback = callback;
        this.exception = null;
    }

    public void fetchLogs() {
        try {
            this.callback.open();
            this.request = this.getLogRequest(false);
            CloseableHttpResponse respone = this.client.execute(this.request);
            this.parseResponse((HttpResponse)respone);
        }
        catch (LogCallback.DoneException e) {
            this.finish();
        }
        catch (IOException exp) {
            this.callback.error(exp.getMessage());
        }
        finally {
            this.callback.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.callback.open();
                this.request = this.getLogRequest(true);
                CloseableHttpResponse response = this.client.execute(this.request);
                this.parseResponse((HttpResponse)response);
            }
            catch (LogCallback.DoneException e) {
                this.finish();
            }
            catch (IOException e) {
                this.callback.error("IO Error while requesting logs: " + e + " " + Thread.currentThread().getName());
            }
            finally {
                this.callback.close();
            }
        }
    }

    private void readFully(InputStream in, byte[] bytes) throws IOException {
        int read = ByteStreams.read((InputStream)in, (byte[])bytes, (int)0, (int)bytes.length);
        if (read == 0) {
            throw new NoBytesReadException();
        }
        if (read != bytes.length) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + bytes.length + " bytes expected");
        }
    }

    private boolean readStreamFrame(InputStream is) throws IOException, LogCallback.DoneException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(8);
        headerBuffer.order(ByteOrder.BIG_ENDIAN);
        try {
            this.readFully(is, headerBuffer.array());
        }
        catch (NoBytesReadException e) {
            return false;
        }
        catch (EOFException e) {
            throw new IOException("Failed to read log header. Could not read all 8 bytes. " + e.getMessage(), e);
        }
        byte type = headerBuffer.get();
        int size = headerBuffer.getInt(4);
        if (size <= 0) {
            return true;
        }
        ByteBuffer payload = ByteBuffer.allocate(size);
        try {
            ByteStreams.readFully((InputStream)is, (byte[])payload.array());
        }
        catch (EOFException e) {
            throw new IOException("Failed to read log message. Could not read all " + size + " bytes. " + e.getMessage() + " [ Header: " + Hex.encodeHexString((byte[])headerBuffer.array()) + "]", e);
        }
        String message = Charsets.UTF_8.newDecoder().decode(payload).toString();
        this.callLogCallback(type, message);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseResponse(HttpResponse response) throws LogCallback.DoneException, IOException {
        StatusLine status = response.getStatusLine();
        if (status.getStatusCode() != 200) {
            this.exception = new DockerAccessException("Error while reading logs (" + status + ")");
            throw new LogCallback.DoneException();
        }
        InputStream is = response.getEntity().getContent();
        try {
            while (this.readStreamFrame(is)) {
            }
            return;
        }
        finally {
            if (is != null && is.available() > 0) {
                is.close();
            }
        }
    }

    private void callLogCallback(int type, String txt) throws LogCallback.DoneException {
        Matcher matcher = LOG_LINE.matcher(txt);
        if (!matcher.matches()) {
            this.callback.error(String.format("Invalid log format for '%s' (expected: \"<timestamp> <txt>\") [%04x %04x]", txt, (int)txt.toCharArray()[0], (int)txt.toCharArray()[1]));
            throw new LogCallback.DoneException();
        }
        Timestamp ts = new Timestamp(matcher.group("timestamp"));
        String logTxt = matcher.group("entry");
        this.callback.log(type, ts, logTxt);
    }

    private HttpUriRequest getLogRequest(boolean follow) {
        return RequestUtil.newGet(this.urlBuilder.containerLogs(this.containerId, follow));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() {
        Object object = this.lock;
        synchronized (object) {
            if (this.request != null) {
                this.request.abort();
                this.request = null;
            }
        }
    }

    @Override
    public boolean isError() {
        return this.exception != null;
    }

    @Override
    public DockerAccessException getException() {
        return this.exception;
    }

    private static class NoBytesReadException
    extends IOException {
    }
}

