/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import com.google.common.util.concurrent.MoreExecutors;
import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RegistryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.StartOrderResolver;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.showLogs")
    private String showLogs;
    @Parameter(property="docker.pull.registry")
    private String pullRegistry;
    @Parameter(property="docker.skip.run", defaultValue="false")
    private boolean skipRun;
    @Parameter(property="docker.startParallel", defaultValue="false")
    private boolean startParallel;
    private boolean follow;
    @Parameter(property="docker.exposeContainerInfo")
    private String exposeContainerProps = "docker.container";
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    @Parameter
    protected String portPropertyFile;

    @Override
    public synchronized void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.skipRun) {
            return;
        }
        this.getPluginContext().put("CONTEXT_KEY_DOCKER_START_CALLED", true);
        this.follow = this.followLogs();
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        PortMapping.PropertyWriteHelper portMappingPropertyWriteHelper = new PortMapping.PropertyWriteHelper(this.portPropertyFile);
        boolean success = false;
        ExecutorService executorService = this.getExecutorService();
        ExecutorCompletionService<StartedContainer> containerStartupService = new ExecutorCompletionService<StartedContainer>(executorService);
        try {
            HashSet<String> imageAliases = new HashSet<String>();
            HashSet<String> startedContainerAliases = new HashSet<String>();
            Queue<ImageConfiguration> imagesWaitingToStart = this.prepareStart(hub, queryService, runService, imageAliases);
            ArrayDeque<ImageConfiguration> imagesStarting = new ArrayDeque<ImageConfiguration>();
            while (!this.hasBeenAllImagesStarted(imagesWaitingToStart, imagesStarting)) {
                List<ImageConfiguration> imagesReadyToStart = this.getImagesWhoseDependenciesHasStarted(imagesWaitingToStart, startedContainerAliases, imageAliases);
                for (ImageConfiguration image : imagesReadyToStart) {
                    this.startImage(image, hub, containerStartupService, portMappingPropertyWriteHelper);
                    imagesStarting.add(image);
                    imagesWaitingToStart.remove(image);
                }
                Future startedContainerFuture = containerStartupService.take();
                try {
                    StartedContainer startedContainer = (StartedContainer)startedContainerFuture.get();
                    ImageConfiguration imageConfig = startedContainer.imageConfig;
                    this.updateAliasesSet(startedContainerAliases, imageConfig.getAlias());
                    this.exposeContainerProps(hub.getQueryService(), startedContainer);
                    imagesStarting.remove(imageConfig);
                }
                catch (ExecutionException e) {
                    this.rethrowCause(e);
                }
            }
            portMappingPropertyWriteHelper.write();
            if (this.follow) {
                runService.addShutdownHookForStoppingContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks);
                this.wait();
            }
            success = true;
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
        finally {
            this.shutdownExecutorService(executorService);
            if (!success) {
                this.log.error("Error occurred during container startup, shutting down...", new Object[0]);
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, this.getPomLabel());
            }
        }
    }

    protected Boolean followLogs() {
        return Boolean.valueOf(System.getProperty("docker.follow", "false"));
    }

    private boolean hasBeenAllImagesStarted(Queue<ImageConfiguration> imagesWaitingToStart, Queue<ImageConfiguration> imagesStarting) {
        return imagesWaitingToStart.isEmpty() && imagesStarting.isEmpty();
    }

    private void shutdownExecutorService(ExecutorService executorService) {
        if (!executorService.isShutdown()) {
            executorService.shutdown();
            try {
                executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.log.warn("ExecutorService did not shutdown normally.", new Object[0]);
                executorService.shutdownNow();
            }
        }
    }

    private void rethrowCause(ExecutionException e) throws IOException, InterruptedException {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        if (cause instanceof InterruptedException) {
            throw (InterruptedException)cause;
        }
        throw new RuntimeException("Start-Job failed with unexpected exception: " + e.getCause().getMessage(), e.getCause());
    }

    private void updateAliasesSet(Set<String> aliasesSet, String alias) {
        if (alias != null) {
            aliasesSet.add(alias);
        }
    }

    private void startImage(final ImageConfiguration image, final ServiceHub hub, ExecutorCompletionService<StartedContainer> startingContainers, final PortMapping.PropertyWriteHelper portMappingPropertyWriteHelper) {
        final RunService runService = hub.getRunService();
        final Properties projProperties = this.project.getProperties();
        final RunImageConfiguration runConfig = image.getRunConfiguration();
        final PortMapping portMapping = runService.createPortMapping(runConfig, projProperties);
        final LogDispatcher dispatcher = this.getLogDispatcher(hub);
        startingContainers.submit(new Callable<StartedContainer>(){

            @Override
            public StartedContainer call() throws Exception {
                String containerId = runService.createAndStartContainer(image, portMapping, StartMojo.this.getPomLabel(), projProperties);
                portMappingPropertyWriteHelper.add(portMapping, runConfig.getPortPropertyFile());
                if (StartMojo.this.showLogs(image)) {
                    dispatcher.trackContainerLog(containerId, StartMojo.this.serviceHubFactory.getLogOutputSpecFactory().createSpec(containerId, image));
                }
                hub.getWaitService().wait(image, projProperties, containerId);
                WaitConfiguration waitConfig = runConfig.getWaitConfiguration();
                if (waitConfig != null && waitConfig.getExec() != null && waitConfig.getExec().getPostStart() != null) {
                    runService.execInContainer(containerId, waitConfig.getExec().getPostStart(), image);
                }
                return new StartedContainer(image, containerId);
            }
        });
    }

    private List<ImageConfiguration> getImagesWhoseDependenciesHasStarted(Queue<ImageConfiguration> imagesRemaining, Set<String> containersStarted, Set<String> aliases) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageWaitingToStart : imagesRemaining) {
            List<String> allDependencies = imageWaitingToStart.getDependencies();
            List<String> aliasDependencies = this.filterOutNonAliases(aliases, allDependencies);
            if (!containersStarted.containsAll(aliasDependencies)) continue;
            ret.add(imageWaitingToStart);
        }
        return ret;
    }

    private Queue<ImageConfiguration> prepareStart(ServiceHub hub, QueryService queryService, RunService runService, Set<String> imageAliases) throws DockerAccessException, MojoExecutionException {
        ArrayDeque<ImageConfiguration> imagesWaitingToStart = new ArrayDeque<ImageConfiguration>();
        for (StartOrderResolver.Resolvable resolvable : runService.getImagesConfigsInOrder(queryService, this.getResolvedImages())) {
            ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
            String imageName = imageConfig.getName();
            RegistryService.RegistryConfig registryConfig = this.getRegistryConfig();
            hub.getRegistryService().checkImageWithAutoPull(imageName, this.getConfiguredRegistry(imageConfig, this.pullRegistry), imageConfig.getBuildConfiguration() == null, registryConfig);
            RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
            NetworkConfig config = runConfig.getNetworkingConfig();
            if (this.autoCreateCustomNetworks && config.isCustomNetwork()) {
                runService.createCustomNetworkIfNotExistant(config.getCustomNetwork());
            }
            imagesWaitingToStart.add(imageConfig);
            this.updateAliasesSet(imageAliases, imageConfig.getAlias());
        }
        return imagesWaitingToStart;
    }

    private List<String> filterOutNonAliases(Set<String> imageAliases, List<String> dependencies) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String alias : dependencies) {
            if (!imageAliases.contains(alias)) continue;
            ret.add(alias);
        }
        return ret;
    }

    private ExecutorService getExecutorService() {
        ExecutorService executorService = this.startParallel ? Executors.newCachedThreadPool() : MoreExecutors.newDirectExecutorService();
        return executorService;
    }

    protected boolean showLogs(ImageConfiguration imageConfig) {
        if (this.showLogs != null) {
            if (this.showLogs.equalsIgnoreCase("true")) {
                return true;
            }
            if (this.showLogs.equalsIgnoreCase("false")) {
                return false;
            }
            return ConfigHelper.matchesConfiguredImages(this.showLogs, imageConfig);
        }
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        if (runConfig != null) {
            LogConfiguration logConfig = runConfig.getLogConfiguration();
            if (logConfig != null) {
                return logConfig.isEnabled();
            }
            return this.follow;
        }
        return false;
    }

    private void exposeContainerProps(QueryService queryService, StartedContainer startedContainer) throws DockerAccessException {
        String propKey = this.getExposedPropertyKeyPart(startedContainer.imageConfig);
        if (StringUtils.isNotEmpty((String)this.exposeContainerProps) && StringUtils.isNotEmpty((String)propKey)) {
            Map<String, String> nets;
            Container container = queryService.getMandatoryContainer(startedContainer.containerId);
            Properties props = this.project.getProperties();
            String prefix = this.addDot(this.exposeContainerProps) + this.addDot(propKey);
            props.put(prefix + "id", startedContainer.containerId);
            String ip = container.getIPAddress();
            if (StringUtils.isNotEmpty((String)ip)) {
                props.put(prefix + "ip", ip);
            }
            if ((nets = container.getCustomNetworkIpAddresses()) != null) {
                for (Map.Entry<String, String> entry : nets.entrySet()) {
                    props.put(prefix + this.addDot("net") + this.addDot(entry.getKey()) + "ip", entry.getValue());
                }
            }
        }
    }

    private String getExposedPropertyKeyPart(ImageConfiguration image) {
        String propKey;
        String string = propKey = image.getRunConfiguration() != null ? image.getRunConfiguration().getExposedPropertyKey() : null;
        if (StringUtils.isEmpty((String)propKey)) {
            propKey = image.getAlias();
        }
        return propKey;
    }

    private String addDot(String part) {
        return part.endsWith(".") ? part : part + ".";
    }

    private static final class StartedContainer {
        public final ImageConfiguration imageConfig;
        public final String containerId;

        private StartedContainer(ImageConfiguration imageConfig, String containerId) {
            this.imageConfig = imageConfig;
            this.containerId = containerId;
        }
    }
}

