/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.model;

import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.InspectedContainer;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContainerDetails
implements InspectedContainer {
    static final String CONFIG = "Config";
    static final String CREATED = "Created";
    static final String HOST_IP = "HostIp";
    static final String HOST_PORT = "HostPort";
    static final String ID = "Id";
    static final String IMAGE = "Image";
    static final String LABELS = "Labels";
    static final String NAME = "Name";
    static final String IP = "IPAddress";
    static final String NETWORK_SETTINGS = "NetworkSettings";
    static final String NETWORKS = "Networks";
    static final String PORTS = "Ports";
    static final String SLASH = "/";
    static final String STATE = "State";
    static final String HEALTH = "Health";
    static final String STATUS = "Status";
    static final String HEALTH_STATUS_HEALTHY = "healthy";
    static final String HEALTHCHECK = "Healthcheck";
    static final String TEST = "Test";
    private static final String EXIT_CODE = "ExitCode";
    private static final String RUNNING = "Running";
    private final JSONObject json;

    public ContainerDetails(JSONObject json) {
        this.json = json;
    }

    @Override
    public long getCreated() {
        String date = this.json.getString(CREATED);
        Calendar cal = DatatypeConverter.parseDateTime((String)date);
        return cal.getTimeInMillis();
    }

    @Override
    public String getId() {
        return this.json.getString(ID).substring(0, 12);
    }

    @Override
    public String getImage() {
        return this.json.getJSONObject(CONFIG).getString(IMAGE);
    }

    @Override
    public Map<String, String> getLabels() {
        JSONObject config = this.json.getJSONObject(CONFIG);
        return config.has(LABELS) ? this.mapLabels(config.getJSONObject(LABELS)) : Collections.emptyMap();
    }

    @Override
    public String getName() {
        String name = this.json.getString(NAME);
        if (name.startsWith(SLASH)) {
            name = name.substring(1);
        }
        return name;
    }

    @Override
    public String getIPAddress() {
        JSONObject networkSettings;
        if (this.json.has(NETWORK_SETTINGS) && !this.json.isNull(NETWORK_SETTINGS) && !(networkSettings = this.json.getJSONObject(NETWORK_SETTINGS)).isNull(IP)) {
            return networkSettings.getString(IP);
        }
        return null;
    }

    @Override
    public Map<String, String> getCustomNetworkIpAddresses() {
        JSONObject networkSettings;
        if (this.json.has(NETWORK_SETTINGS) && !this.json.isNull(NETWORK_SETTINGS) && (networkSettings = this.json.getJSONObject(NETWORK_SETTINGS)).has(NETWORKS) && !networkSettings.isNull(NETWORKS)) {
            JSONObject networks = networkSettings.getJSONObject(NETWORKS);
            JSONArray keys = networks.names();
            HashMap<String, String> results = new HashMap<String, String>();
            for (int i = 0; i < keys.length(); ++i) {
                String key = keys.getString(i);
                JSONObject net = networks.getJSONObject(key);
                if (!net.has(IP) || net.isNull(IP)) continue;
                results.put(key, net.getString(IP));
            }
            return results;
        }
        return null;
    }

    @Override
    public Map<String, Container.PortBinding> getPortBindings() {
        JSONObject networkSettings;
        if (this.json.has(NETWORK_SETTINGS) && !this.json.isNull(NETWORK_SETTINGS) && !(networkSettings = this.json.getJSONObject(NETWORK_SETTINGS)).isNull(PORTS)) {
            return this.createPortBindings(networkSettings.getJSONObject(PORTS));
        }
        return new HashMap<String, Container.PortBinding>();
    }

    @Override
    public boolean isRunning() {
        JSONObject state = this.json.getJSONObject(STATE);
        return state.getBoolean(RUNNING);
    }

    @Override
    public Integer getExitCode() {
        if (this.isRunning()) {
            return null;
        }
        JSONObject state = this.json.getJSONObject(STATE);
        return state.getInt(EXIT_CODE);
    }

    @Override
    public boolean isHealthy() {
        JSONObject state = this.json.getJSONObject(STATE);
        return !state.has(HEALTH) || HEALTH_STATUS_HEALTHY.equals(state.getJSONObject(HEALTH).getString(STATUS));
    }

    @Override
    public String getHealthcheck() {
        if (!this.json.getJSONObject(CONFIG).has(HEALTHCHECK) || !this.json.getJSONObject(CONFIG).getJSONObject(HEALTHCHECK).has(TEST)) {
            return null;
        }
        return this.json.getJSONObject(CONFIG).getJSONObject(HEALTHCHECK).getJSONArray(TEST).join(", ");
    }

    private void addPortMapping(String port, JSONObject hostConfig, Map<String, Container.PortBinding> portBindings) {
        String hostIp = hostConfig.getString(HOST_IP);
        Integer hostPort = Integer.valueOf(hostConfig.getString(HOST_PORT));
        this.addPortMapping(port, new Container.PortBinding(hostPort, hostIp), portBindings);
    }

    private void addPortMapping(String port, Container.PortBinding binding, Map<String, Container.PortBinding> portBindings) {
        if (port.indexOf(47) == -1) {
            port = port + "/tcp";
        }
        portBindings.put(port, binding);
    }

    private Map<String, Container.PortBinding> createPortBindings(JSONObject ports) {
        HashMap<String, Container.PortBinding> portBindings = new HashMap<String, Container.PortBinding>();
        for (Object obj : ports.keySet()) {
            String port = obj.toString();
            if (ports.isNull(port)) {
                this.addPortMapping(port, (Container.PortBinding)null, portBindings);
                continue;
            }
            JSONObject hostConfig = ports.getJSONArray(port).getJSONObject(0);
            this.addPortMapping(port, hostConfig, portBindings);
        }
        return portBindings;
    }

    private Map<String, String> mapLabels(JSONObject labels) {
        int length = labels.length();
        HashMap<String, String> mapped = new HashMap<String, String>(length);
        Iterator iterator = labels.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            mapped.put(key, labels.get(key).toString());
        }
        return mapped;
    }
}

