/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.WatchImageConfiguration;
import io.fabric8.maven.docker.config.WatchMode;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.StartOrderResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="watch")
public class WatchMojo
extends AbstractBuildSupportMojo {
    @Parameter(property="docker.watchMode", defaultValue="both")
    private WatchMode watchMode;
    @Parameter(property="docker.watchInterval", defaultValue="5000")
    private int watchInterval;
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;
    @Parameter(property="docker.watchPostGoal")
    private String watchPostGoal;
    @Parameter(property="docker.watchPostExec")
    private String watchPostExec;
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    private ScheduledExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        MojoParameters mojoParameters = this.createMojoParameters();
        try {
            for (StartOrderResolver.Resolvable resolvable : runService.getImagesConfigsInOrder(queryService, this.getResolvedImages())) {
                ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
                String imageId = queryService.getImageId(imageConfig.getName());
                String containerId = runService.lookupContainer(imageConfig.getName());
                ImageWatcher watcher = new ImageWatcher(imageConfig, imageId, containerId);
                long interval = watcher.getInterval();
                WatchMode watchMode = watcher.getWatchMode(imageConfig);
                this.log.info("Watching " + imageConfig.getName() + (watchMode != null ? " using " + watchMode.getDescription() : ""), new Object[0]);
                ArrayList<String> tasks = new ArrayList<String>();
                if (imageConfig.getBuildConfiguration() != null && imageConfig.getBuildConfiguration().getAssemblyConfiguration() != null) {
                    if (watcher.isCopy()) {
                        String containerBaseDir = imageConfig.getBuildConfiguration().getAssemblyConfiguration().getTargetDir();
                        this.schedule(this.createCopyWatchTask(hub, watcher, mojoParameters, containerBaseDir), interval);
                        tasks.add("copying artifacts");
                    }
                    if (watcher.isBuild()) {
                        this.schedule(this.createBuildWatchTask(hub, watcher, mojoParameters, watchMode == WatchMode.both), interval);
                        tasks.add("rebuilding");
                    }
                }
                if (watcher.isRun() && watcher.getContainerId() != null) {
                    this.schedule(this.createRestartWatchTask(hub, watcher), interval);
                    tasks.add("restarting");
                }
                if (tasks.size() <= 0) continue;
                this.log.info("%s: Watch for %s", imageConfig.getDescription(), StringUtils.join((Object[])tasks.toArray(), (String)" and "));
            }
            this.log.info("Waiting ...", new Object[0]);
            if (!this.keepRunning) {
                runService.addShutdownHookForStoppingContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks);
            }
            this.wait();
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted", new Object[0]);
        }
        finally {
            this.executor.shutdownNow();
        }
    }

    private void schedule(Runnable runnable, long interval) {
        this.executor.scheduleAtFixedRate(runnable, 0L, interval, TimeUnit.MILLISECONDS);
    }

    private Runnable createCopyWatchTask(final ServiceHub hub, final ImageWatcher watcher, final MojoParameters mojoParameters, final String containerBaseDir) throws MojoExecutionException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final ArchiveService archiveService = hub.getArchiveService();
        final AssemblyFiles files = archiveService.getAssemblyFiles(imageConfig, mojoParameters);
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchMojo.this.log.info("%s: Assembly changed. Copying changed files to container ...", imageConfig.getDescription());
                        File changedFilesArchive = archiveService.createChangedFilesArchive(entries, files.getAssemblyDirectory(), imageConfig.getName(), mojoParameters);
                        hub.getDockerAccess().copyArchive(watcher.getContainerId(), changedFilesArchive, containerBaseDir);
                        WatchMojo.this.callPostExec(hub.getRunService(), watcher);
                    }
                    catch (IOException | MojoExecutionException e) {
                        WatchMojo.this.log.error("%s: Error when copying files to container %s: %s", imageConfig.getDescription(), watcher.getContainerId(), e.getMessage());
                    }
                }
            }
        };
    }

    private void callPostExec(RunService runService, ImageWatcher watcher) throws DockerAccessException {
        if (watcher.getPostExec() != null) {
            String containerId = watcher.getContainerId();
            runService.execInContainer(containerId, watcher.getPostExec(), watcher.getImageConfiguration());
        }
    }

    private Runnable createBuildWatchTask(final ServiceHub hub, final ImageWatcher watcher, MojoParameters mojoParameters, final boolean doRestart) throws MojoExecutionException {
        final ImageConfiguration imageConfig = watcher.getImageConfiguration();
        final AssemblyFiles files = hub.getArchiveService().getAssemblyFiles(imageConfig, mojoParameters);
        if (files.isEmpty()) {
            this.log.error("No assembly files for %s. Are you sure you invoked together with the `package` goal?", imageConfig.getDescription());
            throw new MojoExecutionException("No files to watch found for " + imageConfig);
        }
        return new Runnable(){

            @Override
            public void run() {
                List<AssemblyFiles.Entry> entries = files.getUpdatedEntriesAndRefresh();
                if (entries != null && entries.size() > 0) {
                    try {
                        WatchMojo.this.log.info("%s: Assembly changed. Rebuild ...", imageConfig.getDescription());
                        WatchMojo.this.buildImage(hub, imageConfig);
                        String name = imageConfig.getName();
                        watcher.setImageId(hub.getQueryService().getImageId(name));
                        if (doRestart) {
                            WatchMojo.this.restartContainer(hub, watcher);
                        }
                        WatchMojo.this.callPostGoal(hub, watcher);
                    }
                    catch (IOException | MojoExecutionException | MojoFailureException e) {
                        WatchMojo.this.log.error("%s: Error when rebuilding - %s", imageConfig.getDescription(), e);
                    }
                }
            }
        };
    }

    private Runnable createRestartWatchTask(final ServiceHub hub, final ImageWatcher watcher) throws DockerAccessException {
        final String imageName = watcher.getImageName();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String currentImageId = hub.getQueryService().getImageId(imageName);
                    String oldValue = watcher.getAndSetImageId(currentImageId);
                    if (!currentImageId.equals(oldValue)) {
                        WatchMojo.this.restartContainer(hub, watcher);
                        WatchMojo.this.callPostGoal(hub, watcher);
                    }
                }
                catch (DockerAccessException | MojoExecutionException | MojoFailureException e) {
                    WatchMojo.this.log.warn("%s: Error when restarting image - %s", watcher.getImageConfiguration().getDescription(), e);
                }
            }
        };
    }

    protected void restartContainer(ServiceHub hub, ImageWatcher watcher) throws DockerAccessException, MojoExecutionException, MojoFailureException {
        RunService runService = hub.getRunService();
        ImageConfiguration imageConfig = watcher.getImageConfiguration();
        PortMapping mappedPorts = runService.createPortMapping(imageConfig.getRunConfiguration(), this.project.getProperties());
        String id = watcher.getContainerId();
        String optionalPreStop = this.getPreStopCommand(imageConfig);
        if (optionalPreStop != null) {
            runService.execInContainer(id, optionalPreStop, watcher.getImageConfiguration());
        }
        runService.stopPreviouslyStartedContainer(id, false, false);
        watcher.setContainerId(runService.createAndStartContainer(imageConfig, mappedPorts, this.getPomLabel(), this.project.getProperties()));
    }

    private String getPreStopCommand(ImageConfiguration imageConfig) {
        if (imageConfig.getRunConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration() != null && imageConfig.getRunConfiguration().getWaitConfiguration().getExec() != null) {
            return imageConfig.getRunConfiguration().getWaitConfiguration().getExec().getPreStop();
        }
        return null;
    }

    private void callPostGoal(ServiceHub hub, ImageWatcher watcher) throws MojoFailureException, MojoExecutionException {
        String postGoal = watcher.getPostGoal();
        if (postGoal != null) {
            hub.getMojoExecutionService().callPluginGoal(postGoal);
        }
    }

    public class ImageWatcher {
        private final WatchMode mode;
        private final AtomicReference<String> imageIdRef;
        private final AtomicReference<String> containerIdRef;
        private final long interval;
        private final ImageConfiguration imageConfig;
        private final String postGoal;
        private String postExec;

        public ImageWatcher(ImageConfiguration imageConfig, String imageId, String containerIdRef) {
            this.imageConfig = imageConfig;
            this.imageIdRef = new AtomicReference<String>(imageId);
            this.containerIdRef = new AtomicReference<String>(containerIdRef);
            this.interval = this.getWatchInterval(imageConfig);
            this.mode = this.getWatchMode(imageConfig);
            this.postGoal = this.getPostGoal(imageConfig);
            this.postExec = this.getPostExec(imageConfig);
        }

        public String getContainerId() {
            return this.containerIdRef.get();
        }

        public long getInterval() {
            return this.interval;
        }

        public String getPostGoal() {
            return this.postGoal;
        }

        public boolean isCopy() {
            return this.mode.isCopy();
        }

        public boolean isBuild() {
            return this.mode.isBuild();
        }

        public boolean isRun() {
            return this.mode.isRun();
        }

        public ImageConfiguration getImageConfiguration() {
            return this.imageConfig;
        }

        public void setImageId(String imageId) {
            this.imageIdRef.set(imageId);
        }

        public void setContainerId(String containerId) {
            this.containerIdRef.set(containerId);
        }

        public String getImageName() {
            return this.imageConfig.getName();
        }

        public String getAndSetImageId(String currentImageId) {
            return this.imageIdRef.getAndSet(currentImageId);
        }

        public String getPostExec() {
            return this.postExec;
        }

        private int getWatchInterval(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            int interval = watchConfig != null ? watchConfig.getInterval() : WatchMojo.this.watchInterval;
            return interval < 100 ? 100 : interval;
        }

        private String getPostExec(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostExec() != null ? watchConfig.getPostExec() : WatchMojo.this.watchPostExec;
        }

        private String getPostGoal(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            return watchConfig != null && watchConfig.getPostGoal() != null ? watchConfig.getPostGoal() : WatchMojo.this.watchPostGoal;
        }

        private WatchMode getWatchMode(ImageConfiguration imageConfig) {
            WatchImageConfiguration watchConfig = imageConfig.getWatchConfiguration();
            WatchMode mode = watchConfig != null ? watchConfig.getMode() : null;
            return mode != null ? mode : WatchMojo.this.watchMode;
        }
    }
}

