/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.log;

import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.log.LogOutputSpec;

public class LogOutputSpecFactory {
    private boolean useColor;
    private boolean logStdout;
    private String logDate;

    public LogOutputSpecFactory(boolean useColor, boolean logStdout, String logDate) {
        this.useColor = useColor;
        this.logStdout = logStdout;
        this.logDate = logDate;
    }

    public LogOutputSpec createSpec(String containerId, ImageConfiguration imageConfiguration) {
        LogOutputSpec.Builder builder = new LogOutputSpec.Builder();
        LogConfiguration logConfig = this.extractLogConfiguration(imageConfiguration);
        this.addLogFormat(builder, logConfig);
        this.addPrefix(builder, logConfig.getPrefix(), imageConfiguration.getAlias(), containerId);
        builder.file(logConfig.getFileLocation()).containerId(containerId).useColor(this.useColor).logStdout(this.logStdout).color(logConfig.getColor());
        return builder.build();
    }

    private void addPrefix(LogOutputSpec.Builder builder, String logPrefix, String alias, String containerId) {
        String prefix = logPrefix;
        if (prefix == null) {
            prefix = alias;
        }
        if (prefix == null) {
            prefix = containerId.substring(0, 6);
        }
        builder.prefix(prefix);
    }

    private void addLogFormat(LogOutputSpec.Builder builder, LogConfiguration logConfig) {
        String logFormat;
        String string = logFormat = logConfig.getDate() != null ? logConfig.getDate() : this.logDate;
        if (logFormat != null && logFormat.equalsIgnoreCase("true")) {
            logFormat = "DEFAULT";
        }
        if (logFormat != null) {
            builder.timeFormatter(logFormat);
        }
    }

    private LogConfiguration extractLogConfiguration(ImageConfiguration imageConfiguration) {
        RunImageConfiguration runConfig = imageConfiguration.getRunConfiguration();
        LogConfiguration logConfig = null;
        if (runConfig != null) {
            logConfig = runConfig.getLogConfiguration();
        }
        if (logConfig == null) {
            logConfig = LogConfiguration.DEFAULT;
        }
        return logConfig;
    }
}

