/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildTarArchiveCompression;
import io.fabric8.maven.docker.config.CleanupMode;
import io.fabric8.maven.docker.config.HealthCheckConfiguration;
import io.fabric8.maven.docker.util.DeepCopy;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BuildImageConfiguration
implements Serializable {
    private String dockerFileDir;
    private String dockerFile;
    private String from;
    private Map<String, String> fromExt;
    private String registry;
    private String maintainer;
    private List<String> ports;
    private List<String> runCmds;
    private String cleanup = "try";
    private boolean nocache = false;
    private boolean optimise = false;
    private List<String> volumes;
    private List<String> tags;
    private Map<String, String> env;
    private Map<String, String> labels;
    private Map<String, String> args;
    private Arguments entryPoint;
    private String command;
    private String workdir;
    private Arguments cmd;
    private String user;
    private HealthCheckConfiguration healthCheck;
    private AssemblyConfiguration assembly;
    private boolean skip = false;
    private BuildTarArchiveCompression compression = BuildTarArchiveCompression.none;
    File dockerFileFile;
    private boolean dockerFileMode;

    public boolean isDockerFileMode() {
        return this.dockerFileMode;
    }

    public File getDockerFile() {
        return this.dockerFileFile;
    }

    public String getFrom() {
        if (this.from == null && this.getFromExt() != null) {
            return this.getFromExt().get("name");
        }
        return this.from;
    }

    public Map<String, String> getFromExt() {
        return this.fromExt;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public String getWorkdir() {
        return this.workdir;
    }

    public AssemblyConfiguration getAssemblyConfiguration() {
        return this.assembly;
    }

    public List<String> getPorts() {
        return this.ports;
    }

    public List<String> getVolumes() {
        return this.volumes != null ? this.volumes : Collections.emptyList();
    }

    public List<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptyList();
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Arguments getCmd() {
        return this.cmd;
    }

    @Deprecated
    public String getCommand() {
        return this.command;
    }

    public CleanupMode cleanupMode() {
        return CleanupMode.parse(this.cleanup);
    }

    public boolean nocache() {
        return this.nocache;
    }

    public boolean optimise() {
        return this.optimise;
    }

    public boolean skip() {
        return this.skip;
    }

    public BuildTarArchiveCompression getCompression() {
        return this.compression;
    }

    public Arguments getEntryPoint() {
        return this.entryPoint;
    }

    public List<String> getRunCmds() {
        return this.runCmds;
    }

    public String getUser() {
        return this.user;
    }

    public HealthCheckConfiguration getHealthCheck() {
        return this.healthCheck;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public File getAbsoluteDockerFilePath(MojoParameters mojoParams) {
        return EnvUtil.prepareAbsoluteSourceDirPath(mojoParams, this.getDockerFile().getPath());
    }

    public String initAndValidate(Logger log) throws IllegalArgumentException {
        if (this.entryPoint != null) {
            this.entryPoint.validate();
        }
        if (this.cmd != null) {
            this.cmd.validate();
        }
        if (this.healthCheck != null) {
            this.healthCheck.validate();
        }
        if (this.command != null) {
            log.warn("<command> in the <build> configuration is deprecated and will be be removed soon", new Object[0]);
            log.warn("Please use <cmd> with nested <shell> or <exec> sections instead.", new Object[0]);
            log.warn("", new Object[0]);
            log.warn("More on this is explained in the user manual: ", new Object[0]);
            log.warn("https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/manual.md#start-up-arguments", new Object[0]);
            log.warn("", new Object[0]);
            log.warn("Migration is trivial, see changelog to version 0.12.0 -->", new Object[0]);
            log.warn("https://github.com/fabric8io/docker-maven-plugin/blob/master/doc/changelog.md", new Object[0]);
            log.warn("", new Object[0]);
            log.warn("For now, the command is automatically translated for you to the shell form:", new Object[0]);
            log.warn("   <cmd>%s</cmd>", this.command);
        }
        this.initDockerFileFile(log);
        if (this.healthCheck != null) {
            return "1.24";
        }
        if (this.args != null) {
            return "1.21";
        }
        return null;
    }

    private void initDockerFileFile(Logger log) {
        if (this.dockerFile != null) {
            this.dockerFileFile = new File(this.dockerFile);
            this.dockerFileMode = true;
        } else if (this.dockerFileDir != null) {
            this.dockerFileFile = new File(this.dockerFileDir, "Dockerfile");
            this.dockerFileMode = true;
        } else {
            String deprecatedDockerFileDir;
            String string = deprecatedDockerFileDir = this.getAssemblyConfiguration() != null ? this.getAssemblyConfiguration().getDockerFileDir() : null;
            if (deprecatedDockerFileDir != null) {
                log.warn("<dockerFileDir> in the <assembly> section of a <build> configuration is deprecated", new Object[0]);
                log.warn("Please use <dockerFileDir> or <dockerFile> directly within the <build> configuration instead", new Object[0]);
                this.dockerFileFile = new File(deprecatedDockerFileDir, "Dockerfile");
                this.dockerFileMode = true;
            } else {
                this.dockerFileMode = false;
            }
        }
    }

    public static class Builder {
        private final BuildImageConfiguration config;

        public Builder() {
            this(null);
        }

        public Builder(BuildImageConfiguration that) {
            this.config = that == null ? new BuildImageConfiguration() : DeepCopy.copy(that);
        }

        public Builder dockerFileDir(String dir) {
            this.config.dockerFileDir = dir;
            return this;
        }

        public Builder dockerFile(String file) {
            this.config.dockerFile = file;
            return this;
        }

        public Builder from(String from) {
            this.config.from = from;
            return this;
        }

        public Builder fromExt(Map<String, String> fromExt) {
            this.config.fromExt = fromExt;
            return this;
        }

        public Builder registry(String registry) {
            this.config.registry = registry;
            return this;
        }

        public Builder maintainer(String maintainer) {
            this.config.maintainer = maintainer;
            return this;
        }

        public Builder workdir(String workdir) {
            this.config.workdir = workdir;
            return this;
        }

        public Builder assembly(AssemblyConfiguration assembly) {
            this.config.assembly = assembly;
            return this;
        }

        public Builder ports(List<String> ports) {
            this.config.ports = ports;
            return this;
        }

        public Builder runCmds(List<String> theCmds) {
            if (this.config.runCmds == null) {
                this.config.runCmds = new ArrayList();
            } else {
                this.config.runCmds = theCmds;
            }
            return this;
        }

        public Builder volumes(List<String> volumes) {
            this.config.volumes = volumes;
            return this;
        }

        public Builder tags(List<String> tags) {
            this.config.tags = tags;
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.config.env = env;
            return this;
        }

        public Builder args(Map<String, String> args) {
            this.config.args = args;
            return this;
        }

        public Builder labels(Map<String, String> labels) {
            this.config.labels = labels;
            return this;
        }

        public Builder cmd(String cmd) {
            if (cmd != null) {
                this.config.cmd = new Arguments(cmd);
            }
            return this;
        }

        public Builder cleanup(String cleanup) {
            this.config.cleanup = cleanup;
            return this;
        }

        public Builder compression(String compression) {
            if (compression == null) {
                this.config.compression = BuildTarArchiveCompression.none;
            } else {
                this.config.compression = BuildTarArchiveCompression.valueOf(compression);
            }
            return this;
        }

        public Builder nocache(String nocache) {
            if (nocache != null) {
                this.config.nocache = Boolean.valueOf(nocache);
            }
            return this;
        }

        public Builder optimise(String optimise) {
            if (optimise != null) {
                this.config.optimise = Boolean.valueOf(optimise);
            }
            return this;
        }

        public Builder entryPoint(String entryPoint) {
            if (entryPoint != null) {
                this.config.entryPoint = new Arguments(entryPoint);
            }
            return this;
        }

        public Builder user(String user) {
            this.config.user = user;
            return this;
        }

        public Builder healthCheck(HealthCheckConfiguration healthCheck) {
            this.config.healthCheck = healthCheck;
            return this;
        }

        public Builder skip(String skip) {
            if (skip != null) {
                this.config.skip = Boolean.valueOf(skip);
            }
            return this;
        }

        public BuildImageConfiguration build() {
            return this.config;
        }
    }
}

