/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.util.EnvUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContainerHostConfig {
    final JSONObject startConfig = new JSONObject();

    public ContainerHostConfig binds(List<String> bind) {
        if (bind != null && !bind.isEmpty()) {
            JSONArray binds = new JSONArray();
            for (String volume : bind) {
                if (!(volume = EnvUtil.fixupPath(volume)).contains(":")) continue;
                binds.put((Object)volume);
            }
            this.startConfig.put("Binds", (Object)binds);
        }
        return this;
    }

    public ContainerHostConfig capAdd(List<String> capAdd) {
        return this.addAsArray("CapAdd", capAdd);
    }

    public ContainerHostConfig capDrop(List<String> capDrop) {
        return this.addAsArray("CapDrop", capDrop);
    }

    public ContainerHostConfig securityOpts(List<String> securityOpt) {
        return this.addAsArray("SecurityOpt", securityOpt);
    }

    public ContainerHostConfig memory(Long memory) {
        return this.add("Memory", memory);
    }

    public ContainerHostConfig memorySwap(Long memorySwap) {
        return this.add("MemorySwap", memorySwap);
    }

    public ContainerHostConfig dns(List<String> dns) {
        return this.addAsArray("Dns", dns);
    }

    public ContainerHostConfig networkMode(String net) {
        return this.add("NetworkMode", net);
    }

    public ContainerHostConfig dnsSearch(List<String> dnsSearch) {
        return this.addAsArray("DnsSearch", dnsSearch);
    }

    public ContainerHostConfig extraHosts(List<String> extraHosts) throws IllegalArgumentException {
        if (extraHosts != null) {
            ArrayList<String> mapped = new ArrayList<String>();
            for (int i = 0; i < extraHosts.size(); ++i) {
                String[] parts = extraHosts.get(i).split(":");
                if (parts.length == 1) {
                    throw new IllegalArgumentException("extraHosts must be in the form <host:host|ip>");
                }
                try {
                    mapped.add(i, parts[0] + ":" + InetAddress.getByName(parts[1]).getHostAddress());
                    continue;
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("unable to resolve ip address for " + parts[1], e);
                }
            }
            return this.addAsArray("ExtraHosts", mapped);
        }
        return this;
    }

    public ContainerHostConfig volumesFrom(List<String> volumesFrom) {
        return this.addAsArray("VolumesFrom", volumesFrom);
    }

    public ContainerHostConfig ulimits(List<UlimitConfig> ulimitsConfig) {
        if (ulimitsConfig != null && ulimitsConfig.size() > 0) {
            JSONArray ulimits = new JSONArray();
            for (UlimitConfig ulimit : ulimitsConfig) {
                JSONObject ulimitConfigJson = new JSONObject();
                ulimitConfigJson.put("Name", (Object)ulimit.getName());
                this.addIfNotNull(ulimitConfigJson, "Hard", ulimit.getHard());
                this.addIfNotNull(ulimitConfigJson, "Soft", ulimit.getSoft());
                ulimits.put((Object)ulimitConfigJson);
            }
            this.startConfig.put("Ulimits", (Object)ulimits);
        }
        return this;
    }

    private void addIfNotNull(JSONObject json, String key, Integer value) {
        if (value != null) {
            json.put(key, (Object)value);
        }
    }

    public ContainerHostConfig links(List<String> links) {
        return this.addAsArray("Links", links);
    }

    public ContainerHostConfig portBindings(PortMapping portMapping) {
        JSONObject portBindings = portMapping.toDockerPortBindingsJson();
        if (portBindings != null) {
            this.startConfig.put("PortBindings", (Object)portBindings);
        }
        return this;
    }

    public ContainerHostConfig privileged(Boolean privileged) {
        return this.add("Privileged", privileged);
    }

    public ContainerHostConfig shmSize(Long shmSize) {
        return this.add("ShmSize", shmSize);
    }

    public ContainerHostConfig restartPolicy(String name, int retry) {
        if (name != null) {
            JSONObject policy = new JSONObject();
            policy.put("Name", (Object)name);
            policy.put("MaximumRetryCount", retry);
            this.startConfig.put("RestartPolicy", (Object)policy);
        }
        return this;
    }

    public ContainerHostConfig logConfig(LogConfiguration logConfig) {
        LogConfiguration.LogDriver logDriver;
        if (logConfig != null && (logDriver = logConfig.getDriver()) != null) {
            JSONObject logConfigJson = new JSONObject();
            logConfigJson.put("Type", (Object)logDriver.getName());
            Map<String, String> opts = logDriver.getOpts();
            if (opts != null && opts.size() > 0) {
                JSONObject config = new JSONObject();
                for (Map.Entry<String, String> logOpt : opts.entrySet()) {
                    config.put(logOpt.getKey(), (Object)logOpt.getValue());
                }
                logConfigJson.put("Config", (Object)config);
            }
            this.startConfig.put("LogConfig", (Object)logConfigJson);
        }
        return this;
    }

    public String toJson() {
        return this.startConfig.toString();
    }

    public Object toJsonObject() {
        return this.startConfig;
    }

    ContainerHostConfig addAsArray(String propKey, List<String> props) {
        if (props != null) {
            this.startConfig.put(propKey, (Object)new JSONArray(props));
        }
        return this;
    }

    private ContainerHostConfig add(String name, Object value) {
        if (value != null) {
            this.startConfig.put(name, value);
        }
        return this;
    }
}

