/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.util.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class AnsiLogger
implements Logger {
    public static final String DEFAULT_LOG_PREFIX = "DOCKER> ";
    private static final int NON_ANSI_UPDATE_PERIOD = 80;
    private final Log log;
    private final String prefix;
    private final boolean batchMode;
    private boolean verbose;
    static Ansi.Color COLOR_ERROR = Ansi.Color.RED;
    static Ansi.Color COLOR_INFO = Ansi.Color.GREEN;
    static Ansi.Color COLOR_WARNING = Ansi.Color.YELLOW;
    static Ansi.Color COLOR_PROGRESS_ID = Ansi.Color.YELLOW;
    static Ansi.Color COLOR_PROGRESS_STATUS = Ansi.Color.GREEN;
    static Ansi.Color COLOR_PROGRESS_BAR = Ansi.Color.CYAN;
    static Ansi.Color COLOR_EMPHASIS = Ansi.Color.BLUE;
    private ThreadLocal<Map<String, Integer>> imageLines = new ThreadLocal();
    private ThreadLocal<AtomicInteger> updateCount = new ThreadLocal();
    private boolean useAnsi;
    private static final Map<String, Ansi.Color> COLOR_MAP = new HashMap<String, Ansi.Color>();

    public AnsiLogger(Log log, boolean useColor, boolean verbose) {
        this(log, useColor, verbose, false);
    }

    public AnsiLogger(Log log, boolean useColor, boolean verbose, boolean batchMode) {
        this(log, useColor, verbose, batchMode, DEFAULT_LOG_PREFIX);
    }

    public AnsiLogger(Log log, boolean useColor, boolean verbose, boolean batchMode, String prefix) {
        this.log = log;
        this.verbose = verbose;
        this.prefix = prefix;
        this.batchMode = batchMode;
        this.initializeColor(useColor);
    }

    @Override
    public void debug(String message, Object ... params) {
        if (this.isDebugEnabled()) {
            this.log.debug((CharSequence)(this.prefix + String.format(message, params)));
        }
    }

    @Override
    public void info(String message, Object ... params) {
        this.log.info((CharSequence)this.colored(message, COLOR_INFO, true, params));
    }

    @Override
    public void verbose(String message, Object ... params) {
        if (this.verbose) {
            this.log.info((CharSequence)Ansi.ansi().fgBright(Ansi.Color.BLACK).a(this.prefix).a(String.format(message, params)).reset().toString());
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        this.log.warn((CharSequence)this.colored(format, COLOR_WARNING, true, params));
    }

    @Override
    public void error(String message, Object ... params) {
        this.log.error((CharSequence)this.colored(message, COLOR_ERROR, true, params));
    }

    @Override
    public String errorMessage(String message) {
        return this.colored(message, COLOR_ERROR, false, new Object[0]);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void progressStart() {
        if (!this.batchMode && this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.updateCount.remove();
            this.imageLines.set(new HashMap());
            this.updateCount.set(new AtomicInteger());
        }
    }

    @Override
    public void progressUpdate(String layerId, String status, String progressMessage) {
        if (!this.batchMode && this.log.isInfoEnabled() && StringUtils.isNotEmpty((String)layerId)) {
            if (this.useAnsi) {
                this.updateAnsiProgress(layerId, status, progressMessage);
            } else {
                this.updateNonAnsiProgress(layerId);
            }
            this.flush();
        }
    }

    private void updateAnsiProgress(String imageId, String status, String progressMessage) {
        Map<String, Integer> imgLineMap = this.imageLines.get();
        Integer line = imgLineMap.get(imageId);
        int diff = 0;
        if (line == null) {
            line = imgLineMap.size();
            imgLineMap.put(imageId, line);
        } else {
            diff = imgLineMap.size() - line;
        }
        if (diff > 0) {
            this.print(Ansi.ansi().cursorUp(diff).eraseLine(Ansi.Erase.ALL).toString());
        }
        String progress = progressMessage != null ? progressMessage : "";
        String msg = Ansi.ansi().fg(COLOR_PROGRESS_ID).a(imageId).reset().a(": ").fg(COLOR_PROGRESS_STATUS).a(StringUtils.rightPad((String)status, (int)11) + " ").fg(COLOR_PROGRESS_BAR).a(progress).toString();
        this.println(msg);
        if (diff > 0) {
            this.print(Ansi.ansi().cursorDown(diff - 1).toString());
        }
    }

    private void updateNonAnsiProgress(String imageId) {
        AtomicInteger count = this.updateCount.get();
        int nr = count.getAndIncrement();
        if (nr % 80 == 0) {
            this.print("#");
        }
        if (nr > 0 && nr % 6400 == 0) {
            this.print("\n");
        }
    }

    @Override
    public void progressFinished() {
        if (!this.batchMode && this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.print(Ansi.ansi().reset().toString());
            if (!this.useAnsi) {
                this.println("");
            }
        }
    }

    private void flush() {
        System.out.flush();
    }

    private void initializeColor(boolean useColor) {
        boolean bl = this.useAnsi = useColor && System.console() != null && !this.log.isDebugEnabled() && !this.isWindows();
        if (this.useAnsi) {
            AnsiConsole.systemInstall();
            Ansi.setEnabled((boolean)true);
        } else {
            Ansi.setEnabled((boolean)false);
        }
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    private void println(String txt) {
        System.out.println(txt);
    }

    private void print(String txt) {
        System.out.print(txt);
    }

    private String colored(String message, Ansi.Color color, boolean addPrefix, Object ... params) {
        Ansi ansi = Ansi.ansi().fg(color);
        String msgToPrint = addPrefix ? this.prefix + message : message;
        return ansi.a(String.format(this.evaluateEmphasis(msgToPrint, color), params)).reset().toString();
    }

    private String evaluateEmphasis(String message, Ansi.Color msgColor) {
        String prepared = message.replaceAll("\\[\\[(.)\\]\\]", "[[]]$1[[]]");
        String[] parts = prepared.split("\\[\\[\\]\\]");
        if (parts.length == 1) {
            return message;
        }
        String msgColorS = Ansi.ansi().fg(msgColor).toString();
        StringBuilder ret = new StringBuilder(parts[0]);
        boolean colorOpen = true;
        for (int i = 1; i < parts.length; i += 2) {
            ret.append(colorOpen ? this.getEmphasisColor(parts[i]) : msgColorS);
            boolean bl = colorOpen = !colorOpen;
            if (i + 1 >= parts.length) continue;
            ret.append(parts[i + 1]);
        }
        return ret.toString();
    }

    private String getEmphasisColor(String id) {
        Ansi.Color color = COLOR_MAP.get(id.toUpperCase());
        if (color != null) {
            return id.toLowerCase().equals(id) ? Ansi.ansi().fgBright(color).toString() : Ansi.ansi().fg(color).toString();
        }
        return "";
    }

    static {
        COLOR_MAP.put("*", COLOR_EMPHASIS);
        COLOR_MAP.put("B", Ansi.Color.BLUE);
        COLOR_MAP.put("C", Ansi.Color.CYAN);
        COLOR_MAP.put("Y", Ansi.Color.YELLOW);
        COLOR_MAP.put("G", Ansi.Color.GREEN);
        COLOR_MAP.put("M", Ansi.Color.MAGENTA);
        COLOR_MAP.put("R", Ansi.Color.RED);
        COLOR_MAP.put("W", Ansi.Color.WHITE);
        COLOR_MAP.put("S", Ansi.Color.BLACK);
        COLOR_MAP.put("D", Ansi.Color.DEFAULT);
    }
}

