/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import com.google.common.base.Joiner;
import io.fabric8.maven.docker.assembly.DockerFileKeyword;
import io.fabric8.maven.docker.config.Arguments;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class DockerFileBuilder {
    private static final Joiner JOIN_ON_COMMA = Joiner.on((String)"\",\"");
    private String baseImage;
    private String maintainer;
    private String workdir = null;
    private String basedir = "/maven";
    private Arguments entryPoint;
    private Arguments cmd;
    private Boolean exportBasedir = null;
    private String assemblyUser;
    private String user;
    private List<AddEntry> addEntries = new ArrayList<AddEntry>();
    private List<Integer> ports = new ArrayList<Integer>();
    private List<String> runCmds = new ArrayList<String>();
    private Map<String, String> envEntries = new HashMap<String, String>();
    private Map<String, String> labels = new HashMap<String, String>();
    private List<String> volumes = new ArrayList<String>();
    private boolean shouldOptimise = false;

    public File write(File destDir) throws IOException {
        File target = new File(destDir, "Dockerfile");
        FileUtils.fileWrite((File)target, (String)this.content());
        return target;
    }

    public String content() throws IllegalArgumentException {
        StringBuilder b = new StringBuilder();
        DockerFileKeyword.FROM.addTo(b, this.baseImage != null ? this.baseImage : "busybox:latest");
        if (this.maintainer != null) {
            DockerFileKeyword.MAINTAINER.addTo(b, this.maintainer);
        }
        this.addOptimisation();
        this.addEnv(b);
        this.addLabels(b);
        this.addPorts(b);
        this.addEntries(b);
        this.addWorkdir(b);
        this.addRun(b);
        this.addVolumes(b);
        this.addCmd(b);
        this.addEntryPoint(b);
        this.addUser(b);
        return b.toString();
    }

    private void addUser(StringBuilder b) {
        if (this.user != null) {
            DockerFileKeyword.USER.addTo(b, this.user);
        }
    }

    private void addWorkdir(StringBuilder b) {
        if (this.workdir != null) {
            DockerFileKeyword.WORKDIR.addTo(b, this.workdir);
        }
    }

    private void addEntryPoint(StringBuilder b) {
        if (this.entryPoint != null) {
            DockerFileBuilder.buildArguments(b, DockerFileKeyword.ENTRYPOINT, this.entryPoint);
        }
    }

    private void addCmd(StringBuilder b) {
        if (this.cmd != null) {
            DockerFileBuilder.buildArguments(b, DockerFileKeyword.CMD, this.cmd);
        }
    }

    private static void buildArguments(StringBuilder b, DockerFileKeyword key, Arguments arguments) {
        String arg = arguments.getShell() != null ? arguments.getShell() : "[\"" + JOIN_ON_COMMA.join(arguments.getExec()) + "\"]";
        key.addTo(b, arg);
    }

    private void addEntries(StringBuilder b) {
        if (this.assemblyUser != null) {
            String tmpDir = this.createTempDir();
            this.copyAddEntries(b, tmpDir);
            String[] userParts = StringUtils.split((String)this.assemblyUser, (String)":");
            String userArg = userParts.length > 1 ? userParts[0] + ":" + userParts[1] : userParts[0];
            String chmod = "chown -R " + userArg + " " + tmpDir + " && cp -rp " + tmpDir + "/* / && rm -rf " + tmpDir;
            if (userParts.length > 2) {
                DockerFileKeyword.USER.addTo(b, "root");
                DockerFileKeyword.RUN.addTo(b, chmod);
                DockerFileKeyword.USER.addTo(b, userParts[2]);
            } else {
                DockerFileKeyword.RUN.addTo(b, chmod);
            }
        } else {
            this.copyAddEntries(b, "");
        }
    }

    private String createTempDir() {
        return "/tmp/" + UUID.randomUUID().toString();
    }

    private void copyAddEntries(StringBuilder b, String topLevelDir) {
        for (AddEntry entry : this.addEntries) {
            String dest = topLevelDir + (this.basedir.equals("/") ? "" : this.basedir) + "/" + entry.destination;
            DockerFileKeyword.COPY.addTo(b, entry.source, dest);
        }
    }

    private void addEnv(StringBuilder b) {
        this.addMap(b, DockerFileKeyword.ENV, this.envEntries);
    }

    private void addLabels(StringBuilder b) {
        this.addMap(b, DockerFileKeyword.LABEL, this.labels);
    }

    private void addMap(StringBuilder b, DockerFileKeyword keyword, Map<String, String> map) {
        if (map != null && map.size() > 0) {
            String[] entries = new String[map.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                entries[i++] = this.quote(entry.getKey()) + "=" + this.quote(entry.getValue());
            }
            keyword.addTo(b, entries);
        }
    }

    private String quote(String value) {
        return StringUtils.quoteAndEscape((String)value, (char)'\"');
    }

    private void addPorts(StringBuilder b) {
        if (this.ports.size() > 0) {
            String[] portsS = new String[this.ports.size()];
            int i = 0;
            for (Integer port : this.ports) {
                portsS[i++] = port.toString();
            }
            DockerFileKeyword.EXPOSE.addTo(b, portsS);
        }
    }

    private void addOptimisation() {
        if (this.runCmds != null && !this.runCmds.isEmpty() && this.shouldOptimise) {
            String optimisedRunCmd = StringUtils.join(this.runCmds.iterator(), (String)" && ");
            this.runCmds.clear();
            this.runCmds.add(optimisedRunCmd);
        }
    }

    private void addRun(StringBuilder b) {
        for (String run : this.runCmds) {
            DockerFileKeyword.RUN.addTo(b, run);
        }
    }

    private void addVolumes(StringBuilder b) {
        if (this.exportBasedir != null ? this.exportBasedir != false : this.baseImage == null) {
            this.addVolume(b, this.basedir);
        }
        for (String volume : this.volumes) {
            this.addVolume(b, volume);
        }
    }

    private void addVolume(StringBuilder buffer, String volume) {
        while (volume.endsWith("/")) {
            volume = volume.substring(0, volume.length() - 1);
        }
        if (volume.length() > 0) {
            DockerFileKeyword.VOLUME.addTo(buffer, "[\"" + volume + "\"]");
        }
    }

    public DockerFileBuilder baseImage(String baseImage) {
        if (baseImage != null) {
            this.baseImage = baseImage;
        }
        return this;
    }

    public DockerFileBuilder maintainer(String maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    public DockerFileBuilder workdir(String workdir) {
        this.workdir = workdir;
        return this;
    }

    public DockerFileBuilder basedir(String dir) {
        if (dir != null) {
            if (!dir.startsWith("/")) {
                throw new IllegalArgumentException("'basedir' must be an absolute path starting with / (and not '" + this.basedir + "')");
            }
            this.basedir = dir;
        }
        return this;
    }

    public DockerFileBuilder cmd(Arguments cmd) {
        this.cmd = cmd;
        return this;
    }

    public DockerFileBuilder entryPoint(Arguments entryPoint) {
        this.entryPoint = entryPoint;
        return this;
    }

    public DockerFileBuilder assemblyUser(String assemblyUser) {
        this.assemblyUser = assemblyUser;
        return this;
    }

    public DockerFileBuilder user(String user) {
        this.user = user;
        return this;
    }

    public DockerFileBuilder add(String source, String destination) {
        this.addEntries.add(new AddEntry(source, destination));
        return this;
    }

    public DockerFileBuilder expose(List<String> ports) {
        if (ports != null) {
            for (String port : ports) {
                if (port == null) continue;
                try {
                    this.ports.add(Integer.parseInt(port));
                }
                catch (NumberFormatException exp) {
                    throw new IllegalArgumentException("Non numeric port " + port + " specified in port mapping", exp);
                }
            }
        }
        return this;
    }

    public DockerFileBuilder run(List<String> runCmds) {
        if (runCmds != null) {
            for (String cmd : runCmds) {
                if (StringUtils.isEmpty((String)cmd)) continue;
                this.runCmds.add(cmd);
            }
        }
        return this;
    }

    public DockerFileBuilder exportBasedir(Boolean exportBasedir) {
        this.exportBasedir = exportBasedir;
        return this;
    }

    public DockerFileBuilder env(Map<String, String> values) {
        if (values != null) {
            this.envEntries.putAll(values);
            this.validateMap(this.envEntries);
        }
        return this;
    }

    public DockerFileBuilder labels(Map<String, String> values) {
        if (values != null) {
            this.labels.putAll(values);
            this.validateMap(this.labels);
        }
        return this;
    }

    public DockerFileBuilder volumes(List<String> volumes) {
        if (volumes != null) {
            this.volumes.addAll(volumes);
        }
        return this;
    }

    public DockerFileBuilder optimise() {
        this.shouldOptimise = true;
        return this;
    }

    private void validateMap(Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (entry.getValue() != null && entry.getValue().length() != 0) continue;
            throw new IllegalArgumentException("Environment variable '" + entry.getKey() + "' must not be null or empty if building an image");
        }
    }

    private static final class AddEntry {
        private String source;
        private String destination;

        private AddEntry(String src, String dest) {
            this.source = src;
            this.destination = dest;
            while (this.destination.startsWith("/")) {
                this.destination = this.destination.substring(1);
            }
        }
    }
}

