/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.util.EnvUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class Arguments {
    @Parameter
    private String shell;
    @Parameter
    private List<String> exec;
    private List<String> execInlined = new ArrayList<String>();

    public Arguments() {
        this(null);
    }

    public Arguments(String shell) {
        this.shell = shell;
    }

    public void set(String shell) {
        this.setShell(shell);
    }

    public void setShell(String shell) {
        this.shell = shell;
    }

    public String getShell() {
        return this.shell;
    }

    public void setExec(List<String> exec) {
        this.exec = exec;
    }

    public void setArg(String arg) {
        this.execInlined.add(arg);
    }

    public List<String> getExec() {
        return this.exec == null ? this.execInlined : this.exec;
    }

    public void validate() throws IllegalArgumentException {
        int valueSources = 0;
        if (this.shell != null) {
            ++valueSources;
        }
        if (this.exec != null && !this.exec.isEmpty()) {
            ++valueSources;
        }
        if (!this.execInlined.isEmpty()) {
            ++valueSources;
        }
        if (valueSources != 1) {
            throw new IllegalArgumentException("Argument conflict: either shell or args should be specified and only in one form.");
        }
    }

    public List<String> asStrings() {
        if (this.shell != null) {
            return Arrays.asList(EnvUtil.splitOnSpaceWithEscape(this.shell));
        }
        if (this.exec != null) {
            return Collections.unmodifiableList(this.exec);
        }
        return Collections.unmodifiableList(this.execInlined);
    }

    public static class Builder {
        private String shell;
        private List<String> params;

        public static Builder get() {
            return new Builder();
        }

        public Builder withShell(String shell) {
            this.shell = shell;
            return this;
        }

        public Builder withParam(String param) {
            if (this.params == null) {
                this.params = new ArrayList<String>();
            }
            this.params.add(param);
            return this;
        }

        public Arguments build() {
            Arguments a = new Arguments();
            a.setShell(this.shell);
            a.setExec(this.params);
            return a;
        }
    }
}

