/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.log;

import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.log.LogOutputSpec;
import io.fabric8.maven.docker.util.Timestamp;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;

public class DefaultLogCallback
implements LogCallback {
    private final LogOutputSpec outputSpec;
    private PrintStream ps;

    public DefaultLogCallback(LogOutputSpec outputSpec) throws FileNotFoundException {
        this.outputSpec = outputSpec;
        this.ps = this.createPrintStream(outputSpec.isLogStdout(), outputSpec.getFile());
    }

    private PrintStream createPrintStream(boolean logStdout, String file) throws FileNotFoundException {
        return !logStdout && file != null ? new PrintStream(new FileOutputStream(file), true) : System.out;
    }

    @Override
    public void log(int type, Timestamp timestamp, String txt) {
        this.addLogEntry(this.ps, new LogEntry(type, timestamp, txt));
    }

    @Override
    public void error(String error) {
        this.ps.println(error);
    }

    private void addLogEntry(PrintStream ps, LogEntry logEntry) {
        LogOutputSpec spec = this.outputSpec;
        if (spec == null) {
            spec = LogOutputSpec.DEFAULT;
        }
        String text = logEntry.getText();
        ps.println(spec.getPrompt(spec.isUseColor(), logEntry.getTimestamp()) + text);
    }

    private static class LogEntry
    implements Comparable<LogEntry> {
        private final int type;
        private final Timestamp timestamp;
        private final String text;

        public LogEntry(int type, Timestamp timestamp, String text) {
            this.type = type;
            this.timestamp = timestamp;
            this.text = text;
        }

        public int getType() {
            return this.type;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public int compareTo(LogEntry entry) {
            return this.timestamp.compareTo(entry.timestamp);
        }
    }
}

