/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public class NetworkConfig {
    @Parameter
    private String name;
    @Parameter
    private Mode mode;
    private List<String> aliases = new ArrayList<String>();

    public void addAlias(String alias) {
        this.aliases.add(alias);
    }

    public NetworkConfig(String net) {
        this.initLegacyNetSpec(net);
    }

    public NetworkConfig(Mode mode, String name) {
        this.name = name;
        this.mode = mode;
    }

    public NetworkConfig() {
        this.name = null;
        this.mode = null;
    }

    private void initLegacyNetSpec(String net) {
        if (net != null) {
            this.mode = this.extractMode(net);
            this.name = this.mode == Mode.container ? net.substring(Mode.container.name().length() + 1) : (this.mode == Mode.custom ? net : null);
        } else {
            this.mode = null;
            this.name = null;
        }
    }

    private Mode extractMode(String mode) {
        if (mode != null && mode.length() > 0) {
            try {
                return Mode.valueOf(mode.toLowerCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (mode.toLowerCase().startsWith(Mode.container.name() + ":")) {
                    return Mode.container;
                }
                return Mode.custom;
            }
        }
        return null;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public boolean isCustomNetwork() {
        return this.mode != null && this.mode == Mode.custom || this.mode == null && this.name != null;
    }

    public boolean isStandardNetwork() {
        return this.mode != null && this.mode != Mode.custom;
    }

    public String getStandardMode(String containerId) {
        if (this.isCustomNetwork()) {
            throw new IllegalArgumentException("Custom network for network '" + this.name + "' can not be used as standard mode");
        }
        if (this.mode == null) {
            return null;
        }
        return this.mode.name().toLowerCase() + (this.mode == Mode.container ? ":" + containerId : "");
    }

    public String getContainerAlias() {
        return this.mode == Mode.container ? this.name : null;
    }

    public String getCustomNetwork() {
        return this.mode == Mode.custom || this.mode == null ? this.name : null;
    }

    public boolean hasAliases() {
        return !this.aliases.isEmpty();
    }

    public static class Builder {
        private final NetworkConfig config = new NetworkConfig();
        private boolean isEmpty = true;

        public NetworkConfig build() {
            return this.isEmpty ? null : this.config;
        }

        public Builder mode(String mode) {
            this.config.mode = this.set(mode != null ? Mode.valueOf(mode) : null);
            return this;
        }

        public Builder name(String name) {
            this.config.name = this.set(name);
            return this;
        }

        public Builder aliases(List<String> aliases) {
            this.config.aliases = this.set(aliases);
            return this;
        }

        private <T> T set(T prop) {
            if (prop != null) {
                this.isEmpty = false;
            }
            return prop;
        }
    }

    public static enum Mode {
        none,
        bridge,
        host,
        container,
        custom;

    }
}

