/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.access.util.LocalSocketUtil;
import io.fabric8.maven.docker.util.SuffixFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DockerConnectionDetector {
    final List<DockerHostProvider> dockerHostProviders = new ArrayList<DockerHostProvider>();

    public DockerConnectionDetector(List<DockerHostProvider> externalProviders) {
        this.dockerHostProviders.addAll(this.getDefaultEnvProviders());
        if (externalProviders != null) {
            this.dockerHostProviders.addAll(externalProviders);
        }
        Collections.sort(this.dockerHostProviders, new DockerHostProvider.Comparator());
    }

    private Collection<? extends DockerHostProvider> getDefaultEnvProviders() {
        return Arrays.asList(new EnvDockerHostProvider(), new UnixSocketDockerHostProvider(), new WindowsPipeDockerHostProvider());
    }

    public String extractUrl(String dockerHost) throws IOException {
        if (dockerHost != null) {
            return dockerHost;
        }
        for (DockerHostProvider provider : this.dockerHostProviders) {
            String value = provider.getDockerHost();
            if (value == null) continue;
            return value;
        }
        throw new IllegalArgumentException("No <dockerHost> given, no DOCKER_HOST environment variable, no read/writable '/var/run/docker.sock' or '//./pipe/docker_engine' and no external provider like Docker machine configured");
    }

    public String getCertPath(String certPath) throws IOException {
        File dockerHome;
        if (certPath != null) {
            return certPath;
        }
        String path = System.getenv("DOCKER_CERT_PATH");
        if (path == null && (dockerHome = new File(System.getProperty("user.home") + "/.docker")).isDirectory() && dockerHome.list(SuffixFileFilter.PEM_FILTER).length > 0) {
            return dockerHome.getAbsolutePath();
        }
        return path;
    }

    class WindowsPipeDockerHostProvider
    implements DockerHostProvider {
        WindowsPipeDockerHostProvider() {
        }

        @Override
        public String getDockerHost() throws IOException {
            File windowsPipe = new File("//./pipe/docker_engine");
            if (windowsPipe.exists()) {
                return "npipe:////./pipe/docker_engine";
            }
            return null;
        }

        @Override
        public int getPriority() {
            return 50;
        }
    }

    class UnixSocketDockerHostProvider
    implements DockerHostProvider {
        UnixSocketDockerHostProvider() {
        }

        @Override
        public String getDockerHost() throws IOException {
            File unixSocket = new File("/var/run/docker.sock");
            if (unixSocket.exists() && unixSocket.canRead() && unixSocket.canWrite() && LocalSocketUtil.canConnectUnixSocket(unixSocket)) {
                return "unix:///var/run/docker.sock";
            }
            return null;
        }

        @Override
        public int getPriority() {
            return 55;
        }
    }

    class EnvDockerHostProvider
    implements DockerHostProvider {
        EnvDockerHostProvider() {
        }

        @Override
        public String getDockerHost() throws IOException {
            String connect = System.getenv("DOCKER_HOST");
            if (connect != null) {
                String protocol = connect.contains(":2376") ? "https:" : "http:";
                return connect.replaceFirst("^tcp:", protocol);
            }
            return null;
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }

    public static interface DockerHostProvider {
        public String getDockerHost() throws IOException;

        public int getPriority();

        public static class Comparator
        implements java.util.Comparator<DockerHostProvider> {
            @Override
            public int compare(DockerHostProvider o1, DockerHostProvider o2) {
                return o2.getPriority() - o1.getPriority();
            }
        }
    }
}

