/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.util.SuffixFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class DockerConnectionDetector {
    private final List<DockerEnvProvider> envProviders;

    public DockerConnectionDetector(List<DockerEnvProvider> envProviders) {
        this.envProviders = envProviders != null ? envProviders : Collections.EMPTY_LIST;
    }

    public String extractUrl(String dockerHost) throws IOException {
        String connect = this.getValueWithFallback(dockerHost, "DOCKER_HOST");
        if (connect != null) {
            String protocol = connect.contains(":2376") ? "https:" : "http:";
            return connect.replaceFirst("^tcp:", protocol);
        }
        File unixSocket = new File("/var/run/docker.sock");
        if (unixSocket.exists() && unixSocket.canRead() && unixSocket.canWrite()) {
            return "unix:///var/run/docker.sock";
        }
        File windowsPipe = new File("//./pipe/docker_engine");
        if (windowsPipe.exists()) {
            return "npipe:////./pipe/docker_engine";
        }
        throw new IllegalArgumentException("No <dockerHost> or <machine> given, no DOCKER_HOST environment variable, and no read/writable '/var/run/docker.sock' or '//./pipe/docker_engine'");
    }

    public String getCertPath(String certPath) throws IOException {
        File dockerHome;
        String path = this.getValueWithFallback(certPath, "DOCKER_CERT_PATH");
        if (path == null && (dockerHome = new File(System.getProperty("user.home") + "/.docker")).isDirectory() && dockerHome.list(SuffixFileFilter.PEM_FILTER).length > 0) {
            return dockerHome.getAbsolutePath();
        }
        return path;
    }

    private String getValueWithFallback(String value, String envVar) throws IOException {
        if (value != null) {
            return value;
        }
        value = System.getenv(envVar);
        if (value != null) {
            return value;
        }
        for (DockerEnvProvider envProvider : this.envProviders) {
            value = envProvider.getEnvVar(envVar);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static interface DockerEnvProvider {
        public String getEnvVar(String var1) throws IOException;
    }
}

