/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.Network;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.PomLabel;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
@Execute(phase=LifecyclePhase.INITIALIZE)
public class StopMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.keepRunning", defaultValue="false")
    private boolean keepRunning;
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;

    @Override
    protected void executeInternal(ServiceHub hub) throws MojoExecutionException, DockerAccessException {
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        PomLabel pomLabel = this.getPomLabel();
        if (!this.keepRunning) {
            if (this.invokedTogetherWithDockerStart()) {
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, pomLabel);
            } else {
                this.stopContainers(queryService, runService, pomLabel);
            }
        }
        LogDispatcher dispatcher = this.getLogDispatcher(hub);
        dispatcher.untrackAllContainerLogs();
    }

    private void stopContainers(QueryService queryService, RunService runService, PomLabel pomLabel) throws DockerAccessException {
        Set<Network> networksToRemove = this.getNetworksToRemove(queryService, pomLabel);
        for (ImageConfiguration image : this.getResolvedImages()) {
            for (Container container : this.getContainersToStop(queryService, image)) {
                if (!this.shouldStopContainer(container, pomLabel)) continue;
                runService.stopContainer(container.getId(), image, this.keepContainer, this.removeVolumes);
            }
        }
        runService.removeCustomNetworks(networksToRemove);
    }

    private List<Container> getContainersToStop(QueryService queryService, ImageConfiguration image) throws DockerAccessException {
        Container container;
        RunImageConfiguration.NamingStrategy strategy = image.getRunConfiguration().getNamingStrategy();
        List<Container> containers = strategy == RunImageConfiguration.NamingStrategy.alias ? ((container = queryService.getContainer(image.getAlias())) != null ? Collections.singletonList(container) : Collections.emptyList()) : queryService.getContainersForImage(image.getName());
        return containers;
    }

    private boolean shouldStopContainer(Container container, PomLabel pomLabel) {
        if (this.isStopAllContainers()) {
            return true;
        }
        String key = pomLabel.getKey();
        Map<String, String> labels = container.getLabels();
        return labels.containsKey(key) && pomLabel.equals(new PomLabel(labels.get(key)));
    }

    private boolean isStopAllContainers() {
        for (String prop : new String[]{"docker.allContainers", "docker.sledgeHammer"}) {
            String val = System.getProperty(prop);
            if (val == null || !Boolean.valueOf(val).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean invokedTogetherWithDockerStart() {
        Boolean startCalled = (Boolean)this.getPluginContext().get("CONTEXT_KEY_DOCKER_START_CALLED");
        return startCalled != null && startCalled != false;
    }

    private Set<Network> getNetworksToRemove(QueryService queryService, PomLabel pomLabel) throws DockerAccessException {
        if (!this.autoCreateCustomNetworks) {
            return Collections.emptySet();
        }
        HashSet<Network> customNetworks = new HashSet<Network>();
        Set<Network> networks = queryService.getNetworks();
        for (ImageConfiguration image : this.getResolvedImages()) {
            Network network;
            NetworkConfig config = image.getRunConfiguration().getNetworkingConfig();
            if (!config.isCustomNetwork() || (network = this.getNetworkByName(networks, config.getCustomNetwork())) == null) continue;
            customNetworks.add(network);
            for (Container container : this.getContainersToStop(queryService, image)) {
                if (this.shouldStopContainer(container, pomLabel)) continue;
                customNetworks.remove(network);
            }
        }
        return customNetworks;
    }

    private Network getNetworkByName(Set<Network> networks, String networkName) {
        for (Network network : networks) {
            if (!networkName.equals(network.getName())) continue;
            return network;
        }
        return null;
    }
}

