/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.util.MojoParameters;
import io.fabric8.maven.docker.util.SuffixFileFilter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public class EnvUtil {
    public static final String MAVEN_PROPERTY_REGEXP = "\\s*\\$\\{\\s*([^}]+)\\s*}\\s*$";
    public static final String DOCKER_HTTPS_PORT = "2376";

    private EnvUtil() {
    }

    public static String extractUrl(String dockerHost) {
        String connect;
        String string = connect = dockerHost != null ? dockerHost : System.getenv("DOCKER_HOST");
        if (connect == null) {
            File unixSocket = new File("/var/run/docker.sock");
            if (unixSocket.exists() && unixSocket.canRead() && unixSocket.canWrite()) {
                connect = "unix:///var/run/docker.sock";
            } else {
                throw new IllegalArgumentException("No url given, no DOCKER_HOST environment variable and no read/writable '/var/run/docker.sock'");
            }
        }
        String protocol = connect.contains(":2376") ? "https:" : "http:";
        return connect.replaceFirst("^tcp:", protocol);
    }

    public static String getCertPath(String certPath) {
        File dockerHome;
        String path;
        String string = path = certPath != null ? certPath : System.getenv("DOCKER_CERT_PATH");
        if (path == null && (dockerHome = new File(System.getProperty("user.home") + "/.docker")).isDirectory() && dockerHome.list(SuffixFileFilter.PEM_FILTER).length > 0) {
            return dockerHome.getAbsolutePath();
        }
        return path;
    }

    public static String extractLargerVersion(String versionA, String versionB) {
        if (versionB == null || versionA == null) {
            return versionA == null ? versionB : versionA;
        }
        return Float.parseFloat(versionA) > Float.parseFloat(versionB) ? versionA : versionB;
    }

    public static List<String[]> splitOnLastColon(List<String> listToSplit) {
        if (listToSplit != null) {
            ArrayList<String[]> ret = new ArrayList<String[]>();
            for (String element : listToSplit) {
                String[] p = element.split(":");
                String rightValue = p[p.length - 1];
                Object[] nameParts = Arrays.copyOfRange(p, 0, p.length - 1);
                String leftValue = StringUtils.join((Object[])nameParts, (String)":");
                if (leftValue.length() == 0) {
                    leftValue = rightValue;
                }
                ret.add(new String[]{leftValue, rightValue});
            }
            return ret;
        }
        return Collections.emptyList();
    }

    public static String[] splitOnSpaceWithEscape(String toSplit) {
        String[] split = toSplit.split("(?<!" + Pattern.quote("\\") + ")\\s+");
        String[] res = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            res[i] = split[i].replaceAll("\\\\ ", " ");
        }
        return res;
    }

    public static String stringJoin(List list, String separator) {
        StringBuilder ret = new StringBuilder();
        boolean first = true;
        for (Object o : list) {
            if (!first) {
                ret.append(separator);
            }
            ret.append(o);
            first = false;
        }
        return ret.toString();
    }

    public static Map<String, String> extractFromPropertiesAsMap(String prefix, Properties properties) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Enumeration<?> names = properties.propertyNames();
        String prefixP = prefix + ".";
        while (names.hasMoreElements()) {
            String propName = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixP, propName)) continue;
            String mapKey = propName.substring(prefixP.length());
            ret.put(mapKey, properties.getProperty(propName));
        }
        return ret.size() > 0 ? ret : null;
    }

    public static List<String> extractFromPropertiesAsList(String prefix, Properties properties) {
        TreeMap<Integer, String> orderedMap = new TreeMap<Integer, String>();
        ArrayList<String> rest = new ArrayList<String>();
        Enumeration<?> names = properties.propertyNames();
        String prefixP = prefix + ".";
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (!EnvUtil.propMatchesPrefix(prefixP, key)) continue;
            String index = key.substring(prefixP.length());
            String value = properties.getProperty(key);
            try {
                Integer nrIndex = Integer.parseInt(index);
                orderedMap.put(nrIndex, value);
            }
            catch (NumberFormatException exp) {
                rest.add(value);
            }
        }
        ArrayList<String> ret = new ArrayList<String>(orderedMap.values());
        ret.addAll(rest);
        return ret.size() > 0 ? ret : null;
    }

    public static String extractMavenPropertyName(String propName) {
        Matcher matcher = Pattern.compile(MAVEN_PROPERTY_REGEXP).matcher(propName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String fixupPath(String path) {
        Pattern pattern = Pattern.compile("^(?i)([A-Z]):(.*)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            String result = "/" + matcher.group(1).toLowerCase() + matcher.group(2);
            return result.replace("\\", "/");
        }
        return path;
    }

    public static String formatDurationTill(long start) {
        long duration = System.currentTimeMillis() - start;
        StringBuilder res = new StringBuilder();
        TimeUnit current = TimeUnit.HOURS;
        while (duration > 0L) {
            long temp = current.convert(duration, TimeUnit.MILLISECONDS);
            if (temp > 0L) {
                duration -= current.toMillis(temp);
                res.append(temp).append(" ").append(current.name().toLowerCase());
                if (temp < 2L) {
                    res.deleteCharAt(res.length() - 1);
                }
                res.append(", ");
            }
            if (current == TimeUnit.SECONDS) break;
            current = TimeUnit.values()[current.ordinal() - 1];
        }
        if (res.lastIndexOf(", ") < 0) {
            return duration + " " + TimeUnit.MILLISECONDS.name().toLowerCase();
        }
        res.deleteCharAt(res.length() - 2);
        int i = res.lastIndexOf(", ");
        if (i > 0) {
            res.deleteCharAt(i);
            res.insert(i, " and");
        }
        return res.toString();
    }

    private static boolean propMatchesPrefix(String prefix, String key) {
        return key.startsWith(prefix) && key.length() >= prefix.length();
    }

    public static String findRegistry(String ... checkFirst) {
        for (String registry : checkFirst) {
            if (registry == null) continue;
            return registry;
        }
        return System.getenv("DOCKER_REGISTRY");
    }

    public static File prepareAbsoluteOutputDirPath(MojoParameters params, String dir, String path) {
        return EnvUtil.prepareAbsolutePath(params, new File(params.getOutputDirectory(), dir).toString(), path);
    }

    public static File prepareAbsoluteSourceDirPath(MojoParameters params, String path) {
        return EnvUtil.prepareAbsolutePath(params, params.getSourceDirectory(), path);
    }

    private static File prepareAbsolutePath(MojoParameters params, String directory, String path) {
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(new File(params.getProject().getBasedir(), directory), path);
    }

    public static void storeTimestamp(File tsFile, Date buildDate) throws MojoExecutionException {
        try {
            if (tsFile.exists()) {
                tsFile.delete();
            }
            FileUtils.fileWrite((File)tsFile, (String)StandardCharsets.US_ASCII.name(), (String)Long.toString(buildDate.getTime()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create " + tsFile + " for storing time " + buildDate.getTime(), (Exception)e);
        }
    }

    public static Date loadTimestamp(File tsFile) throws MojoExecutionException {
        try {
            if (tsFile.exists()) {
                String ts = FileUtils.fileRead((File)tsFile);
                return new Date(Long.parseLong(ts));
            }
            return null;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot read timestamp " + tsFile, (Exception)e);
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

