/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import java.util.List;

public class WaitConfiguration {
    private int time;
    private String url;
    private HttpConfiguration http;
    private ExecConfiguration exec;
    private TcpConfiguration tcp;
    private String log;
    private int shutdown;
    private int kill;

    public WaitConfiguration() {
    }

    private WaitConfiguration(int time, ExecConfiguration exec, HttpConfiguration http, TcpConfiguration tcp, String log, int shutdown, int kill) {
        this.time = time;
        this.exec = exec;
        this.http = http;
        this.tcp = tcp;
        this.log = log;
        this.shutdown = shutdown;
        this.kill = kill;
    }

    public int getTime() {
        return this.time;
    }

    public String getUrl() {
        return this.http != null ? this.http.getUrl() : this.url;
    }

    public ExecConfiguration getExec() {
        return this.exec;
    }

    public HttpConfiguration getHttp() {
        return this.http;
    }

    public TcpConfiguration getTcp() {
        return this.tcp;
    }

    public String getLog() {
        return this.log;
    }

    public int getShutdown() {
        return this.shutdown;
    }

    public int getKill() {
        return this.kill;
    }

    public static class TcpConfiguration {
        private String host;
        private List<Integer> ports;

        public TcpConfiguration() {
        }

        private TcpConfiguration(String host, List<Integer> ports) {
            this.host = host;
            this.ports = ports;
        }

        public String getHost() {
            return this.host;
        }

        public List<Integer> getPorts() {
            return this.ports;
        }
    }

    public static class HttpConfiguration {
        private String url;
        private String method;
        private String status;

        public HttpConfiguration() {
        }

        private HttpConfiguration(String url, String method, String status) {
            this.url = url;
            this.method = method;
        }

        public String getUrl() {
            return this.url;
        }

        public String getMethod() {
            return this.method;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public static class ExecConfiguration {
        private String postStart;
        private String preStop;

        public ExecConfiguration() {
        }

        public ExecConfiguration(String postStart, String preStop) {
            this.postStart = postStart;
            this.preStop = preStop;
        }

        public String getPostStart() {
            return this.postStart;
        }

        public String getPreStop() {
            return this.preStop;
        }
    }

    public static class Builder {
        private int time = 0;
        private int shutdown = 0;
        private int kill = 0;
        private String url;
        private String log;
        private String status;
        private String method;
        private String preStop;
        private String postStart;
        private List<Integer> tcpPorts;
        private String tcpHost;

        public Builder time(int time) {
            this.time = time;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder log(String log) {
            this.log = log;
            return this;
        }

        public Builder shutdown(int shutdown) {
            this.shutdown = shutdown;
            return this;
        }

        public Builder kill(int kill) {
            this.kill = kill;
            return this;
        }

        public Builder tcpPorts(List<Integer> tcpPorts) {
            this.tcpPorts = tcpPorts;
            return this;
        }

        public Builder tcpHost(String tcpHost) {
            this.tcpHost = tcpHost;
            return this;
        }

        public WaitConfiguration build() {
            return new WaitConfiguration(this.time, this.postStart != null || this.preStop != null ? new ExecConfiguration(this.postStart, this.preStop) : null, this.url != null ? new HttpConfiguration(this.url, this.method, this.status) : null, this.tcpPorts != null ? new TcpConfiguration(this.tcpHost, this.tcpPorts) : null, this.log, this.shutdown, this.kill);
        }

        public Builder preStop(String command) {
            this.preStop = command;
            return this;
        }

        public Builder postStart(String command) {
            this.postStart = command;
            return this;
        }
    }
}

