/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static List<ImageConfiguration> resolveImages(List<ImageConfiguration> images, Resolver imageResolver, String imageNameFilter, Customizer imageCustomizer) {
        List<ImageConfiguration> ret = ConfigHelper.resolveConfiguration(imageResolver, images);
        ret = imageCustomizer.customizeConfig(ret);
        return ConfigHelper.filterImages(imageNameFilter, ret);
    }

    public static String initAndValidate(List<ImageConfiguration> images, String apiVersion, Logger log) {
        return ConfigHelper.initAndValidateConfiguration(apiVersion, log, images);
    }

    public static boolean matchesConfiguredImages(String imageList, ImageConfiguration imageConfig) {
        if (imageList == null) {
            return true;
        }
        HashSet<String> imagesAllowed = new HashSet<String>(Arrays.asList(imageList.split("\\s*,\\s*")));
        return imagesAllowed.contains(imageConfig.getName()) || imagesAllowed.contains(imageConfig.getAlias());
    }

    private static List<ImageConfiguration> filterImages(String nameFilter, List<ImageConfiguration> imagesToFilter) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : imagesToFilter) {
            if (!ConfigHelper.matchesConfiguredImages(nameFilter, imageConfig)) continue;
            ret.add(imageConfig);
        }
        return ret;
    }

    private static List<ImageConfiguration> resolveConfiguration(Resolver imageResolver, List<ImageConfiguration> unresolvedImages) {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        if (unresolvedImages != null) {
            for (ImageConfiguration image : unresolvedImages) {
                ret.addAll(imageResolver.resolve(image));
            }
            ConfigHelper.verifyImageNames(ret);
        }
        return ret;
    }

    private static String initAndValidateConfiguration(String initApiVersion, Logger log, List<ImageConfiguration> configsToInitAndValidate) {
        String apiVersion = initApiVersion;
        for (ImageConfiguration imageConfiguration : configsToInitAndValidate) {
            apiVersion = EnvUtil.extractLargerVersion(apiVersion, imageConfiguration.initAndValidate(log));
        }
        return apiVersion;
    }

    private static void verifyImageNames(List<ImageConfiguration> ret) {
        for (ImageConfiguration config : ret) {
            if (config.getName() != null) continue;
            throw new IllegalArgumentException("Configuration error: <image> must have a non-null <name>");
        }
    }

    public static interface Resolver {
        public List<ImageConfiguration> resolve(ImageConfiguration var1);
    }

    public static interface Customizer {
        public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> var1);
    }
}

