/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import com.google.common.collect.ImmutableMap;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.CleanupMode;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;

public class BuildService {
    private final DockerAccess docker;
    private final QueryService queryService;
    public final ArchiveService archiveService;
    private final Logger log;

    BuildService(DockerAccess docker, QueryService queryService, ArchiveService archiveService, Logger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.archiveService = archiveService;
        this.log = log;
    }

    public void buildImage(ImageConfiguration imageConfig, MojoParameters params, boolean noCache, Map<String, String> buildArgs) throws DockerAccessException, MojoExecutionException {
        String imageName = imageConfig.getName();
        ImageName.validate(imageName);
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String oldImageId = null;
        CleanupMode cleanupMode = buildConfig.cleanupMode();
        if (cleanupMode.isRemove()) {
            oldImageId = this.queryService.getImageId(imageName);
        }
        File dockerArchive = this.archiveService.createArchive(imageName, buildConfig, params);
        Map<String, String> mergedBuildMap = this.prepareBuildArgs(buildArgs, buildConfig);
        String newImageId = this.doBuildImage(imageName, dockerArchive, this.getDockerfileName(buildConfig), cleanupMode.isRemove(), noCache, mergedBuildMap);
        this.log.info(imageConfig.getDescription() + ": Built image " + newImageId, new Object[0]);
        if (oldImageId != null && !oldImageId.equals(newImageId)) {
            try {
                this.docker.removeImage(oldImageId, true);
                this.log.info(imageConfig.getDescription() + ": Removed image " + oldImageId, new Object[0]);
            }
            catch (DockerAccessException exp) {
                if (cleanupMode == CleanupMode.TRY_TO_REMOVE) {
                    this.log.warn(imageConfig.getDescription() + ": " + exp.getMessage() + " (old image)" + (exp.getCause() != null ? " [" + exp.getCause().getMessage() + "]" : ""), new Object[0]);
                }
                throw exp;
            }
        }
    }

    private Map<String, String> prepareBuildArgs(Map<String, String> buildArgs, BuildImageConfiguration buildConfig) {
        ImmutableMap.Builder builder = ImmutableMap.builder().putAll(buildArgs);
        if (buildConfig.getArgs() != null) {
            builder.putAll(buildConfig.getArgs());
        }
        return builder.build();
    }

    private String getDockerfileName(BuildImageConfiguration buildConfig) {
        if (buildConfig.isDockerFileMode()) {
            return buildConfig.getDockerFile().getName();
        }
        return null;
    }

    private String doBuildImage(String imageName, File dockerArchive, String dockerfileName, boolean cleanUp, boolean noCache, Map<String, String> buildArgs) throws DockerAccessException, MojoExecutionException {
        this.docker.buildImage(imageName, dockerArchive, dockerfileName, cleanUp, noCache, buildArgs);
        return this.queryService.getImageId(imageName);
    }
}

