/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugin.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugin.assembly.format.AssemblyFormattingException;

public class ArchiveService {
    private final Logger log;
    private DockerAssemblyManager dockerAssemblyManager;

    public ArchiveService(DockerAssemblyManager dockerAssemblyManager, Logger log) {
        this.log = log;
        this.dockerAssemblyManager = dockerAssemblyManager;
    }

    public File createDockerBuildArchive(ImageConfiguration imageConfig, MojoParameters params) throws MojoExecutionException {
        File ret = this.createArchive(imageConfig.getName(), imageConfig.getBuildConfiguration(), params);
        this.log.info(imageConfig.getDescription() + ": Created docker source tar " + ret, new Object[0]);
        return ret;
    }

    public AssemblyFiles getAssemblyFiles(ImageConfiguration imageConfig, MojoParameters mojoParameters) throws MojoExecutionException {
        String name = imageConfig.getName();
        try {
            return this.dockerAssemblyManager.getAssemblyFiles(name, imageConfig.getBuildConfiguration(), mojoParameters, this.log);
        }
        catch (InvalidAssemblerConfigurationException | ArchiveCreationException | AssemblyFormattingException e) {
            throw new MojoExecutionException("Cannot extract assembly files for image " + name + ": " + e, (Exception)e);
        }
    }

    public File createChangedFilesArchive(List<AssemblyFiles.Entry> entries, File assemblyDir, String imageName, MojoParameters mojoParameters) throws MojoExecutionException {
        return this.dockerAssemblyManager.createChangedFilesArchive(entries, assemblyDir, imageName, mojoParameters);
    }

    File createArchive(String imageName, BuildImageConfiguration buildConfig, MojoParameters params) throws MojoExecutionException {
        return this.dockerAssemblyManager.createDockerTarArchive(imageName, params, buildConfig);
    }
}

