/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.assembly;

import io.fabric8.maven.docker.assembly.AssemblyFiles;
import io.fabric8.maven.docker.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.InvalidArtifactRTException;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.diags.TrackingArchiver;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;

@Component(role=Archiver.class, hint="track", instantiationStrategy="singleton")
public class MappingTrackArchiver
extends TrackingArchiver {
    protected Logger log;
    private static final Pattern JAVA_ARCHIVE_DETECTOR = Pattern.compile("^.*\\.(jar|war|ear)$");

    public AssemblyFiles getAssemblyFiles(MavenSession session) {
        AssemblyFiles ret = new AssemblyFiles(this.getDestFile());
        for (TrackingArchiver.Addition addition : this.added) {
            Object resource = addition.resource;
            File target = new File(ret.getAssemblyDirectory(), addition.destination);
            if (resource instanceof File && addition.destination != null) {
                this.addFileEntry(ret, session, (File)resource, target);
                continue;
            }
            if (resource instanceof PlexusIoFileResource) {
                this.addFileEntry(ret, session, ((PlexusIoFileResource)resource).getFile(), target);
                continue;
            }
            if (resource instanceof FileSet) {
                FileSet fs = (FileSet)resource;
                DirectoryScanner ds = new DirectoryScanner();
                File base = addition.directory;
                ds.setBasedir(base);
                ds.setIncludes(fs.getIncludes());
                ds.setExcludes(fs.getExcludes());
                ds.setCaseSensitive(fs.isCaseSensitive());
                ds.scan();
                for (String f : ds.getIncludedFiles()) {
                    File source = new File(base, f);
                    File subTarget = new File(target, f);
                    this.addFileEntry(ret, session, source, subTarget);
                }
                continue;
            }
            throw new IllegalStateException("Unknown resource type " + resource.getClass() + ": " + resource);
        }
        return ret;
    }

    private void addFileEntry(AssemblyFiles ret, MavenSession session, File source, File target) {
        ret.addEntry(source, target);
        this.addLocalMavenRepoEntry(ret, session, source, target);
    }

    private void addLocalMavenRepoEntry(AssemblyFiles ret, MavenSession session, File source, File target) {
        File localMavenRepoFile = this.getLocalMavenRepoFile(session, source);
        try {
            if (localMavenRepoFile != null && !source.getCanonicalFile().equals(localMavenRepoFile.getCanonicalFile())) {
                ret.addEntry(localMavenRepoFile, target);
            }
        }
        catch (IOException e) {
            this.log.warn("Cannot add " + localMavenRepoFile + " for watching: " + e + ". Ignoring for watch ...", new Object[0]);
        }
    }

    private File getLocalMavenRepoFile(MavenSession session, File source) {
        ArtifactRepository localRepo = session.getLocalRepository();
        if (localRepo == null) {
            this.log.warn("No local repo found so not adding any extra watches in the local repository", new Object[0]);
            return null;
        }
        Artifact artifact = this.getArtifactFromJar(source);
        if (artifact != null) {
            try {
                return new File(localRepo.getBasedir(), localRepo.pathOf(artifact));
            }
            catch (InvalidArtifactRTException e) {
                this.log.warn("Cannot get the local repository path for " + artifact + " in base dir " + localRepo.getBasedir() + ": " + (Object)((Object)e), new Object[0]);
            }
        }
        return null;
    }

    private Artifact getArtifactFromJar(File jar) {
        String type = this.extractFileType(jar);
        if (type != null) {
            try {
                ArrayList<Properties> options = new ArrayList<Properties>();
                try (ZipInputStream in = new ZipInputStream(new FileInputStream(jar));){
                    ZipEntry entry;
                    while ((entry = in.getNextEntry()) != null) {
                        int len;
                        if (!entry.getName().startsWith("META-INF/maven/") || !entry.getName().endsWith("pom.properties")) continue;
                        byte[] buf = new byte[1024];
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        while ((len = in.read(buf)) > 0) {
                            out.write(buf, 0, len);
                        }
                        Properties properties = new Properties();
                        properties.load(new ByteArrayInputStream(out.toByteArray()));
                        options.add(properties);
                    }
                }
                if (options.size() == 1) {
                    return this.getArtifactFromPomProperties(type, (Properties)options.get(0));
                }
                this.log.warn("Found " + options.size() + " pom.properties in " + jar, new Object[0]);
            }
            catch (IOException e) {
                this.log.warn("IO Exception while examing " + jar + " for maven coordinates: " + e + ". Ignoring for watching ...", new Object[0]);
            }
        }
        return null;
    }

    private String extractFileType(File source) {
        Matcher matcher = JAVA_ARCHIVE_DETECTOR.matcher(source.getName());
        return matcher.matches() ? matcher.group(1) : null;
    }

    private Artifact getArtifactFromPomProperties(String type, Properties pomProps) {
        return new DefaultArtifact(pomProps.getProperty("groupId"), pomProps.getProperty("artifactId"), pomProps.getProperty("version"), "runtime", type, pomProps.getProperty("classifier", ""), (ArtifactHandler)new DefaultArtifactHandler(type));
    }

    public void init(Logger log) {
        this.log = log;
        this.added.clear();
    }
}

