/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImageName {
    private String repository;
    private String registry;
    private String tag;
    private String user;
    private final String nameComponentRegexp = "[a-z0-9]+(?:(?:[._]|__|[-]*)[a-z0-9]+)*";
    private final String hostnameComponentRegexp = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])";
    private final String hostnameRegexp = "(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?";
    private final Pattern NAME_COMP_REGEXP = Pattern.compile("[a-z0-9]+(?:(?:[._]|__|[-]*)[a-z0-9]+)*");
    private final Pattern IMAGE_NAME_REGEXP = Pattern.compile("(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))+)?(?::[0-9]+)?/)?[a-z0-9]+(?:(?:[._]|__|[-]*)[a-z0-9]+)*(?:/[a-z0-9]+(?:(?:[._]|__|[-]*)[a-z0-9]+)*)?");
    private final Pattern REGISTRY_REGEXP = Pattern.compile("^(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9])(?:\\.(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]))*(?::[0-9]+)?$");
    private final Pattern TAG_REGEXP = Pattern.compile("^[\\w][\\w.-]{0,127}$");

    public ImageName(String fullName) {
        this(fullName, null);
    }

    public ImageName(String fullName, String givenTag) {
        if (fullName == null) {
            throw new NullPointerException("Image name must not be null");
        }
        Pattern tagPattern = Pattern.compile("^(.+?)(?::([^:/]+))?$");
        Matcher matcher = tagPattern.matcher(fullName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(fullName + " is not a proper image name ([registry/][repo][:port]");
        }
        this.tag = givenTag != null ? givenTag : (matcher.groupCount() > 1 ? matcher.group(2) : null);
        String rest = matcher.group(1);
        String[] parts = rest.split("\\s*/\\s*");
        if (parts.length == 1) {
            this.registry = null;
            this.user = null;
            this.repository = parts[0];
        } else if (parts.length >= 2) {
            if (this.isRegistry(parts[0])) {
                this.registry = parts[0];
                if (parts.length > 2) {
                    this.user = parts[1];
                    this.repository = this.joinTail(parts);
                } else {
                    this.user = null;
                    this.repository = parts[1];
                }
            } else {
                this.registry = null;
                this.user = parts[0];
                this.repository = rest;
            }
        }
        this.doValidate();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasRegistry() {
        return this.registry != null && this.registry.length() > 0;
    }

    private String joinTail(String[] parts) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i >= parts.length - 1) continue;
            builder.append("/");
        }
        return builder.toString();
    }

    private boolean isRegistry(String part) {
        return part.contains(".") || part.contains(":");
    }

    public String getNameWithoutTag() {
        return this.getNameWithoutTag(null);
    }

    public String getNameWithoutTag(String optionalRegistry) {
        StringBuilder ret = new StringBuilder();
        if (this.registry != null || optionalRegistry != null) {
            ret.append(this.registry != null ? this.registry : optionalRegistry).append("/");
        }
        ret.append(this.repository);
        return ret.toString();
    }

    public String getFullName() {
        return this.getFullName(null);
    }

    public String getFullName(String optionalRegistry) {
        return this.getNameWithoutTag(optionalRegistry) + ":" + (this.tag != null ? this.tag : "latest");
    }

    public String getUser() {
        return this.user;
    }

    public String getSimpleName() {
        String prefix = this.user + "/";
        return this.repository.startsWith(prefix) ? this.repository.substring(prefix.length()) : this.repository;
    }

    public static void validate(String image) {
        new ImageName(image);
    }

    private void doValidate() {
        ArrayList<String> errors = new ArrayList<String>();
        String image = this.user != null ? this.repository.substring(this.user.length() + 1) : this.repository;
        Object[] checks = new Object[]{"registry", this.REGISTRY_REGEXP, this.registry, "image", this.IMAGE_NAME_REGEXP, image, "user", this.NAME_COMP_REGEXP, this.user, "tag", this.TAG_REGEXP, this.tag};
        for (int i = 0; i < checks.length; i += 3) {
            String value = (String)checks[i + 2];
            Pattern checkPattern = (Pattern)checks[i + 1];
            if (value == null || checkPattern.matcher(value).matches()) continue;
            errors.add(String.format("%s part '%s' doesn't match allowed pattern '%s'", checks[i], value, checkPattern.pattern()));
        }
        if (errors.size() > 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("Given repository name '%s' is invalid:\n", this.getFullName()));
            for (String error : errors) {
                buf.append(String.format("   * %s\n", error));
            }
            buf.append("See http://bit.ly/docker_image_format for more details");
            throw new IllegalArgumentException(buf.toString());
        }
    }
}

