/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.log.LogOutputSpec;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.ServiceHub;
import java.io.FileNotFoundException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="logs")
@Execute(phase=LifecyclePhase.INITIALIZE)
public class LogsMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.follow", defaultValue="false")
    private boolean follow;
    @Parameter(property="docker.logAll", defaultValue="false")
    private boolean logAll;

    @Override
    protected void executeInternal(ServiceHub hub) throws MojoExecutionException, DockerAccessException {
        QueryService queryService = hub.getQueryService();
        LogDispatcher logDispatcher = this.getLogDispatcher(hub);
        for (ImageConfiguration image : this.getResolvedImages()) {
            String imageName = image.getName();
            if (this.logAll) {
                for (Container container : queryService.getContainersForImage(imageName)) {
                    this.doLogging(logDispatcher, image, container.getId());
                }
                continue;
            }
            Container container = queryService.getLatestContainerForImage(imageName);
            this.doLogging(logDispatcher, image, container.getId());
        }
        if (this.follow) {
            this.waitForEver();
        }
    }

    private void doLogging(LogDispatcher logDispatcher, ImageConfiguration imageConfig, String container) throws MojoExecutionException {
        LogOutputSpec spec = this.serviceHubFactory.getLogOutputSpecFactory().createSpec(container, imageConfig);
        try {
            if (this.follow) {
                logDispatcher.trackContainerLog(container, spec);
            } else {
                logDispatcher.fetchContainerLog(container, spec);
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Can not log to file " + spec.getFile());
        }
    }

    private synchronized void waitForEver() {
        while (true) {
            try {
                while (true) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

