/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.DockerConnectionDetector;
import io.fabric8.maven.docker.access.hc.DockerAccessWithHcClient;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.ServiceHubFactory;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.ImageNameFormatter;
import io.fabric8.maven.docker.util.ImagePullCache;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.PomLabel;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractDockerMojo
extends AbstractMojo
implements Contextualizable,
ConfigHelper.Customizer {
    public static final String CONTEXT_KEY_START_CALLED = "CONTEXT_KEY_DOCKER_START_CALLED";
    public static final String CONTEXT_KEY_LOG_DISPATCHER = "CONTEXT_KEY_DOCKER_LOG_DISPATCHER";
    public static final String CONTEXT_KEY_BUILD_TIMESTAMP = "CONTEXT_KEY_BUILD_TIMESTAMP";
    public static final String CONTEXT_KEY_PREVIOUSLY_PULLED = "CONTEXT_KEY_PREVIOUSLY_PULLED";
    public static final String API_VERSION = "1.18";
    public static final String DOCKER_BUILD_TIMESTAMP = "docker/build.timestamp";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="session")
    protected MavenSession session;
    @Parameter(property="mojoExecution")
    protected MojoExecution execution;
    @Component
    protected ImageConfigResolver imageConfigResolver;
    @Component
    protected ServiceHubFactory serviceHubFactory;
    @Parameter(property="docker.autoPull", defaultValue="on")
    protected String autoPull;
    @Parameter(property="docker.keepContainer", defaultValue="false")
    protected boolean keepContainer;
    @Parameter(property="docker.removeVolumes", defaultValue="false")
    protected boolean removeVolumes;
    @Parameter(property="docker.apiVersion")
    private String apiVersion;
    @Parameter(property="docker.host")
    private String dockerHost;
    @Parameter(property="docker.certPath")
    private String certPath;
    @Parameter(property="docker.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="docker.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="docker.logDate")
    private String logDate;
    @Parameter(property="docker.logStdout", defaultValue="false")
    private boolean logStdout;
    @Parameter(property="docker.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="docker.skip.machine", defaultValue="false")
    private boolean skipMachine;
    @Parameter(property="docker.image")
    private String image;
    @Parameter(property="docker.registry")
    protected String registry;
    @Parameter(property="docker.maxConnections", defaultValue="100")
    private int maxConnections;
    @Parameter
    Map authConfig;
    @Parameter
    private List<ImageConfiguration> images;
    @Parameter
    private DockerMachineConfiguration machine;
    private List<ImageConfiguration> resolvedImages;
    private AuthConfigFactory authConfigFactory;
    protected Logger log;
    private String serverVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.log = new AnsiLogger(this.getLog(), this.useColor, this.verbose, this.getLogPrefix());
            LogOutputSpecFactory logSpecFactory = new LogOutputSpecFactory(this.useColor, this.logStdout, this.logDate);
            String minimalApiVersion = this.initImageConfiguration(this.getBuildTimestamp());
            DockerAccess access = null;
            try {
                access = this.createDockerAccess(minimalApiVersion);
                ServiceHub serviceHub = this.serviceHubFactory.createServiceHub(this.project, this.session, access, this.log, logSpecFactory);
                this.executeInternal(serviceHub);
            }
            catch (DockerAccessException exp) {
                this.log.error("%s", exp.getMessage());
                throw new MojoExecutionException(this.log.errorMessage(exp.getMessage()), (Exception)exp);
            }
            catch (MojoExecutionException exp) {
                this.log.error("%s", exp.getMessage());
                throw exp;
            }
            finally {
                if (access != null) {
                    access.shutdown();
                }
            }
        }
    }

    protected synchronized Date getBuildTimestamp() throws MojoExecutionException {
        Date now = (Date)this.getPluginContext().get(CONTEXT_KEY_BUILD_TIMESTAMP);
        if (now == null) {
            now = this.getReferenceDate();
            this.getPluginContext().put(CONTEXT_KEY_BUILD_TIMESTAMP, now);
        }
        return now;
    }

    protected Date getReferenceDate() throws MojoExecutionException {
        Date referenceDate = EnvUtil.loadTimestamp(this.getBuildTimestampFile());
        return referenceDate != null ? referenceDate : new Date();
    }

    protected File getBuildTimestampFile() {
        return new File(this.project.getBuild().getDirectory(), DOCKER_BUILD_TIMESTAMP);
    }

    protected String getLogPrefix() {
        return "DOCKER> ";
    }

    private String initImageConfiguration(Date buildTimeStamp) {
        final Properties resolveProperties = this.project.getProperties();
        this.resolvedImages = ConfigHelper.resolveImages(this.images, new ConfigHelper.Resolver(){

            @Override
            public List<ImageConfiguration> resolve(ImageConfiguration image) {
                return AbstractDockerMojo.this.imageConfigResolver.resolve(image, resolveProperties);
            }
        }, this.image, this);
        return ConfigHelper.initAndValidate(this.resolvedImages, this.apiVersion, new ImageNameFormatter(this.project, buildTimeStamp), this.log);
    }

    @Override
    public List<ImageConfiguration> customizeConfig(List<ImageConfiguration> imageConfigs) {
        return imageConfigs;
    }

    private DockerAccess createDockerAccess(String minimalVersion) throws MojoExecutionException, MojoFailureException {
        DockerAccessWithHcClient access = null;
        if (this.isDockerAccessRequired()) {
            try {
                DockerConnectionDetector dockerConnectionDetector = this.createDockerConnectionDetector();
                String dockerUrl = dockerConnectionDetector.extractUrl(this.dockerHost);
                String version = minimalVersion != null ? minimalVersion : API_VERSION;
                access = new DockerAccessWithHcClient("v" + version, dockerUrl, dockerConnectionDetector.getCertPath(this.certPath), this.maxConnections, this.log);
                access.start();
                this.setDockerHostAddressProperty(dockerUrl);
                this.serverVersion = access.getServerApiVersion();
                if (!EnvUtil.greaterOrEqualsVersion(this.serverVersion, version)) {
                    throw new MojoExecutionException(String.format("Server API version %s is smaller than request API version %s", this.serverVersion, version));
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create docker access object ", (Exception)e);
            }
        }
        return access;
    }

    private DockerConnectionDetector createDockerConnectionDetector() {
        if (this.machine == null) {
            Properties projectProps = this.project.getProperties();
            if (!this.skipMachine && projectProps.containsKey("docker.machine.name")) {
                this.machine = new DockerMachineConfiguration(projectProps.getProperty("docker.machine.name"), projectProps.getProperty("docker.machine.autoCreate"));
            }
        }
        return new DockerConnectionDetector(this.log, this.machine);
    }

    protected boolean isDockerAccessRequired() {
        return true;
    }

    protected abstract void executeInternal(ServiceHub var1) throws DockerAccessException, MojoExecutionException;

    protected List<ImageConfiguration> getResolvedImages() {
        return this.resolvedImages;
    }

    private void setDockerHostAddressProperty(String dockerUrl) throws MojoFailureException {
        Properties props = this.project.getProperties();
        if (props.getProperty("docker.host.address") == null) {
            String host;
            try {
                URI uri = new URI(dockerUrl);
                host = uri.getHost() == null && uri.getScheme().equals("unix") ? "localhost" : uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new MojoFailureException("Cannot parse " + dockerUrl + " as URI: " + e.getMessage(), (Throwable)e);
            }
            props.setProperty("docker.host.address", host == null ? "" : host);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.authConfigFactory = new AuthConfigFactory((PlexusContainer)context.get((Object)"plexus"));
    }

    protected PomLabel getPomLabel() {
        return new PomLabel(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    protected AuthConfig prepareAuthConfig(ImageName image, String configuredRegistry, boolean isPush) throws MojoExecutionException {
        String user = isPush ? image.getUser() : null;
        String registry = image.getRegistry() != null ? image.getRegistry() : configuredRegistry;
        return this.authConfigFactory.createAuthConfig(isPush, this.authConfig, this.settings, user, registry);
    }

    protected LogDispatcher getLogDispatcher(ServiceHub hub) {
        LogDispatcher dispatcher = (LogDispatcher)this.getPluginContext().get(CONTEXT_KEY_LOG_DISPATCHER);
        if (dispatcher == null) {
            dispatcher = new LogDispatcher(hub.getDockerAccess());
            this.getPluginContext().put(CONTEXT_KEY_LOG_DISPATCHER, dispatcher);
        }
        return dispatcher;
    }

    protected String getConfiguredRegistry(ImageConfiguration imageConfig, String specificRegistry) {
        return EnvUtil.findRegistry(imageConfig.getRegistry(), specificRegistry, this.registry);
    }

    protected void checkImageWithAutoPull(ServiceHub hub, String image, String registry, boolean autoPullAlwaysAllowed) throws DockerAccessException, MojoExecutionException {
        ImagePullCache previouslyPulledCache;
        QueryService queryService = hub.getQueryService();
        if (!queryService.imageRequiresAutoPull(this.autoPull, image, autoPullAlwaysAllowed, previouslyPulledCache = this.getPreviouslyPulledImageCache())) {
            return;
        }
        DockerAccess docker = hub.getDockerAccess();
        ImageName imageName = new ImageName(image);
        long time = System.currentTimeMillis();
        docker.pullImage(this.withLatestIfNoTag(image), this.prepareAuthConfig(imageName, registry, false), registry);
        this.log.info("Pulled %s in %s", imageName.getFullName(), EnvUtil.formatDurationTill(time));
        this.updatePreviousPulledImageCache(image);
        if (registry != null && !imageName.hasRegistry()) {
            docker.tag(imageName.getFullName(registry), image, false);
        }
    }

    private void updatePreviousPulledImageCache(String image) {
        ImagePullCache cache = this.getPreviouslyPulledImageCache();
        cache.add(image);
        this.session.getUserProperties().setProperty(CONTEXT_KEY_PREVIOUSLY_PULLED, cache.toString());
    }

    private synchronized ImagePullCache getPreviouslyPulledImageCache() {
        Properties userProperties = this.session.getUserProperties();
        String pullCacheJson = userProperties.getProperty(CONTEXT_KEY_PREVIOUSLY_PULLED);
        ImagePullCache cache = new ImagePullCache(pullCacheJson);
        if (pullCacheJson == null) {
            userProperties.put(CONTEXT_KEY_PREVIOUSLY_PULLED, cache.toString());
        }
        return cache;
    }

    private String withLatestIfNoTag(String name) {
        ImageName imageName = new ImageName(name);
        return imageName.getTag() == null ? imageName.getNameWithoutTag() + ":latest" : name;
    }
}

