/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config;

import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.NetworkConfig;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.VolumeConfiguration;
import io.fabric8.maven.docker.config.WatchImageConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.StartOrderResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class ImageConfiguration
implements StartOrderResolver.Resolvable {
    @Parameter(required=true)
    private String name;
    @Parameter
    private String alias;
    @Parameter
    private RunImageConfiguration run;
    @Parameter
    private BuildImageConfiguration build;
    @Parameter
    private WatchImageConfiguration watch;
    @Parameter
    private Map<String, String> external;
    @Parameter
    private String registry;

    public ImageConfiguration() {
    }

    public ImageConfiguration(ImageConfiguration that) {
        this.name = that.name;
        this.alias = that.alias;
        this.run = that.run;
        this.build = that.build;
        this.watch = that.watch;
        this.external = that.external;
        this.registry = that.registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public RunImageConfiguration getRunConfiguration() {
        return this.run == null ? RunImageConfiguration.DEFAULT : this.run;
    }

    public BuildImageConfiguration getBuildConfiguration() {
        return this.build;
    }

    public WatchImageConfiguration getWatchConfiguration() {
        return this.watch;
    }

    public Map<String, String> getExternalConfig() {
        return this.external;
    }

    @Override
    public List<String> getDependencies() {
        RunImageConfiguration runConfig = this.getRunConfiguration();
        ArrayList<String> ret = new ArrayList<String>();
        if (runConfig != null) {
            this.addVolumes(runConfig, ret);
            this.addLinks(runConfig, ret);
            this.addContainerNetwork(runConfig, ret);
        }
        return ret;
    }

    private void addVolumes(RunImageConfiguration runConfig, List<String> ret) {
        List<String> volumeImages;
        VolumeConfiguration volConfig = runConfig.getVolumeConfiguration();
        if (volConfig != null && (volumeImages = volConfig.getFrom()) != null) {
            ret.addAll(volumeImages);
        }
    }

    private void addLinks(RunImageConfiguration runConfig, List<String> ret) {
        if (runConfig.getLinks() != null && !runConfig.getNetworkingConfig().isCustomNetwork()) {
            for (String[] link : EnvUtil.splitOnLastColon(runConfig.getLinks())) {
                ret.add(link[0]);
            }
        }
    }

    private void addContainerNetwork(RunImageConfiguration runConfig, List<String> ret) {
        NetworkConfig config = runConfig.getNetworkingConfig();
        String alias = config.getContainerAlias();
        if (alias != null) {
            ret.add(alias);
        }
    }

    public boolean isDataImage() {
        return this.getRunConfiguration() == null;
    }

    public String getDescription() {
        return String.format("[%s] %s", this.name, this.alias != null ? "\"" + this.alias + "\"" : "").trim();
    }

    public String getRegistry() {
        return this.registry;
    }

    public String toString() {
        return String.format("ImageConfiguration {name='%s', alias='%s'}", this.name, this.alias);
    }

    public String initAndValidate(ConfigHelper.NameFormatter nameFormatter, Logger log) {
        this.name = nameFormatter.format(this.name);
        String minimalApiVersion = null;
        if (this.build != null) {
            minimalApiVersion = this.build.initAndValidate(log);
        }
        if (this.run != null) {
            minimalApiVersion = EnvUtil.extractLargerVersion(minimalApiVersion, this.run.initAndValidate());
        }
        return minimalApiVersion;
    }

    public static class Builder {
        private final ImageConfiguration config;

        public Builder() {
            this.config = new ImageConfiguration();
        }

        public Builder(ImageConfiguration that) {
            this.config = new ImageConfiguration(that);
        }

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder alias(String alias) {
            this.config.alias = alias;
            return this;
        }

        public Builder runConfig(RunImageConfiguration runConfig) {
            this.config.run = runConfig;
            return this;
        }

        public Builder buildConfig(BuildImageConfiguration buildConfig) {
            this.config.build = buildConfig;
            return this;
        }

        public Builder externalConfig(Map<String, String> externalConfig) {
            this.config.external = externalConfig;
            return this;
        }

        public ImageConfiguration build() {
            return this.config;
        }

        public Builder watchConfig(WatchImageConfiguration watchConfig) {
            this.config.watch = watchConfig;
            return this;
        }
    }
}

