/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.access.DockerMachine;
import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.SuffixFileFilter;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class DockerConnectionDetector {
    private final Logger log;
    private final DockerMachineConfiguration machineConfig;
    private Map<String, String> dockerMachineEnv;
    private DockerMachine dockerMachine;

    public DockerConnectionDetector(Logger log, DockerMachineConfiguration machineConfig) {
        this.log = log;
        this.machineConfig = machineConfig;
    }

    public String extractUrl(String dockerHost) throws IOException {
        String connect = this.getValueWithFallback(dockerHost, "DOCKER_HOST");
        if (connect != null) {
            String protocol = connect.contains(":2376") ? "https:" : "http:";
            return connect.replaceFirst("^tcp:", protocol);
        }
        File unixSocket = new File("/var/run/docker.sock");
        if (unixSocket.exists() && unixSocket.canRead() && unixSocket.canWrite()) {
            return "unix:///var/run/docker.sock";
        }
        throw new IllegalArgumentException("No <dockerHost> or <machine> given, no DOCKER_HOST environment variable, and no read/writable '/var/run/docker.sock'");
    }

    public String getCertPath(String certPath) throws IOException {
        File dockerHome;
        String path = this.getValueWithFallback(certPath, "DOCKER_CERT_PATH");
        if (path == null && (dockerHome = new File(System.getProperty("user.home") + "/.docker")).isDirectory() && dockerHome.list(SuffixFileFilter.PEM_FILTER).length > 0) {
            return dockerHome.getAbsolutePath();
        }
        return path;
    }

    private String getValueWithFallback(String value, String envVar) throws IOException {
        if (value != null) {
            return value;
        }
        value = System.getenv(envVar);
        if (value != null) {
            return value;
        }
        if (this.machineConfig != null) {
            if (this.dockerMachine == null) {
                this.dockerMachine = new DockerMachine(this.log, this.machineConfig);
            }
            if (this.dockerMachineEnv == null) {
                this.dockerMachineEnv = this.dockerMachine.getEnvironment();
            }
            return this.dockerMachineEnv.get(envVar);
        }
        return null;
    }
}

