/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.config.handler.property;

import io.fabric8.maven.docker.config.AssemblyConfiguration;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.RestartPolicy;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.UlimitConfig;
import io.fabric8.maven.docker.config.VolumeConfiguration;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.config.WatchImageConfiguration;
import io.fabric8.maven.docker.config.handler.ExternalConfigHandler;
import io.fabric8.maven.docker.config.handler.property.ConfigKey;
import io.fabric8.maven.docker.util.EnvUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ExternalConfigHandler.class)
public class PropertyConfigHandler
implements ExternalConfigHandler {
    @Override
    public String getType() {
        return "props";
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration config, Properties properties) throws IllegalArgumentException {
        String prefix = this.getPrefix(config);
        RunImageConfiguration run = this.extractRunConfiguration(prefix, properties);
        BuildImageConfiguration build = this.extractBuildConfiguration(prefix, properties);
        WatchImageConfiguration watch = this.extractWatchConfig(prefix, properties);
        String name = this.extractName(prefix, properties);
        String alias = this.withPrefix(prefix, ConfigKey.ALIAS, properties);
        return Collections.singletonList(new ImageConfiguration.Builder().name(name).alias(alias != null ? alias : config.getAlias()).runConfig(run).buildConfig(build).watchConfig(watch).build());
    }

    private BuildImageConfiguration extractBuildConfiguration(String prefix, Properties properties) {
        return new BuildImageConfiguration.Builder().cmd(this.withPrefix(prefix, ConfigKey.CMD, properties)).cleanup(this.withPrefix(prefix, ConfigKey.CLEANUP, properties)).nocache(this.withPrefix(prefix, ConfigKey.NOCACHE, properties)).optimise(this.withPrefix(prefix, ConfigKey.OPTIMISE, properties)).entryPoint(this.withPrefix(prefix, ConfigKey.ENTRYPOINT, properties)).assembly(this.extractAssembly(prefix, properties)).env(this.mapWithPrefix(prefix, ConfigKey.ENV, properties)).args(this.mapWithPrefix(prefix, ConfigKey.ARGS, properties)).labels(this.mapWithPrefix(prefix, ConfigKey.LABELS, properties)).ports(this.extractPortValues(prefix, properties)).runCmds(this.extractRunCommands(prefix, properties)).from(this.withPrefix(prefix, ConfigKey.FROM, properties)).registry(this.withPrefix(prefix, ConfigKey.REGISTRY, properties)).volumes(this.listWithPrefix(prefix, ConfigKey.VOLUMES, properties)).tags(this.listWithPrefix(prefix, ConfigKey.TAGS, properties)).maintainer(this.withPrefix(prefix, ConfigKey.MAINTAINER, properties)).workdir(this.withPrefix(prefix, ConfigKey.WORKDIR, properties)).skip(this.withPrefix(prefix, ConfigKey.SKIP_BUILD, properties)).dockerFile(this.withPrefix(prefix, ConfigKey.DOCKER_FILE, properties)).dockerFileDir(this.withPrefix(prefix, ConfigKey.DOCKER_FILE_DIR, properties)).user(this.withPrefix(prefix, ConfigKey.USER, properties)).build();
    }

    private RunImageConfiguration extractRunConfiguration(String prefix, Properties properties) {
        return new RunImageConfiguration.Builder().capAdd(this.listWithPrefix(prefix, ConfigKey.CAP_ADD, properties)).capDrop(this.listWithPrefix(prefix, ConfigKey.CAP_DROP, properties)).cmd(this.withPrefix(prefix, ConfigKey.CMD, properties)).dns(this.listWithPrefix(prefix, ConfigKey.DNS, properties)).net(this.withPrefix(prefix, ConfigKey.NET, properties)).dnsSearch(this.listWithPrefix(prefix, ConfigKey.DNS_SEARCH, properties)).domainname(this.withPrefix(prefix, ConfigKey.DOMAINNAME, properties)).entrypoint(this.withPrefix(prefix, ConfigKey.ENTRYPOINT, properties)).env(this.mapWithPrefix(prefix, ConfigKey.ENV, properties)).labels(this.mapWithPrefix(prefix, ConfigKey.LABELS, properties)).envPropertyFile(this.withPrefix(prefix, ConfigKey.ENV_PROPERTY_FILE, properties)).extraHosts(this.listWithPrefix(prefix, ConfigKey.EXTRA_HOSTS, properties)).hostname(this.withPrefix(prefix, ConfigKey.HOSTNAME, properties)).links(this.listWithPrefix(prefix, ConfigKey.LINKS, properties)).memory(this.longWithPrefix(prefix, ConfigKey.MEMORY, properties)).memorySwap(this.longWithPrefix(prefix, ConfigKey.MEMORY_SWAP, properties)).namingStrategy(this.withPrefix(prefix, ConfigKey.NAMING_STRATEGY, properties)).portPropertyFile(this.withPrefix(prefix, ConfigKey.PORT_PROPERTY_FILE, properties)).ports(this.listWithPrefix(prefix, ConfigKey.PORTS, properties)).shmSize(this.longWithPrefix(prefix, ConfigKey.SHMSIZE, properties)).privileged(this.booleanWithPrefix(prefix, ConfigKey.PRIVILEGED, properties)).restartPolicy(this.extractRestartPolicy(prefix, properties)).user(this.withPrefix(prefix, ConfigKey.USER, properties)).workingDir(this.withPrefix(prefix, ConfigKey.WORKING_DIR, properties)).log(this.extractLogConfig(prefix, properties)).wait(this.extractWaitConfig(prefix, properties)).volumes(this.extractVolumeConfig(prefix, properties)).skip(this.withPrefix(prefix, ConfigKey.SKIP_RUN, properties)).ulimits(this.extractUlimits(prefix, properties)).build();
    }

    private AssemblyConfiguration extractAssembly(String prefix, Properties properties) {
        return new AssemblyConfiguration.Builder().basedir(this.withPrefix(prefix, ConfigKey.ASSEMBLY_BASEDIR, properties)).descriptor(this.withPrefix(prefix, ConfigKey.ASSEMBLY_DESCRIPTOR, properties)).descriptorRef(this.withPrefix(prefix, ConfigKey.ASSEMBLY_DESCRIPTOR_REF, properties)).dockerFileDir(this.withPrefix(prefix, ConfigKey.ASSEMBLY_DOCKER_FILE_DIR, properties)).exportBasedir(this.booleanWithPrefix(prefix, ConfigKey.ASSEMBLY_EXPORT_BASEDIR, properties)).ignorePermissions(this.booleanWithPrefix(prefix, ConfigKey.ASSEMBLY_IGNORE_PERMISSIONS, properties)).permissions(this.withPrefix(prefix, ConfigKey.ASSEMBLY_PERMISSIONS, properties)).user(this.withPrefix(prefix, ConfigKey.ASSEMBLY_USER, properties)).mode(this.withPrefix(prefix, ConfigKey.ASSEMBLY_MODE, properties)).build();
    }

    private String extractName(String prefix, Properties properties) throws IllegalArgumentException {
        String name = this.withPrefix(prefix, ConfigKey.NAME, properties);
        if (name == null) {
            throw new IllegalArgumentException(String.format("Mandatory property [%s] is not defined", new Object[]{ConfigKey.NAME}));
        }
        return name;
    }

    private List<String> extractPortValues(String prefix, Properties properties) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> ports = this.listWithPrefix(prefix, ConfigKey.PORTS, properties);
        if (ports == null) {
            return null;
        }
        List<String[]> parsedPorts = EnvUtil.splitOnLastColon(ports);
        for (String[] port : parsedPorts) {
            ret.add(port[1]);
        }
        return ret;
    }

    private List<String> extractRunCommands(String prefix, Properties properties) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> cmds = this.listWithPrefix(prefix, ConfigKey.RUN, properties);
        if (cmds == null) {
            return null;
        }
        return ret;
    }

    private RestartPolicy extractRestartPolicy(String prefix, Properties properties) {
        return new RestartPolicy.Builder().name(this.withPrefix(prefix, ConfigKey.RESTART_POLICY_NAME, properties)).retry(this.asInt(this.withPrefix(prefix, ConfigKey.RESTART_POLICY_RETRY, properties))).build();
    }

    private LogConfiguration extractLogConfig(String prefix, Properties properties) {
        LogConfiguration.Builder builder = new LogConfiguration.Builder().color(this.withPrefix(prefix, ConfigKey.LOG_COLOR, properties)).date(this.withPrefix(prefix, ConfigKey.LOG_DATE, properties)).prefix(this.withPrefix(prefix, ConfigKey.LOG_PREFIX, properties)).logDriverName(this.withPrefix(prefix, ConfigKey.LOG_DRIVER_NAME, properties)).logDriverOpts(this.mapWithPrefix(prefix, ConfigKey.LOG_DRIVER_OPTS, properties));
        Boolean enabled = this.booleanWithPrefix(prefix, ConfigKey.LOG_ENABLED, properties);
        if (enabled != null) {
            builder.enabled(enabled);
        }
        return builder.build();
    }

    private WaitConfiguration extractWaitConfig(String prefix, Properties properties) {
        String url = this.withPrefix(prefix, ConfigKey.WAIT_HTTP_URL, properties);
        if (url == null) {
            url = this.withPrefix(prefix, ConfigKey.WAIT_URL, properties);
        }
        return new WaitConfiguration.Builder().time(this.asInt(this.withPrefix(prefix, ConfigKey.WAIT_TIME, properties))).url(url).preStop(this.withPrefix(prefix, ConfigKey.PRE_STOP, properties)).postStart(this.withPrefix(prefix, ConfigKey.POST_START, properties)).method(this.withPrefix(prefix, ConfigKey.WAIT_HTTP_METHOD, properties)).status(this.withPrefix(prefix, ConfigKey.WAIT_HTTP_STATUS, properties)).log(this.withPrefix(prefix, ConfigKey.WAIT_LOG, properties)).kill(this.asInt(this.withPrefix(prefix, ConfigKey.WAIT_KILL, properties))).shutdown(this.asInt(this.withPrefix(prefix, ConfigKey.WAIT_SHUTDOWN, properties))).tcpHost(this.withPrefix(prefix, ConfigKey.WAIT_TCP_HOST, properties)).tcpPorts(this.asIntList(this.listWithPrefix(prefix, ConfigKey.WAIT_TCP_PORT, properties))).tcpMode(this.withPrefix(prefix, ConfigKey.WAIT_TCP_MODE, properties)).build();
    }

    private WatchImageConfiguration extractWatchConfig(String prefix, Properties properties) {
        return new WatchImageConfiguration.Builder().interval(this.asInt(this.withPrefix(prefix, ConfigKey.WATCH_INTERVAL, properties))).postGoal(this.withPrefix(prefix, ConfigKey.WATCH_POSTGOAL, properties)).mode(this.withPrefix(prefix, ConfigKey.WATCH_POSTGOAL, properties)).build();
    }

    private List<UlimitConfig> extractUlimits(String prefix, Properties properties) {
        List<String> ulimits = this.listWithPrefix(prefix, ConfigKey.ULIMITS, properties);
        if (ulimits == null) {
            return null;
        }
        ArrayList<UlimitConfig> ret = new ArrayList<UlimitConfig>();
        for (String ulimit : ulimits) {
            ret.add(new UlimitConfig(ulimit));
        }
        return ret;
    }

    private VolumeConfiguration extractVolumeConfig(String prefix, Properties properties) {
        return new VolumeConfiguration.Builder().bind(this.listWithPrefix(prefix, ConfigKey.BIND, properties)).from(this.listWithPrefix(prefix, ConfigKey.VOLUMES_FROM, properties)).build();
    }

    private int asInt(String s) {
        return s != null ? Integer.parseInt(s) : 0;
    }

    private List<Integer> asIntList(List<String> strings) {
        if (strings == null) {
            return null;
        }
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (String s : strings) {
            ints.add(this.asInt(s));
        }
        return ints;
    }

    private List<String> listWithPrefix(String prefix, ConfigKey key, Properties properties) {
        return EnvUtil.extractFromPropertiesAsList(key.asPropertyKey(prefix), properties);
    }

    private Map<String, String> mapWithPrefix(String prefix, ConfigKey key, Properties properties) {
        return EnvUtil.extractFromPropertiesAsMap(key.asPropertyKey(prefix), properties);
    }

    private String withPrefix(String prefix, ConfigKey key, Properties properties) {
        return properties.getProperty(key.asPropertyKey(prefix));
    }

    private Long longWithPrefix(String prefix, ConfigKey key, Properties properties) {
        String prop = this.withPrefix(prefix, key, properties);
        return prop == null ? null : Long.valueOf(prop);
    }

    private Boolean booleanWithPrefix(String prefix, ConfigKey key, Properties properties) {
        String prop = this.withPrefix(prefix, key, properties);
        return prop == null ? null : Boolean.valueOf(prop);
    }

    private String getPrefix(ImageConfiguration config) {
        String prefix;
        Map<String, String> refConfig = config.getExternalConfig();
        String string = prefix = refConfig != null ? refConfig.get("prefix") : null;
        if (prefix == null) {
            prefix = "docker";
        }
        return prefix;
    }
}

