/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.config.DockerMachineConfiguration;
import io.fabric8.maven.docker.util.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DockerMachine {
    private final Logger log;
    private final DockerMachineConfiguration machine;
    private static final String SET_PREFIX = "SET ";
    private static final int SET_PREFIX_LEN = "SET ".length();

    public DockerMachine(Logger log, DockerMachineConfiguration machine) throws IOException {
        this.log = log;
        this.machine = machine;
        Status status = new StatusCommand().getStatus();
        switch (status) {
            case DoesNotExist: {
                if (Boolean.TRUE == machine.getAutoCreate()) {
                    new CreateCommand().execute();
                    break;
                }
                throw new IllegalStateException(machine.getName() + " does not exist and docker.machine.autoCreate is false");
            }
            case Running: {
                break;
            }
            case Stopped: {
                new StartCommand().execute();
            }
        }
    }

    public Map<String, String> getEnvironment() throws IOException {
        return new EnvCommand().getEnvironment();
    }

    private class StartCommand
    extends DockerCommand {
        private long start;

        private StartCommand() {
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "start", DockerMachine.this.machine.getName()};
        }

        @Override
        protected void start() {
            DockerMachine.this.log.info("Starting docker machine \"%s\"", DockerMachine.this.machine.getName());
            this.start = System.currentTimeMillis();
        }

        @Override
        protected void end() {
            DockerMachine.this.log.info("Started docker machine \"%s\" in %d seconds", DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L);
        }
    }

    private class CreateCommand
    extends DockerCommand {
        private long start;

        private CreateCommand() {
        }

        @Override
        protected String[] getArgs() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("docker-machine");
            args.add("create");
            if (DockerMachine.this.machine.getCreateOptions() != null) {
                for (Map.Entry<String, String> entry : DockerMachine.this.machine.getCreateOptions().entrySet()) {
                    args.add("--" + entry.getKey());
                    String value = entry.getValue();
                    if (value == null || value.isEmpty()) continue;
                    args.add(value);
                }
            }
            args.add(DockerMachine.this.machine.getName());
            return args.toArray(new String[args.size()]);
        }

        @Override
        protected void start() {
            DockerMachine.this.log.info("Creating docker machine \"%s\" with args %s", DockerMachine.this.machine.getName(), DockerMachine.this.machine.getCreateOptions() != null ? DockerMachine.this.machine.getCreateOptions().toString() : "");
            DockerMachine.this.log.info("This might take a while ...", new Object[0]);
            this.start = System.currentTimeMillis();
        }

        @Override
        protected void end() {
            DockerMachine.this.log.info("Created docker machine \"%s\" in %d seconds", DockerMachine.this.machine.getName(), (System.currentTimeMillis() - this.start) / 1000L);
        }
    }

    private class StatusCommand
    extends DockerCommand {
        private Status status;
        private String message;

        private StatusCommand() {
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "status", DockerMachine.this.machine.getName()};
        }

        @Override
        protected void processLine(String line) {
            DockerMachine.this.log.info("Docker machine \"%s\" is %s", DockerMachine.this.machine.getName(), line.toLowerCase());
            if ("Running".equals(line)) {
                this.status = Status.Running;
            } else if ("Stopped".equals(line)) {
                this.status = Status.Stopped;
            } else {
                this.message = "Unknown status - " + line;
            }
        }

        public Status getStatus() throws IOException {
            try {
                this.execute();
            }
            catch (IOException ex) {
                if (this.statusCode == 1) {
                    this.status = Status.DoesNotExist;
                }
                throw ex;
            }
            if (this.message != null) {
                throw new IOException(this.message);
            }
            return this.status;
        }
    }

    private class EnvCommand
    extends DockerCommand {
        private final Map<String, String> env;

        private EnvCommand() {
            this.env = new HashMap<String, String>();
        }

        @Override
        protected String[] getArgs() {
            return new String[]{"docker-machine", "env", DockerMachine.this.machine.getName(), "--shell", "cmd"};
        }

        @Override
        protected void processLine(String line) {
            if (DockerMachine.this.log.isDebugEnabled()) {
                DockerMachine.this.log.verbose("%s", line);
            }
            if (line.startsWith(DockerMachine.SET_PREFIX)) {
                this.setEnvironmentVariable(line.substring(SET_PREFIX_LEN));
            }
        }

        private void setEnvironmentVariable(String line) {
            int equals = line.indexOf(61);
            if (equals < 0) {
                return;
            }
            String name = line.substring(0, equals);
            String value = line.substring(equals + 1);
            DockerMachine.this.log.debug(name + "=" + value, new Object[0]);
            this.env.put(name, value);
        }

        public Map<String, String> getEnvironment() throws IOException {
            this.execute();
            return this.env;
        }
    }

    abstract class DockerCommand {
        private final ExecutorService executor = Executors.newFixedThreadPool(2);
        int statusCode;

        DockerCommand() {
        }

        void execute() throws IOException {
            Process process = this.startDockerMachineProcess(new String[0]);
            this.start();
            try {
                this.closeOutputStream(process.getOutputStream());
                Future<IOException> stderrFuture = this.startStreamPump(process.getErrorStream());
                this.outputStreamPump(process.getInputStream());
                this.stopStreamPump(stderrFuture);
                this.checkProcessExit(process);
            }
            catch (IOException e) {
                process.destroy();
                throw e;
            }
            finally {
                this.end();
            }
            if (this.statusCode != 0) {
                throw new IOException("docker-machine exited with status " + this.statusCode);
            }
        }

        protected void start() {
        }

        protected void end() {
        }

        private void checkProcessExit(Process process) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
                this.statusCode = process.exitValue();
            }
            catch (IllegalThreadStateException | InterruptedException e) {
                process.destroy();
                this.statusCode = -1;
            }
        }

        private void closeOutputStream(OutputStream outputStream) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                DockerMachine.this.log.info("failed to close docker-machine output stream: " + e.getMessage(), new Object[0]);
            }
        }

        private Process startDockerMachineProcess(String ... args) throws IOException {
            try {
                return Runtime.getRuntime().exec(this.getArgs());
            }
            catch (IOException e) {
                throw new IOException("failed to start docker-machine", e);
            }
        }

        protected abstract String[] getArgs();

        private void outputStreamPump(InputStream inputStream) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    this.processLine(line);
                }
            }
            catch (IOException e) {
                throw new IOException("failed to read docker-machine output", e);
            }
        }

        protected void processLine(String line) {
            DockerMachine.this.log.verbose(line, new Object[0]);
        }

        private Future<IOException> startStreamPump(final InputStream errorStream) {
            return this.executor.submit(new Callable<IOException>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public IOException call() {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream));){
                        while (true) {
                            String line;
                            if ((line = reader.readLine()) == null) {
                                IOException iOException = null;
                                return iOException;
                            }
                            Logger logger = DockerMachine.this.log;
                            synchronized (logger) {
                                DockerMachine.this.log.warn(line, new Object[0]);
                            }
                        }
                    }
                    catch (IOException e) {
                        return e;
                    }
                }
            });
        }

        private void stopStreamPump(Future<IOException> future) throws IOException {
            try {
                IOException e = future.get(2L, TimeUnit.SECONDS);
                if (e != null) {
                    throw new IOException("failed to read docker-machine error stream", e);
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IOException("failed to stop docker-machine error stream", e);
            }
        }
    }

    static enum Status {
        DoesNotExist,
        Running,
        Stopped;

    }
}

