/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import java.util.Date;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.INSTALL)
@Execute(phase=LifecyclePhase.INITIALIZE)
public class BuildMojo
extends AbstractBuildSupportMojo {
    @Parameter(property="docker.skip.tag", defaultValue="false")
    private boolean skipTag;
    @Parameter(property="docker.skip.build", defaultValue="false")
    protected boolean skipBuild;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.skipBuild) {
            return;
        }
        for (ImageConfiguration imageConfig : this.getResolvedImages()) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            if (buildConfig == null) continue;
            if (buildConfig.skip()) {
                this.log.info("%s : Skipped building", imageConfig.getDescription());
                continue;
            }
            this.buildAndTag(hub, imageConfig);
        }
    }

    protected void buildAndTag(ServiceHub hub, ImageConfiguration imageConfig) throws MojoExecutionException, DockerAccessException {
        this.buildImage(hub, imageConfig);
        if (!this.skipTag) {
            this.tagImage(imageConfig.getName(), imageConfig, hub.getDockerAccess());
        }
    }

    @Override
    protected Date getReferenceDate() throws MojoExecutionException {
        return new Date();
    }

    private void tagImage(String imageName, ImageConfiguration imageConfig, DockerAccess dockerAccess) throws DockerAccessException, MojoExecutionException {
        List<String> tags = imageConfig.getBuildConfiguration().getTags();
        if (tags.size() > 0) {
            this.log.info("%s: Tag with %s", imageConfig.getDescription(), EnvUtil.stringJoin(tags, ","));
            for (String tag : tags) {
                if (tag == null) continue;
                dockerAccess.tag(imageName, new ImageName(imageName, tag).getFullName(), true);
            }
            this.log.debug("Tagging image successful!");
        }
    }
}

