/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;

public class WaitUtil {
    private static final long DEFAULT_MAX_WAIT = 10000L;
    private static final long WAIT_RETRY_WAIT = 500L;
    private static final int HTTP_PING_TIMEOUT = 500;
    private static final int TCP_PING_TIMEOUT = 500;
    public static final String DEFAULT_HTTP_METHOD = "HEAD";
    public static final int DEFAULT_MIN_STATUS = 200;
    public static final int DEFAULT_MAX_STATUS = 399;
    public static final int HTTP_CLIENT_RETRIES = 0;

    private WaitUtil() {
    }

    public static long wait(int maxWait, WaitChecker ... checkers) throws WaitTimeoutException {
        return WaitUtil.wait(maxWait, Arrays.asList(checkers));
    }

    public static long wait(int maxWait, Iterable<WaitChecker> checkers) throws WaitTimeoutException {
        long max = maxWait > 0 ? (long)maxWait : 10000L;
        long now = System.currentTimeMillis();
        try {
            do {
                for (WaitChecker checker : checkers) {
                    if (!checker.check()) continue;
                    long l = WaitUtil.delta(now);
                    return l;
                }
                WaitUtil.sleep(500L);
            } while (WaitUtil.delta(now) < max);
            throw new WaitTimeoutException("No checker finished successfully", WaitUtil.delta(now));
        }
        finally {
            WaitUtil.cleanup(checkers);
        }
    }

    private static void cleanup(Iterable<WaitChecker> checkers) {
        for (WaitChecker checker : checkers) {
            checker.cleanUp();
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static long delta(long now) {
        return System.currentTimeMillis() - now;
    }

    public static class WaitTimeoutException
    extends TimeoutException {
        private final long waited;

        public WaitTimeoutException(String message, long waited) {
            super(message);
            this.waited = waited;
        }

        public long getWaited() {
            return this.waited;
        }
    }

    public static interface WaitChecker {
        public boolean check();

        public void cleanUp();
    }

    public static class TcpPortChecker
    implements WaitChecker {
        private final List<Integer> ports;
        private final List<InetSocketAddress> pending;

        public TcpPortChecker(String host, List<Integer> ports) {
            this.ports = ports;
            this.pending = new ArrayList<InetSocketAddress>();
            for (int port : ports) {
                this.pending.add(new InetSocketAddress(host, port));
            }
        }

        public List<Integer> getPorts() {
            return this.ports;
        }

        public List<InetSocketAddress> getPending() {
            return this.pending;
        }

        @Override
        public boolean check() {
            Iterator<InetSocketAddress> iter = this.pending.iterator();
            while (iter.hasNext()) {
                InetSocketAddress address = iter.next();
                try {
                    Socket s = new Socket();
                    s.connect(address, 500);
                    s.close();
                    iter.remove();
                }
                catch (IOException iOException) {}
            }
            return this.pending.isEmpty();
        }

        @Override
        public void cleanUp() {
        }
    }

    public static class HttpPingChecker
    implements WaitChecker {
        private int statusMin;
        private int statusMax;
        private String url;
        private String method;

        public HttpPingChecker(String url, String method, String status) {
            this.url = url;
            this.method = method;
            if (method == null) {
                this.method = WaitUtil.DEFAULT_HTTP_METHOD;
            }
            if (status == null) {
                this.statusMin = 200;
                this.statusMax = 399;
            } else {
                Matcher matcher = Pattern.compile("^(\\d+)\\s*\\.\\.+\\s*(\\d+)$").matcher(status);
                if (matcher.matches()) {
                    this.statusMin = Integer.parseInt(matcher.group(1));
                    this.statusMax = Integer.parseInt(matcher.group(2));
                } else {
                    this.statusMin = this.statusMax = Integer.parseInt(status);
                }
            }
        }

        public HttpPingChecker(String waitUrl) {
            this(waitUrl, null, null);
        }

        @Override
        public boolean check() {
            try {
                return this.ping();
            }
            catch (IOException exception) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean ping() throws IOException {
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(500).setConnectTimeout(500).setConnectionRequestTimeout(500).setRedirectsEnabled(false).build();
            try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();){
                boolean bl;
                CloseableHttpResponse response = httpClient.execute(RequestBuilder.create((String)this.method.toUpperCase()).setUri(this.url).build());
                try {
                    int responseCode = response.getStatusLine().getStatusCode();
                    if (responseCode == 501) {
                        throw new IllegalArgumentException("Invalid or not supported HTTP method '" + this.method.toUpperCase() + "' for checking " + this.url);
                    }
                    bl = responseCode >= this.statusMin && responseCode <= this.statusMax;
                }
                catch (Throwable throwable) {
                    response.close();
                    throw throwable;
                }
                response.close();
                return bl;
            }
        }

        @Override
        public void cleanUp() {
        }
    }
}

