/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ContainerTracker;
import io.fabric8.maven.docker.service.MojoExecutionService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.project.MavenProject;

public class ServiceHub {
    private final DockerAccess dockerAccess;
    private final LogOutputSpecFactory logSpecFactory;
    private final QueryService queryService;
    private final RunService runService;
    private final BuildService buildService;
    private final MojoExecutionService mojoExecutionService;
    private final ArchiveService archiveService;

    ServiceHub(DockerAccess dockerAccess, ContainerTracker containerTracker, BuildPluginManager pluginManager, DockerAssemblyManager dockerAssemblyManager, MavenProject project, MavenSession session, Logger logger, LogOutputSpecFactory logSpecFactory) {
        this.dockerAccess = dockerAccess;
        this.logSpecFactory = logSpecFactory;
        this.mojoExecutionService = new MojoExecutionService(project, session, pluginManager);
        this.archiveService = new ArchiveService(dockerAssemblyManager, logger);
        if (dockerAccess != null) {
            this.queryService = new QueryService(dockerAccess);
            this.runService = new RunService(dockerAccess, this.queryService, containerTracker, logSpecFactory, logger);
            this.buildService = new BuildService(dockerAccess, this.queryService, this.archiveService, logger);
        } else {
            this.queryService = null;
            this.runService = null;
            this.buildService = null;
        }
    }

    public DockerAccess getDockerAccess() {
        this.checkDockerAccessInitialization();
        return this.dockerAccess;
    }

    public BuildService getBuildService() {
        this.checkDockerAccessInitialization();
        return this.buildService;
    }

    public QueryService getQueryService() {
        this.checkDockerAccessInitialization();
        return this.queryService;
    }

    public RunService getRunService() {
        this.checkDockerAccessInitialization();
        return this.runService;
    }

    public ArchiveService getArchiveService() {
        return this.archiveService;
    }

    public MojoExecutionService getMojoExecutionService() {
        return this.mojoExecutionService;
    }

    private synchronized void checkDockerAccessInitialization() {
        if (this.dockerAccess == null) {
            throw new IllegalStateException("Service hub created without a docker access to a docker daemon");
        }
    }
}

