/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractDockerMojo;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.PortMapping;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.config.ConfigHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.LogConfiguration;
import io.fabric8.maven.docker.config.NetworkingMode;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.config.WaitConfiguration;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.RunService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.PomLabel;
import io.fabric8.maven.docker.util.StartOrderResolver;
import io.fabric8.maven.docker.util.Timestamp;
import io.fabric8.maven.docker.util.WaitUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class StartMojo
extends AbstractDockerMojo {
    @Parameter(property="docker.showLogs")
    private String showLogs;
    @Parameter(property="docker.pull.registry")
    private String pullRegistry;
    @Parameter(property="docker.skip.run", defaultValue="false")
    private boolean skipRun;
    private boolean follow;
    @Parameter(property="docker.exposeContainerInfo")
    private String exposeContainerProps = "docker.container";
    @Parameter(property="docker.autoCreateCustomNetworks", defaultValue="false")
    protected boolean autoCreateCustomNetworks;
    @Parameter
    protected String portPropertyFile;

    @Override
    public synchronized void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        if (this.skipRun) {
            return;
        }
        this.getPluginContext().put("CONTEXT_KEY_DOCKER_START_CALLED", true);
        Properties projProperties = this.project.getProperties();
        this.follow = Boolean.valueOf(System.getProperty("docker.follow", "false"));
        QueryService queryService = hub.getQueryService();
        RunService runService = hub.getRunService();
        LogDispatcher dispatcher = this.getLogDispatcher(hub);
        PortMapping.PropertyWriteHelper portMappingPropertyWriteHelper = new PortMapping.PropertyWriteHelper(this.portPropertyFile);
        boolean success = false;
        PomLabel pomLabel = this.getPomLabel();
        try {
            for (StartOrderResolver.Resolvable resolvable : runService.getImagesConfigsInOrder(queryService, this.getResolvedImages())) {
                ImageConfiguration imageConfig = (ImageConfiguration)resolvable;
                String imageName = imageConfig.getName();
                this.checkImageWithAutoPull(hub, imageName, this.getConfiguredRegistry(imageConfig, this.pullRegistry), imageConfig.getBuildConfiguration() == null);
                RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
                PortMapping portMapping = runService.getPortMapping(runConfig, projProperties);
                NetworkingMode networkMode = runConfig.getNetworkingMode();
                if (this.autoCreateCustomNetworks && networkMode.isCustomNetwork()) {
                    runService.createCustomNetworkIfNotExistant(runConfig.getNetworkingMode().getCustomNetwork());
                }
                String containerId = runService.createAndStartContainer(imageConfig, portMapping, pomLabel, projProperties);
                if (this.showLogs(imageConfig)) {
                    dispatcher.trackContainerLog(containerId, this.serviceHubFactory.getLogOutputSpecFactory().createSpec(containerId, imageConfig));
                }
                portMappingPropertyWriteHelper.add(portMapping, runConfig.getPortPropertyFile());
                this.waitIfRequested(hub, imageConfig, projProperties, containerId);
                WaitConfiguration waitConfig = runConfig.getWaitConfiguration();
                if (waitConfig != null && waitConfig.getExec() != null && waitConfig.getExec().getPostStart() != null) {
                    runService.execInContainer(containerId, waitConfig.getExec().getPostStart(), imageConfig);
                }
                this.exposeContainerProps(hub.getQueryService(), containerId, imageConfig.getAlias());
            }
            if (this.follow) {
                runService.addShutdownHookForStoppingContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks);
                this.wait();
            }
            portMappingPropertyWriteHelper.write();
            success = true;
        }
        catch (InterruptedException e) {
            this.log.warn("Interrupted");
            Thread.currentThread().interrupt();
            throw new MojoExecutionException("interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
        finally {
            if (!success) {
                this.log.error("Error occurred during container startup, shutting down...");
                runService.stopStartedContainers(this.keepContainer, this.removeVolumes, this.autoCreateCustomNetworks, pomLabel);
            }
        }
    }

    private void waitIfRequested(ServiceHub hub, ImageConfiguration imageConfig, Properties projectProperties, String containerId) throws MojoExecutionException {
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        WaitConfiguration wait = runConfig.getWaitConfiguration();
        if (wait == null) {
            return;
        }
        ArrayList<WaitUtil.WaitChecker> checkers = new ArrayList<WaitUtil.WaitChecker>();
        ArrayList<String> logOut = new ArrayList<String>();
        if (wait.getUrl() != null) {
            checkers.add(this.getUrlWaitChecker(imageConfig.getDescription(), projectProperties, wait, logOut));
        }
        if (wait.getLog() != null) {
            this.log.debug("LogWaitChecker: Waiting on %s", wait.getLog());
            checkers.add(this.getLogWaitChecker(wait.getLog(), hub, containerId));
            logOut.add("on log out '" + wait.getLog() + "'");
        }
        if (wait.getTcp() != null) {
            try {
                Container container = hub.getQueryService().getMandatoryContainer(containerId);
                checkers.add(this.getTcpWaitChecker(container, imageConfig.getDescription(), projectProperties, wait.getTcp(), logOut));
            }
            catch (DockerAccessException e) {
                throw new MojoExecutionException("Unable to access container.", (Exception)e);
            }
        }
        if (checkers.isEmpty()) {
            if (wait.getTime() > 0) {
                this.log.info("%s: Pausing for %d ms", imageConfig.getDescription(), wait.getTime());
                WaitUtil.sleep(wait.getTime());
            }
            return;
        }
        try {
            long waited = WaitUtil.wait(wait.getTime(), checkers);
            this.log.info("%s: Waited %s %d ms", imageConfig.getDescription(), StringUtils.join((Object[])logOut.toArray(), (String)" and "), waited);
        }
        catch (WaitUtil.WaitTimeoutException exp) {
            String desc = String.format("%s: Timeout after %d ms while waiting %s", imageConfig.getDescription(), exp.getWaited(), StringUtils.join((Object[])logOut.toArray(), (String)" and "));
            this.log.error(desc);
            throw new MojoExecutionException(desc);
        }
    }

    private WaitUtil.WaitChecker getUrlWaitChecker(String imageConfigDesc, Properties projectProperties, WaitConfiguration wait, ArrayList<String> logOut) {
        WaitUtil.HttpPingChecker checker;
        String waitUrl = StrSubstitutor.replace((Object)wait.getUrl(), (Properties)projectProperties);
        WaitConfiguration.HttpConfiguration httpConfig = wait.getHttp();
        if (httpConfig != null) {
            checker = new WaitUtil.HttpPingChecker(waitUrl, httpConfig.getMethod(), httpConfig.getStatus());
            this.log.info("%s: Waiting on url %s with method %s for status %s.", imageConfigDesc, waitUrl, httpConfig.getMethod(), httpConfig.getStatus());
        } else {
            checker = new WaitUtil.HttpPingChecker(waitUrl);
            this.log.info("%s: Waiting on url %s.", imageConfigDesc, waitUrl);
        }
        logOut.add("on url " + waitUrl);
        return checker;
    }

    private WaitUtil.WaitChecker getTcpWaitChecker(Container container, String imageConfigDesc, Properties projectProperties, WaitConfiguration.TcpConfiguration tcpConfig, ArrayList<String> logOut) throws MojoExecutionException {
        ArrayList<Integer> ports = new ArrayList();
        List<Integer> portsConfigured = this.getTcpPorts(tcpConfig);
        String host = this.getTcpHost(tcpConfig, projectProperties);
        WaitConfiguration.TcpConfigMode mode = this.getTcpMode(tcpConfig, host, projectProperties);
        if (mode == WaitConfiguration.TcpConfigMode.mapped) {
            for (int port : portsConfigured) {
                Container.PortBinding binding = container.getPortBindings().get(port + "/tcp");
                if (binding == null) {
                    throw new MojoExecutionException(String.format("Cannot watch on port %d, since there is no network binding", port));
                }
                ports.add(binding.getHostPort());
            }
            this.log.info("%s: Waiting for mapped ports %s on host %s", imageConfigDesc, ports, host);
        } else {
            host = container.getIPAddress();
            ports = portsConfigured;
            this.log.info("%s: Waiting for ports %s directly on container with IP (%s).", imageConfigDesc, ports, host);
        }
        WaitUtil.TcpPortChecker tcpWaitChecker = new WaitUtil.TcpPortChecker(host, ports);
        logOut.add("on tcp port '" + tcpWaitChecker.getPending() + "'");
        return tcpWaitChecker;
    }

    private List<Integer> getTcpPorts(WaitConfiguration.TcpConfiguration tcpConfig) throws MojoExecutionException {
        List<Integer> portsConfigured = tcpConfig.getPorts();
        if (portsConfigured == null || portsConfigured.size() == 0) {
            throw new MojoExecutionException("TCP wait config given but no ports to wait on");
        }
        return portsConfigured;
    }

    private WaitConfiguration.TcpConfigMode getTcpMode(WaitConfiguration.TcpConfiguration tcpConfig, String host, Properties projectProperties) {
        WaitConfiguration.TcpConfigMode mode = tcpConfig.getMode();
        if (mode == null) {
            return "localhost".equals(host) ? WaitConfiguration.TcpConfigMode.direct : WaitConfiguration.TcpConfigMode.mapped;
        }
        return mode;
    }

    private String getTcpHost(WaitConfiguration.TcpConfiguration tcpConfig, Properties projectProperties) {
        String host = tcpConfig.getHost();
        if (host == null) {
            host = projectProperties.getProperty("docker.host.address");
        }
        return host;
    }

    private WaitUtil.WaitChecker getLogWaitChecker(final String logPattern, final ServiceHub hub, final String containerId) {
        return new WaitUtil.WaitChecker(){
            boolean first = true;
            LogGetHandle logHandle;
            boolean detected = false;

            @Override
            public synchronized boolean check() {
                if (this.first) {
                    final Pattern pattern = Pattern.compile(logPattern);
                    StartMojo.this.log.debug("LogWaitChecker: Pattern to match '%s'", logPattern);
                    DockerAccess docker = hub.getDockerAccess();
                    this.logHandle = docker.getLogAsync(containerId, new LogCallback(){

                        @Override
                        public void log(int type, Timestamp timestamp, String txt) throws LogCallback.DoneException {
                            StartMojo.this.log.debug("LogWaitChecker: Tying to match '%s' [Pattern: %s] [thread: %d]", txt, logPattern, Thread.currentThread().getId());
                            if (pattern.matcher(txt).find()) {
                                detected = true;
                                throw new LogCallback.DoneException();
                            }
                        }

                        @Override
                        public void error(String error) {
                            StartMojo.this.log.error("%s", error);
                        }
                    });
                    this.first = false;
                }
                return this.detected;
            }

            @Override
            public void cleanUp() {
                if (this.logHandle != null) {
                    this.logHandle.finish();
                }
            }
        };
    }

    protected boolean showLogs(ImageConfiguration imageConfig) {
        if (this.showLogs != null) {
            if (this.showLogs.equalsIgnoreCase("true")) {
                return true;
            }
            if (this.showLogs.equalsIgnoreCase("false")) {
                return false;
            }
            return ConfigHelper.matchesConfiguredImages(this.showLogs, imageConfig);
        }
        RunImageConfiguration runConfig = imageConfig.getRunConfiguration();
        if (runConfig != null) {
            LogConfiguration logConfig = runConfig.getLogConfiguration();
            if (logConfig != null) {
                return logConfig.isEnabled();
            }
            return this.follow;
        }
        return false;
    }

    private void exposeContainerProps(QueryService queryService, String containerId, String alias) throws DockerAccessException {
        if (StringUtils.isNotEmpty((String)this.exposeContainerProps) && StringUtils.isNotEmpty((String)alias)) {
            Container container = queryService.getMandatoryContainer(containerId);
            Properties props = this.project.getProperties();
            String prefix = this.addDot(this.exposeContainerProps) + this.addDot(alias);
            props.put(prefix + "id", containerId);
            String ip = container.getIPAddress();
            if (StringUtils.isNotEmpty((String)ip)) {
                props.put(prefix + "ip", ip);
            }
        }
    }

    private String addDot(String part) {
        return part.endsWith(".") ? part : part + ".";
    }
}

