/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.util.Logger;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class AnsiLogger
implements Logger {
    private static final String LOG_PREFIX = "DOCKER> ";
    private final Log log;
    private boolean verbose;
    private static Ansi.Color COLOR_ERROR = Ansi.Color.RED;
    private static Ansi.Color COLOR_INFO = Ansi.Color.GREEN;
    private static Ansi.Color COLOR_WARNING = Ansi.Color.YELLOW;
    private static Ansi.Color COLOR_PROGRESS_ID = Ansi.Color.YELLOW;
    private static Ansi.Color COLOR_PROGRESS_STATUS = Ansi.Color.GREEN;
    private static Ansi.Color COLOR_PROGRESS_BAR = Ansi.Color.CYAN;
    private ThreadLocal<Map<String, Integer>> imageLines = new ThreadLocal();
    private String oldImageId;
    private boolean useAnsi;

    public AnsiLogger(Log log, boolean useColor, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
        this.initializeColor(useColor);
    }

    @Override
    public void debug(String message) {
        this.log.debug((CharSequence)(LOG_PREFIX + message));
    }

    public void debug(String format, Object ... args) {
        this.log.debug((CharSequence)(LOG_PREFIX + String.format(format, args)));
    }

    @Override
    public void info(String message) {
        this.log.info((CharSequence)AnsiLogger.colored(message, COLOR_INFO, true));
    }

    @Override
    public void verbose(String message) {
        if (this.verbose) {
            this.log.info((CharSequence)Ansi.ansi().fgBright(Ansi.Color.BLACK).a(LOG_PREFIX).a(message).reset().toString());
        }
    }

    @Override
    public void warn(String message) {
        this.log.warn((CharSequence)AnsiLogger.colored(message, COLOR_WARNING, true));
    }

    @Override
    public void error(String message) {
        this.log.error((CharSequence)AnsiLogger.colored(message, COLOR_ERROR, true));
    }

    @Override
    public String errorMessage(String message) {
        return AnsiLogger.colored(message, COLOR_ERROR, false);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void progressStart() {
        if (this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.imageLines.set(new HashMap());
            this.oldImageId = null;
        }
    }

    @Override
    public void progressUpdate(String layerId, String status, String progressMessage) {
        if (this.log.isInfoEnabled() && StringUtils.isNotEmpty((String)layerId)) {
            if (this.useAnsi) {
                this.updateAnsiProgress(layerId, status, progressMessage);
            } else {
                this.updateNonAnsiProgress(layerId);
            }
            this.flush();
        }
    }

    private void updateAnsiProgress(String imageId, String status, String progressMessage) {
        Map<String, Integer> imgLineMap = this.imageLines.get();
        Integer line = imgLineMap.get(imageId);
        int diff = 0;
        if (line == null) {
            line = imgLineMap.size();
            imgLineMap.put(imageId, line);
        } else {
            diff = imgLineMap.size() - line;
        }
        if (diff > 0) {
            this.print(Ansi.ansi().cursorUp(diff).eraseLine(Ansi.Erase.ALL).toString());
        }
        String progress = progressMessage != null ? progressMessage : "";
        String msg = Ansi.ansi().fg(COLOR_PROGRESS_ID).a(imageId).reset().a(": ").fg(COLOR_PROGRESS_STATUS).a(StringUtils.rightPad((String)status, (int)11) + " ").fg(COLOR_PROGRESS_BAR).a(progress).toString();
        this.println(msg);
        if (diff > 0) {
            this.print(Ansi.ansi().cursorDown(diff - 1).toString());
        }
    }

    private void updateNonAnsiProgress(String imageId) {
        if (!imageId.equals(this.oldImageId)) {
            this.print("\n" + imageId + ": .");
            this.oldImageId = imageId;
        } else {
            this.print(".");
        }
    }

    @Override
    public void progressFinished() {
        if (this.log.isInfoEnabled()) {
            this.imageLines.remove();
            this.oldImageId = null;
            this.print(Ansi.ansi().reset().toString());
            if (!this.useAnsi) {
                this.println("");
            }
        }
    }

    private void flush() {
        System.out.flush();
    }

    private void initializeColor(boolean useColor) {
        boolean bl = this.useAnsi = useColor && System.console() != null && !this.log.isDebugEnabled() && !this.isWindows();
        if (this.useAnsi) {
            AnsiConsole.systemInstall();
            Ansi.setEnabled((boolean)true);
        } else {
            Ansi.setEnabled((boolean)false);
        }
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    private void println(String txt) {
        System.out.println(txt);
    }

    private void print(String txt) {
        System.out.print(txt);
    }

    private static String colored(String message, Ansi.Color color, boolean addPrefix) {
        Ansi ansi = Ansi.ansi().fg(color);
        if (addPrefix) {
            ansi.a(LOG_PREFIX);
        }
        return ansi.a(message).reset().toString();
    }
}

