/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.chunked;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.chunked.EntityStreamReaderUtil;
import io.fabric8.maven.docker.util.Logger;
import org.json.JSONObject;

public class PullOrPushResponseJsonHandler
implements EntityStreamReaderUtil.JsonEntityResponseHandler {
    private final Logger log;

    public PullOrPushResponseJsonHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void process(JSONObject json) throws DockerAccessException {
        if (json.has("progressDetail")) {
            this.log.progressUpdate(this.getStringOrEmpty(json, "id"), this.getStringOrEmpty(json, "status"), this.getStringOrEmpty(json, "progress"));
        } else if (json.has("error")) {
            this.throwDockerAccessException(json);
        } else {
            this.log.progressFinished();
            this.logInfoMessage(json);
            this.log.progressStart();
        }
    }

    private void logInfoMessage(JSONObject json) {
        String value = json.has("stream") ? json.getString("stream").replaceFirst("\n$", "") : (json.has("status") ? json.getString("status") : json.toString());
        this.log.info(value);
    }

    private void throwDockerAccessException(JSONObject json) throws DockerAccessException {
        String msg = json.getString("error").trim();
        String details = json.getJSONObject("errorDetail").getString("message").trim();
        throw new DockerAccessException("%s %s", msg, msg.equals(details) ? "" : "(" + details + ")");
    }

    private String getStringOrEmpty(JSONObject json, String what) {
        return json.has(what) ? json.getString(what) : "";
    }

    @Override
    public void start() {
        this.log.progressStart();
    }

    @Override
    public void stop() {
        this.log.progressFinished();
    }
}

