/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Timestamp
implements Comparable<Timestamp> {
    private DateTime date;
    private int rest;
    private static Pattern TS_PATTERN = Pattern.compile("^(.*?)(?:\\.(\\d{3})(\\d*))?([^\\d]*?)$");

    public Timestamp() {
        this.date = new DateTime();
    }

    public Timestamp(String spec) {
        Matcher matcher = TS_PATTERN.matcher(spec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp '" + spec + "' given.");
        }
        String millis = matcher.group(2);
        String rest = matcher.group(3);
        this.rest = rest != null ? Integer.parseInt(rest) : 0;
        DateTimeFormatter parser = ISODateTimeFormat.dateTime();
        this.date = parser.parseDateTime(matcher.group(1) + (millis != null ? "." + millis : ".000") + matcher.group(4));
    }

    public DateTime getDate() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp timestamp = (Timestamp)o;
        if (this.rest != timestamp.rest) {
            return false;
        }
        return this.date.equals((Object)timestamp.date);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = 31 * result + (this.rest ^ this.rest >>> 32);
        return result;
    }

    @Override
    public int compareTo(Timestamp ts) {
        int fc = this.date.compareTo((ReadableInstant)ts.date);
        if (fc != 0) {
            return fc;
        }
        return this.rest - ts.rest;
    }

    public String toString() {
        return this.date.toString();
    }
}

