/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import io.fabric8.maven.docker.util.Logger;
import org.apache.maven.plugin.logging.Log;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class AnsiLogger
implements Logger {
    private static final String LOG_PREFIX = "DOCKER> ";
    private final Log log;
    private int oldProgress = 0;
    private int total = 0;
    private boolean verbose;
    private static Ansi.Color COLOR_ERROR = Ansi.Color.RED;
    private static Ansi.Color COLOR_INFO = Ansi.Color.GREEN;
    private static Ansi.Color COLOR_WARNING = Ansi.Color.YELLOW;
    private static Ansi.Color COLOR_PROGRESS = Ansi.Color.CYAN;

    public AnsiLogger(Log log, boolean useColor, boolean verbose) {
        this.log = log;
        this.verbose = verbose;
        this.initializeColor(useColor);
    }

    @Override
    public void debug(String message) {
        this.log.debug((CharSequence)(LOG_PREFIX + message));
    }

    public void debug(String format, Object ... args) {
        this.log.debug((CharSequence)(LOG_PREFIX + String.format(format, args)));
    }

    @Override
    public void info(String message) {
        this.log.info((CharSequence)AnsiLogger.colored(message, COLOR_INFO, true));
    }

    @Override
    public void verbose(String message) {
        if (this.verbose) {
            this.log.info((CharSequence)Ansi.ansi().fgBright(Ansi.Color.BLACK).a(LOG_PREFIX).a(message).reset().toString());
        }
    }

    @Override
    public void warn(String message) {
        this.log.warn((CharSequence)AnsiLogger.colored(message, COLOR_WARNING, true));
    }

    @Override
    public void error(String message) {
        this.log.error((CharSequence)AnsiLogger.colored(message, COLOR_ERROR, true));
    }

    @Override
    public String errorMessage(String message) {
        return AnsiLogger.colored(message, COLOR_ERROR, false);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    @Override
    public void progressStart(int total) {
        if (this.log.isInfoEnabled()) {
            this.print(Ansi.ansi().fg(COLOR_PROGRESS) + "       ");
            this.oldProgress = 0;
            this.total = total;
        }
    }

    @Override
    public void progressUpdate(int current) {
        if (this.log.isInfoEnabled()) {
            this.print("=");
            int newProgress = (current * 10 + 5) / this.total;
            if (newProgress > this.oldProgress) {
                this.print(" " + newProgress + "0% ");
                this.oldProgress = newProgress;
            }
            this.flush();
        }
    }

    @Override
    public void progressFinished() {
        if (this.log.isInfoEnabled()) {
            this.println(Ansi.ansi().reset().toString());
            this.oldProgress = 0;
            this.total = 0;
        }
    }

    private void flush() {
        System.out.flush();
    }

    private void initializeColor(boolean useColor) {
        if (System.console() == null || this.log.isDebugEnabled() || this.isWindows()) {
            useColor = false;
        }
        if (useColor) {
            AnsiConsole.systemInstall();
            Ansi.setEnabled((boolean)true);
        } else {
            Ansi.setEnabled((boolean)false);
        }
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("windows");
    }

    private void println(String txt) {
        System.out.println(txt);
    }

    private void print(String txt) {
        System.out.print(txt);
    }

    private static String colored(String message, Ansi.Color color, boolean addPrefix) {
        Ansi ansi = Ansi.ansi().fg(color);
        if (addPrefix) {
            ansi.a(LOG_PREFIX);
        }
        return ansi.a(message).reset().toString();
    }
}

