/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.hc;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.ContainerCreateConfig;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.UrlBuilder;
import io.fabric8.maven.docker.access.chunked.BuildJsonResponseHandler;
import io.fabric8.maven.docker.access.chunked.EntityStreamReaderUtil;
import io.fabric8.maven.docker.access.chunked.PullOrPushResponseJsonHandler;
import io.fabric8.maven.docker.access.hc.ApacheHttpClientDelegate;
import io.fabric8.maven.docker.access.hc.http.HttpClientBuilder;
import io.fabric8.maven.docker.access.hc.unix.UnixSocketClientBuilder;
import io.fabric8.maven.docker.access.log.LogCallback;
import io.fabric8.maven.docker.access.log.LogGetHandle;
import io.fabric8.maven.docker.access.log.LogRequestor;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.log.DefaultLogCallback;
import io.fabric8.maven.docker.log.LogOutputSpec;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.model.ContainerDetails;
import io.fabric8.maven.docker.model.ContainersListElement;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.Timestamp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class DockerAccessWithHcClient
implements DockerAccess {
    private static final String DUMMY_BASE_URL = "unix://127.0.0.1:1/";
    private final Logger log;
    private final ApacheHttpClientDelegate delegate;
    private final UrlBuilder urlBuilder;

    public DockerAccessWithHcClient(String apiVersion, String baseUrl, String certPath, int maxConnections, Logger log) throws IOException {
        this.log = log;
        URI uri = URI.create(baseUrl);
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("The docker access url '" + baseUrl + "' must contain a schema tcp:// or unix://");
        }
        if (uri.getScheme().equalsIgnoreCase("unix")) {
            this.delegate = new ApacheHttpClientDelegate(new UnixSocketClientBuilder().build(uri.getPath(), maxConnections));
            this.urlBuilder = new UrlBuilder(DUMMY_BASE_URL, apiVersion);
        } else {
            HttpClientBuilder builder = new HttpClientBuilder();
            if (this.isSSL(baseUrl)) {
                builder.certPath(certPath);
            }
            builder.maxConnections(maxConnections);
            this.delegate = new ApacheHttpClientDelegate(builder.build());
            this.urlBuilder = new UrlBuilder(baseUrl, apiVersion);
        }
    }

    @Override
    public void startExecContainer(String containerId, LogOutputSpec outputSpec) throws DockerAccessException {
        try {
            String url = this.urlBuilder.startExecContainer(containerId);
            JSONObject request = new JSONObject();
            request.put("Detach", false);
            request.put("Tty", true);
            this.delegate.post(url, (Object)request.toString(), this.createExecResponseHandler(outputSpec), 200);
        }
        catch (Exception e) {
            throw new DockerAccessException(e, "Unable to start container id [%s]", containerId);
        }
    }

    private ResponseHandler<Object> createExecResponseHandler(LogOutputSpec outputSpec) throws FileNotFoundException {
        final DefaultLogCallback callback = new DefaultLogCallback(outputSpec);
        return new ResponseHandler<Object>(){

            public Object handleResponse(HttpResponse response) throws IOException {
                try (InputStream stream = response.getEntity().getContent();){
                    LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            callback.log(1, new Timestamp(), line);
                        }
                    }
                    catch (LogCallback.DoneException doneException) {
                        // empty catch block
                    }
                }
                return null;
            }
        };
    }

    @Override
    public String createExecContainer(String containerId, Arguments arguments) throws DockerAccessException {
        String url = this.urlBuilder.createExecContainer(containerId);
        JSONObject request = new JSONObject();
        request.put("Tty", true);
        request.put("AttachStdin", false);
        request.put("AttachStdout", true);
        request.put("AttachStderr", true);
        request.put("Cmd", arguments.getExec());
        String execJsonRequest = request.toString();
        try {
            String response = this.delegate.post(url, (Object)execJsonRequest, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JSONObject json = new JSONObject(response);
            if (json.has("Warnings")) {
                this.logWarnings(json);
            }
            return json.getString("Id");
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to exec [%s] on container [%s]", request.toString(), containerId);
        }
    }

    @Override
    public String createContainer(ContainerCreateConfig containerConfig, String containerName) throws DockerAccessException {
        String createJson = containerConfig.toJson();
        this.log.debug("Container create config: " + createJson);
        try {
            String url = this.urlBuilder.createContainer(containerName);
            String response = this.delegate.post(url, (Object)createJson, new ApacheHttpClientDelegate.BodyResponseHandler(), 201);
            JSONObject json = new JSONObject(response);
            this.logWarnings(json);
            return json.getString("Id").substring(0, 12);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to create container for [%s]", containerConfig.getImageName());
        }
    }

    @Override
    public void startContainer(String containerId) throws DockerAccessException {
        try {
            String url = this.urlBuilder.startContainer(containerId);
            this.delegate.post(url, 204, 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to start container id [%s]", containerId);
        }
    }

    @Override
    public void stopContainer(String containerId, int killWait) throws DockerAccessException {
        try {
            String url = this.urlBuilder.stopContainer(containerId, killWait);
            this.delegate.post(url, 204, 304);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to stop container id [%s]", containerId);
        }
    }

    @Override
    public void buildImage(String image, File dockerArchive, boolean forceRemove, boolean noCache) throws DockerAccessException {
        try {
            String url = this.urlBuilder.buildImage(image, forceRemove, noCache);
            this.delegate.post(url, (Object)dockerArchive, this.createBuildResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to build image [%s]", image);
        }
    }

    @Override
    public void copyArchive(String containerId, File archive, String targetPath) throws DockerAccessException {
        try {
            String url = this.urlBuilder.copyArchive(containerId, targetPath);
            this.delegate.put(url, archive, 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to copy archive %s to container [%s] with path %s", archive.toPath(), containerId, targetPath);
        }
    }

    @Override
    public void getLogSync(String containerId, LogCallback callback) {
        LogRequestor extractor = new LogRequestor((HttpClient)this.delegate.getHttpClient(), this.urlBuilder, containerId, callback);
        extractor.fetchLogs();
    }

    @Override
    public LogGetHandle getLogAsync(String containerId, LogCallback callback) {
        LogRequestor extractor = new LogRequestor((HttpClient)this.delegate.getHttpClient(), this.urlBuilder, containerId, callback);
        extractor.start();
        return extractor;
    }

    @Override
    public Container inspectContainer(String containerId) throws DockerAccessException {
        try {
            String url = this.urlBuilder.inspectContainer(containerId);
            String response = this.delegate.get(url, 200);
            return new ContainerDetails(new JSONObject(response));
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to retrieve container name for [%s]", containerId);
        }
    }

    @Override
    public List<Container> listContainers(int limit) throws DockerAccessException {
        String url = this.urlBuilder.listContainers(limit);
        try {
            String response = this.delegate.get(url, 200);
            JSONArray array = new JSONArray(response);
            ArrayList<Container> containers = new ArrayList<Container>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                containers.add(new ContainersListElement(array.getJSONObject(i)));
            }
            return containers;
        }
        catch (IOException e) {
            throw new DockerAccessException(e.getMessage());
        }
    }

    @Override
    public boolean hasImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.StatusCodeResponseHandler(), 200, 404) == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to check image [%s]", name);
        }
    }

    @Override
    public String getImageId(String name) throws DockerAccessException {
        ApacheHttpClientDelegate.HttpBodyAndStatus response = this.inspectImage(name);
        if (response.getStatusCode() == 404) {
            return null;
        }
        JSONObject imageDetails = new JSONObject(response.getBody());
        return imageDetails.getString("Id").substring(0, 12);
    }

    private ApacheHttpClientDelegate.HttpBodyAndStatus inspectImage(String name) throws DockerAccessException {
        String url = this.urlBuilder.inspectImage(name);
        try {
            return this.delegate.get(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to inspect image [%s]", name);
        }
    }

    @Override
    public void removeContainer(String containerId, boolean removeVolumes) throws DockerAccessException {
        try {
            String url = this.urlBuilder.removeContainer(containerId, removeVolumes);
            this.delegate.delete(url, 204);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove container [%s]", containerId);
        }
    }

    @Override
    public void pullImage(String image, AuthConfig authConfig, String registry) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String pullUrl = this.urlBuilder.pullImage(name, registry);
        try {
            this.delegate.post(pullUrl, null, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to pull '%s'%s", image, registry != null ? " from registry '" + registry + "'" : "");
        }
    }

    @Override
    public void pushImage(String image, AuthConfig authConfig, String registry) throws DockerAccessException {
        ImageName name = new ImageName(image);
        String pushUrl = this.urlBuilder.pushImage(name, registry);
        String temporaryImage = this.tagTemporaryImage(name, registry);
        try {
            this.delegate.post(pushUrl, null, this.createAuthHeader(authConfig), this.createPullOrPushResponseHandler(), 200);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to push '%s'%s", image, registry != null ? " from registry '" + registry + "'" : "");
        }
        finally {
            if (temporaryImage != null) {
                this.removeImage(temporaryImage, new boolean[0]);
            }
        }
    }

    @Override
    public void tag(String sourceImage, String targetImage, boolean force) throws DockerAccessException {
        ImageName source = new ImageName(sourceImage);
        ImageName target = new ImageName(targetImage);
        try {
            String url = this.urlBuilder.tagContainer(source, target, force);
            this.delegate.post(url, 201);
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to add tag [%s] to image [%s]", targetImage, sourceImage, e);
        }
    }

    @Override
    public boolean removeImage(String image, boolean ... forceOpt) throws DockerAccessException {
        boolean force = forceOpt != null && forceOpt.length > 0 && forceOpt[0];
        try {
            String url = this.urlBuilder.deleteImage(image, force);
            ApacheHttpClientDelegate.HttpBodyAndStatus response = this.delegate.delete(url, new ApacheHttpClientDelegate.BodyAndStatusResponseHandler(), 200, 404);
            if (this.log.isDebugEnabled()) {
                this.logRemoveResponse(new JSONArray(response.getBody()));
            }
            return response.getStatusCode() == 200;
        }
        catch (IOException e) {
            throw new DockerAccessException(e, "Unable to remove image [%s]", image);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    private HcChunckedResponseHandlerWrapper createBuildResponseHandler() {
        return new HcChunckedResponseHandlerWrapper(this.log, new BuildJsonResponseHandler(this.log));
    }

    private HcChunckedResponseHandlerWrapper createPullOrPushResponseHandler() {
        return new HcChunckedResponseHandlerWrapper(this.log, new PullOrPushResponseJsonHandler(this.log));
    }

    private Map<String, String> createAuthHeader(AuthConfig authConfig) {
        if (authConfig == null) {
            authConfig = AuthConfig.EMPTY_AUTH_CONFIG;
        }
        return Collections.singletonMap("X-Registry-Auth", authConfig.toHeaderValue());
    }

    private String tagTemporaryImage(ImageName name, String registry) throws DockerAccessException {
        String targetImage = name.getFullName(registry);
        if (!name.hasRegistry() && registry != null && !this.hasImage(targetImage)) {
            this.tag(name.getFullName(null), targetImage, false);
            return targetImage;
        }
        return null;
    }

    private void logWarnings(JSONObject body) {
        Object warningsObj = body.get("Warnings");
        if (warningsObj != JSONObject.NULL) {
            JSONArray warnings = (JSONArray)warningsObj;
            for (int i = 0; i < warnings.length(); ++i) {
                this.log.warn(warnings.getString(i));
            }
        }
    }

    private void logRemoveResponse(JSONArray logElements) {
        for (int i = 0; i < logElements.length(); ++i) {
            JSONObject entry = logElements.getJSONObject(i);
            for (Object key : entry.keySet()) {
                this.log.debug(key + ": " + entry.get(key.toString()));
            }
        }
    }

    private boolean isSSL(String url) {
        return url != null && url.toLowerCase().startsWith("https");
    }

    private static class HcChunckedResponseHandlerWrapper
    implements ResponseHandler<Object> {
        private EntityStreamReaderUtil.JsonEntityResponseHandler handler;
        private Logger log;

        public HcChunckedResponseHandlerWrapper(Logger log, EntityStreamReaderUtil.JsonEntityResponseHandler handler) {
            this.log = log;
            this.handler = handler;
        }

        public Object handleResponse(HttpResponse response) throws IOException {
            try (InputStream stream = response.getEntity().getContent();){
                EntityStreamReaderUtil.processJsonStream(this.handler, stream);
            }
            return null;
        }
    }
}

