/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ArchiveService;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;

public class BuildService {
    private final DockerAccess docker;
    private final QueryService queryService;
    public final ArchiveService archiveService;
    private final Logger log;

    BuildService(DockerAccess docker, QueryService queryService, ArchiveService archiveService, Logger log) {
        this.docker = docker;
        this.queryService = queryService;
        this.archiveService = archiveService;
        this.log = log;
    }

    public void buildImage(ImageConfiguration imageConfig, MojoParameters params, boolean noCache) throws DockerAccessException, MojoExecutionException {
        String imageName = imageConfig.getName();
        BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
        String oldImageId = null;
        if (buildConfig.cleanup()) {
            oldImageId = this.queryService.getImageId(imageName);
        }
        File dockerArchive = this.archiveService.createArchive(imageName, buildConfig, params);
        String newImageId = this.doBuildImage(imageName, dockerArchive, buildConfig.cleanup(), noCache);
        this.log.info(imageConfig.getDescription() + ": Built image " + newImageId);
        if (this.oldImageShouldBeRemoved(oldImageId, newImageId)) {
            this.docker.removeImage(oldImageId, true);
            this.log.info(imageConfig.getDescription() + ": Removed image " + oldImageId);
        }
    }

    private String doBuildImage(String imageName, File dockerArchive, boolean cleanUp, boolean noCache) throws DockerAccessException, MojoExecutionException {
        this.docker.buildImage(imageName, dockerArchive, cleanUp, noCache);
        return this.queryService.getImageId(imageName);
    }

    private boolean oldImageShouldBeRemoved(String oldImageId, String newImageId) {
        return oldImageId != null && !oldImageId.equals(newImageId);
    }
}

