/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access.chunked;

import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.chunked.EntityStreamReaderUtil;
import io.fabric8.maven.docker.util.Logger;
import org.json.JSONObject;

public class BuildJsonResponseHandler
implements EntityStreamReaderUtil.JsonEntityResponseHandler {
    private final Logger log;

    public BuildJsonResponseHandler(Logger log) {
        this.log = log;
    }

    @Override
    public void process(JSONObject json) throws DockerAccessException {
        if (json.has("error")) {
            String msg = json.getString("error");
            this.log.error("Error building image: " + msg);
            String detailMsg = "";
            if (json.has("errorDetail")) {
                JSONObject details = json.getJSONObject("errorDetail");
                detailMsg = details.getString("message");
                this.log.error(detailMsg);
            }
            throw new DockerAccessException("%s %s", json.get("error"), msg.equals(detailMsg) || "".equals(detailMsg) ? "" : "(" + detailMsg + ")");
        }
        if (json.has("stream")) {
            String message = json.getString("stream");
            this.log.verbose(message.trim());
        } else if (json.has("status")) {
            String id;
            String status = json.getString("status").trim();
            String string = id = json.has("id") ? json.getString("id") : null;
            if (status.matches("^.*(Download|Pulling).*")) {
                this.log.info("  " + (id != null ? id + " " : "") + status);
            }
        }
    }
}

