/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.AbstractBuildSupportMojo;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.util.MojoParameters;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="source", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class SourceMojo
extends AbstractBuildSupportMojo {
    @Component
    private MavenProjectHelper projectHelper;

    @Override
    protected void executeInternal(ServiceHub hub) throws DockerAccessException, MojoExecutionException {
        MojoParameters params = this.createMojoParameters();
        for (ImageConfiguration imageConfig : this.getImages()) {
            BuildImageConfiguration buildConfig = imageConfig.getBuildConfiguration();
            if (buildConfig == null) continue;
            if (buildConfig.skip()) {
                this.log.info(imageConfig.getDescription() + ": Skipped creating source");
                continue;
            }
            File dockerTar = hub.getArchiveService().createDockerBuildArchive(imageConfig, params);
            String alias = imageConfig.getAlias();
            if (alias == null) {
                throw new IllegalArgumentException("Image " + imageConfig.getDescription() + " must have an 'alias' configured to be " + "used as a classifier for attaching a docker build tar as source to the maven build");
            }
            this.projectHelper.attachArtifact(this.project, buildConfig.getCompression().getFileSuffix(), "docker-" + alias, dockerTar);
        }
    }

    @Override
    protected boolean isDockerAccessRequired() {
        return false;
    }
}

