/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.access.DockerAccessException;
import io.fabric8.maven.docker.access.hc.DockerAccessWithHcClient;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.handler.ImageConfigResolver;
import io.fabric8.maven.docker.log.LogDispatcher;
import io.fabric8.maven.docker.log.LogOutputSpecFactory;
import io.fabric8.maven.docker.service.QueryService;
import io.fabric8.maven.docker.service.ServiceHub;
import io.fabric8.maven.docker.service.ServiceHubFactory;
import io.fabric8.maven.docker.util.AnsiLogger;
import io.fabric8.maven.docker.util.AuthConfigFactory;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.PomLabel;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractDockerMojo
extends AbstractMojo
implements Contextualizable {
    public static final String CONTEXT_KEY_START_CALLED = "CONTEXT_KEY_DOCKER_START_CALLED";
    public static final String CONTEXT_KEY_LOG_DISPATCHER = "CONTEXT_KEY_DOCKER_LOG_DISPATCHER";
    public static final String DOCKER_HTTPS_PORT = "2376";
    public static final String API_VERSION = "1.18";
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession session;
    @Component
    protected ImageConfigResolver imageConfigResolver;
    @Component
    protected ServiceHubFactory serviceHubFactory;
    @Parameter(property="docker.autoPull", defaultValue="on")
    protected String autoPull;
    @Parameter(property="docker.keepContainer", defaultValue="false")
    protected boolean keepContainer;
    @Parameter(property="docker.removeVolumes", defaultValue="false")
    protected boolean removeVolumes;
    @Parameter(property="docker.apiVersion")
    private String apiVersion;
    @Parameter(property="docker.host")
    private String dockerHost;
    @Parameter(property="docker.certPath")
    private String certPath;
    @Parameter(property="docker.useColor", defaultValue="true")
    protected boolean useColor;
    @Parameter(property="docker.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="docker.logDate")
    private String logDate;
    @Parameter(property="docker.logStdout", defaultValue="false")
    private boolean logStdout;
    @Parameter(property="docker.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="docker.image")
    private String image;
    @Parameter(property="docker.registry")
    protected String registry;
    @Parameter(property="docker.maxConnections", defaultValue="100")
    private int maxConnections;
    @Parameter
    protected String portPropertyFile;
    @Parameter
    Map authConfig;
    @Parameter
    private List<ImageConfiguration> images;
    private AuthConfigFactory authConfigFactory;
    protected Logger log;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.log = new AnsiLogger(this.getLog(), this.useColor, this.verbose);
            LogOutputSpecFactory logSpecFactory = new LogOutputSpecFactory(this.useColor, this.logStdout, this.logDate);
            String minimalApiVersion = this.validateConfiguration(this.log);
            DockerAccess access = null;
            try {
                access = this.createDockerAccess(minimalApiVersion);
                ServiceHub serviceHub = this.serviceHubFactory.createServiceHub(this.project, this.session, access, this.log, logSpecFactory);
                this.executeInternal(serviceHub);
            }
            catch (DockerAccessException exp) {
                throw new MojoExecutionException(this.log.errorMessage(exp.getMessage()), (Exception)exp);
            }
            finally {
                if (access != null) {
                    access.shutdown();
                }
            }
        }
    }

    private DockerAccess createDockerAccess(String minimalVersion) throws MojoExecutionException, MojoFailureException {
        DockerAccessWithHcClient access = null;
        if (this.isDockerAccessRequired()) {
            String dockerUrl = EnvUtil.extractUrl(this.dockerHost);
            try {
                String version = minimalVersion != null ? minimalVersion : API_VERSION;
                access = new DockerAccessWithHcClient("v" + version, dockerUrl, EnvUtil.getCertPath(this.certPath), this.maxConnections, this.log);
                access.start();
                this.setDockerHostAddressProperty(dockerUrl);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create docker access object ", (Exception)e);
            }
        }
        return access;
    }

    protected boolean isDockerAccessRequired() {
        return true;
    }

    private String validateConfiguration(Logger log) {
        String apiVersion = this.apiVersion;
        if (this.images != null) {
            for (ImageConfiguration imageConfiguration : this.images) {
                apiVersion = EnvUtil.extractLargerVersion(apiVersion, imageConfiguration.validate(log));
            }
        }
        return apiVersion;
    }

    protected abstract void executeInternal(ServiceHub var1) throws DockerAccessException, MojoExecutionException;

    protected List<ImageConfiguration> getImages() {
        List<ImageConfiguration> resolvedImages = this.resolveImages();
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        for (ImageConfiguration imageConfig : resolvedImages) {
            if (!this.matchesConfiguredImages(this.image, imageConfig)) continue;
            ret.add(imageConfig);
        }
        return ret;
    }

    private List<ImageConfiguration> resolveImages() {
        ArrayList<ImageConfiguration> ret = new ArrayList<ImageConfiguration>();
        if (this.images != null) {
            for (ImageConfiguration image : this.images) {
                ret.addAll(this.imageConfigResolver.resolve(image, this.project.getProperties()));
            }
            this.verifyImageNames(ret);
        }
        return ret;
    }

    private void verifyImageNames(List<ImageConfiguration> ret) {
        for (ImageConfiguration config : ret) {
            if (config.getName() != null) continue;
            throw new IllegalArgumentException("Configuration error: <image> must have a non-null <name>");
        }
    }

    protected boolean matchesConfiguredImages(String imageList, ImageConfiguration imageConfig) {
        if (imageList == null) {
            return true;
        }
        HashSet<String> imagesAllowed = new HashSet<String>(Arrays.asList(imageList.split("\\s*,\\s*")));
        return imagesAllowed.contains(imageConfig.getName()) || imagesAllowed.contains(imageConfig.getAlias());
    }

    private void setDockerHostAddressProperty(String dockerUrl) throws MojoFailureException {
        Properties props = this.project.getProperties();
        if (props.getProperty("docker.host.address") == null) {
            String host;
            try {
                URI uri = new URI(dockerUrl);
                host = uri.getHost() == null && uri.getScheme().equals("unix") ? "localhost" : uri.getHost();
            }
            catch (URISyntaxException e) {
                throw new MojoFailureException("Cannot parse " + dockerUrl + " as URI: " + e.getMessage(), (Throwable)e);
            }
            props.setProperty("docker.host.address", host == null ? "" : host);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.authConfigFactory = new AuthConfigFactory((PlexusContainer)context.get((Object)"plexus"));
    }

    protected PomLabel getPomLabel() {
        return new PomLabel(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
    }

    protected AuthConfig prepareAuthConfig(ImageName image, String configuredRegistry, boolean isPush) throws MojoExecutionException {
        String user = isPush ? image.getUser() : null;
        String registry = image.getRegistry() != null ? image.getRegistry() : configuredRegistry;
        return this.authConfigFactory.createAuthConfig(isPush, this.authConfig, this.settings, user, registry);
    }

    protected LogDispatcher getLogDispatcher(ServiceHub hub) {
        LogDispatcher dispatcher = (LogDispatcher)this.getPluginContext().get(CONTEXT_KEY_LOG_DISPATCHER);
        if (dispatcher == null) {
            dispatcher = new LogDispatcher(hub.getDockerAccess());
            this.getPluginContext().put(CONTEXT_KEY_LOG_DISPATCHER, dispatcher);
        }
        return dispatcher;
    }

    protected String getConfiguredRegistry(ImageConfiguration imageConfig, String specificRegistry) {
        return EnvUtil.findRegistry(imageConfig.getRegistry(), specificRegistry, this.registry);
    }

    protected void checkImageWithAutoPull(ServiceHub hub, String image, String registry, boolean autoPullAlwaysAllowed) throws DockerAccessException, MojoExecutionException {
        QueryService queryService = hub.getQueryService();
        if (!queryService.imageRequiresAutoPull(this.autoPull, image, autoPullAlwaysAllowed)) {
            return;
        }
        DockerAccess docker = hub.getDockerAccess();
        ImageName imageName = new ImageName(image);
        docker.pullImage(this.withLatestIfNoTag(image), this.prepareAuthConfig(imageName, registry, false), registry);
        if (registry != null && !imageName.hasRegistry()) {
            docker.tag(imageName.getFullName(registry), image, false);
        }
    }

    private String withLatestIfNoTag(String name) {
        ImageName imageName = new ImageName(name);
        return imageName.getTag() == null ? imageName.getNameWithoutTag() + ":latest" : name;
    }
}

