/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api;

import io.fabric8.docker.api.Auth;
import io.fabric8.docker.api.Container;
import io.fabric8.docker.api.Image;
import io.fabric8.docker.api.Info;
import io.fabric8.docker.api.Version;
import io.fabric8.docker.api.container.Change;
import io.fabric8.docker.api.container.ContainerConfig;
import io.fabric8.docker.api.container.ContainerCreateStatus;
import io.fabric8.docker.api.container.ContainerInfo;
import io.fabric8.docker.api.container.CopySource;
import io.fabric8.docker.api.container.HostConfig;
import io.fabric8.docker.api.container.Status;
import io.fabric8.docker.api.container.Top;
import io.fabric8.docker.api.image.DeleteInfo;
import io.fabric8.docker.api.image.ImageHistoryItem;
import io.fabric8.docker.api.image.ImageInfo;
import io.fabric8.docker.api.image.ImageSearchResult;
import io.fabric8.docker.api.image.Progress;
import java.io.File;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface Docker {
    public static final String ID = "id";
    public static final String NAME = "name";

    @GET
    @Path(value="/info")
    public Info info();

    @GET
    @Path(value="/version")
    public Version version();

    @GET
    @Path(value="/containers/json")
    public List<Container> containers(@QueryParam(value="all") Integer var1, @QueryParam(value="limit") Integer var2, @QueryParam(value="since") String var3, @QueryParam(value="before") String var4, @QueryParam(value="size") Integer var5);

    @GET
    @Path(value="/container/{id}/json")
    public ContainerInfo containerInspect(@PathParam(value="id") String var1);

    @POST
    @Path(value="/container/create")
    public ContainerCreateStatus containerCreate(ContainerConfig var1, @QueryParam(value="name") String var2);

    @GET
    @Path(value="/container/{id}/top")
    public Top containerTop(@PathParam(value="id") String var1);

    @GET
    @Path(value="/container/{id}/changes")
    public List<Change> containerChanges(@PathParam(value="id") String var1);

    @GET
    @Path(value="/container/{id}/export")
    public byte[] containerExport(@PathParam(value="id") String var1);

    @POST
    @Path(value="/container/{id}/start")
    public void containerStart(@PathParam(value="id") String var1, HostConfig var2);

    @POST
    @Path(value="/container/{id}/stop")
    public void containerStop(@PathParam(value="id") String var1, @QueryParam(value="t") Integer var2);

    @POST
    @Path(value="/container/{id}/restart")
    public void containerRestart(@PathParam(value="id") String var1, @QueryParam(value="t") Integer var2);

    @POST
    @Path(value="/container/{id}/kill")
    public void containerKill(@PathParam(value="id") String var1);

    @POST
    @Path(value="/container/{id}/attach")
    public byte[] containerRestart(@PathParam(value="id") String var1, @QueryParam(value="logs") Integer var2, @QueryParam(value="stream") Integer var3, @QueryParam(value="stdin") Integer var4, @QueryParam(value="stdout") Integer var5, @QueryParam(value="stderr") Integer var6);

    @POST
    @Path(value="/container/{id}/wait")
    public Status containerWait(@PathParam(value="id") String var1);

    @DELETE
    @Path(value="/container/{id}")
    public void containerRemove(@PathParam(value="id") String var1, @QueryParam(value="v") Integer var2);

    @POST
    @Path(value="/container/{id}/copy")
    public byte[] containerCopy(@PathParam(value="id") String var1, CopySource var2);

    @GET
    @Path(value="/images/json")
    public List<Image> images(@QueryParam(value="all") Integer var1);

    @POST
    @Path(value="/images/create")
    public String imageCreate(@QueryParam(value="fromImage") String var1, @QueryParam(value="formSrc") String var2, @QueryParam(value="repo") String var3, @QueryParam(value="tag") String var4, @QueryParam(value="registry") String var5);

    @POST
    @Path(value="/images/{name}/insert")
    public String imageInsert(@PathParam(value="name") String var1, @QueryParam(value="path") String var2, @QueryParam(value="url") String var3);

    @POST
    @Path(value="/images/{name}/json")
    public ImageInfo imageInspect(@PathParam(value="name") String var1);

    @GET
    @Path(value="/images/{name}/history")
    public List<ImageHistoryItem> imageHistory(@PathParam(value="name") String var1);

    @POST
    @Path(value="/images/{name}/push")
    public Progress imagePush(@PathParam(value="name") String var1, @QueryParam(value="tag") String var2, Auth var3);

    @POST
    @Path(value="/images/{name}/tag")
    public void imageTag(@PathParam(value="name") String var1, @QueryParam(value="repo") String var2, @QueryParam(value="force") Integer var3);

    @DELETE
    @Path(value="/images/{name}")
    public List<DeleteInfo> imageDelete(@PathParam(value="name") String var1);

    @GET
    @Path(value="/images/search")
    public List<ImageSearchResult> imageSearch(@QueryParam(value="term") String var1);

    @POST
    @Path(value="/build")
    public Object build(File var1, @QueryParam(value="t") String var2, @QueryParam(value="q") Integer var3, @QueryParam(value="nocache") Integer var4, @QueryParam(value="rm") Integer var5, @QueryParam(value="forcerm") Integer var6);
}

