/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.utils;

import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.sundr.adapter.api.AdapterContext;
import io.sundr.adapter.api.Adapters;
import io.sundr.adapter.reflect.ReflectionContext;
import io.sundr.builder.TypedVisitor;
import io.sundr.builder.Visitor;
import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PrimitiveRef;
import io.sundr.model.Property;
import io.sundr.model.PropertyBuilder;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeDefBuilder;
import io.sundr.model.TypeParamDef;
import io.sundr.model.TypeParamRef;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRef;
import io.sundr.model.WildcardRef;
import io.sundr.model.functions.GetDefinition;
import io.sundr.model.repo.DefinitionRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Types {
    private static final Logger LOGGER = LoggerFactory.getLogger(Types.class);
    private static final String NAMESPACED = Namespaced.class.getName();
    public static final String JAVA_LANG_VOID = "java.lang.Void";
    public static final ReflectionContext REFLECTION_CONTEXT = new ReflectionContext(DefinitionRepository.getRepository());
    private static final String CUSTOM_RESOURCE_NAME = CustomResource.class.getCanonicalName();

    private Types() {
        throw new IllegalStateException("Utility class");
    }

    public static TypeDef typeDefFrom(Class<?> clazz) {
        return Types.unshallow(Adapters.adapt(clazz, (AdapterContext)REFLECTION_CONTEXT));
    }

    public static TypeDef unshallow(TypeDef definition) {
        ArrayList<ClassRef> classRefs = new ArrayList<ClassRef>(Types.projectSuperClasses(definition));
        List<Property> properties = Types.projectProperties(definition);
        return new TypeDef(definition.getKind(), definition.getPackageName(), definition.getName(), definition.getComments(), definition.getAnnotations(), classRefs, definition.getImplementsList(), definition.getParameters(), properties, definition.getConstructors(), definition.getMethods(), definition.getOuterTypeName(), definition.getInnerTypes(), definition.getModifiers(), definition.getAttributes());
    }

    public static TypeDef typeDefFrom(ClassRef classRef) {
        return Types.unshallow(GetDefinition.of((ClassRef)classRef));
    }

    private static TypeDef projectDefinition(ClassRef ref) {
        List arguments = ref.getArguments();
        TypeDef definition = GetDefinition.of((ClassRef)ref);
        if (arguments.isEmpty()) {
            return definition;
        }
        List parameters = definition.getParameters();
        HashMap<String, TypeRef> mappings = new HashMap<String, TypeRef>();
        for (int i = 0; i < arguments.size(); ++i) {
            String name = ((TypeParamDef)parameters.get(i)).getName();
            TypeRef typeRef = (TypeRef)arguments.get(i);
            mappings.put(name, typeRef);
        }
        return ((TypeDefBuilder)new TypeDefBuilder(definition).accept(new Visitor[]{Types.mapClassRefArguments(mappings), Types.mapGenericProperties(mappings)})).build();
    }

    private static TypedVisitor<PropertyBuilder> mapGenericProperties(final Map<String, TypeRef> mappings) {
        return new TypedVisitor<PropertyBuilder>(){

            public void visit(PropertyBuilder property) {
                TypeParamRef typeParamRef;
                String key;
                TypeRef paramRef;
                TypeRef typeRef = property.buildTypeRef();
                if (typeRef instanceof TypeParamRef && (paramRef = (TypeRef)mappings.get(key = (typeParamRef = (TypeParamRef)typeRef).getName())) != null) {
                    property.withTypeRef(paramRef);
                }
            }
        };
    }

    private static TypedVisitor<ClassRefBuilder> mapClassRefArguments(final Map<String, TypeRef> mappings) {
        return new TypedVisitor<ClassRefBuilder>(){

            public void visit(ClassRefBuilder c) {
                ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
                Iterator iterator = c.buildArguments().iterator();
                while (iterator.hasNext()) {
                    TypeParamRef typeParamRef;
                    TypeRef mapping;
                    TypeRef arg;
                    TypeRef mappedRef = arg = (TypeRef)iterator.next();
                    if (arg instanceof TypeParamRef && (mapping = (TypeRef)mappings.get((typeParamRef = (TypeParamRef)arg).getName())) != null) {
                        mappedRef = mapping;
                    }
                    arguments.add(mappedRef);
                }
                c.withArguments(arguments);
            }
        };
    }

    private static Set<ClassRef> projectSuperClasses(TypeDef definition) {
        List extendsList = definition.getExtendsList();
        return extendsList.stream().flatMap(s -> Stream.concat(Stream.of(s), Types.projectDefinition(s).getExtendsList().stream())).collect(Collectors.toSet());
    }

    private static List<Property> projectProperties(TypeDef typeDef) {
        String fqn = typeDef.getFullyQualifiedName();
        return Stream.concat(typeDef.getProperties().stream().filter(p -> {
            TypeRef typeRef;
            if (typeDef.isEnum() && (typeRef = p.getTypeRef()) instanceof ClassRef && fqn.equals(((ClassRef)typeRef).getFullyQualifiedName())) {
                return true;
            }
            return !p.isStatic();
        }), typeDef.getExtendsList().stream().filter(e -> !e.getFullyQualifiedName().startsWith("java.")).flatMap(e -> Types.projectProperties(Types.projectDefinition(e)).stream().filter(p -> Types.filterCustomResourceProperties(e).test((Property)p)))).collect(Collectors.toList());
    }

    private static Predicate<Property> filterCustomResourceProperties(ClassRef ref) {
        return p -> !p.isStatic() && (!ref.getFullyQualifiedName().equals(CUSTOM_RESOURCE_NAME) || p.getName().equals("spec") || p.getName().equals("status"));
    }

    public static void output(TypeDef def) {
        StringBuilder builder = new StringBuilder(300);
        Types.describeType(def, "", new HashSet<String>(), builder);
        LOGGER.debug("\n{}", (Object)builder);
    }

    public static void describeType(TypeDef def, String indent, Set<String> visited, StringBuilder builder) {
        if (visited.isEmpty()) {
            builder.append(indent).append(def.getFullyQualifiedName()).append("\n");
        }
        visited.add(def.getFullyQualifiedName());
        for (Property property : def.getProperties()) {
            TypeRef typeRef = property.getTypeRef();
            if (typeRef instanceof ClassRef) {
                TypeDef typeDef = Types.typeDefFrom((ClassRef)typeRef);
                builder.append(indent).append("\t").append(property).append(" - ClassRef [").append(typeDef.getKind()).append("]\n");
                if (visited.contains(typeDef.getFullyQualifiedName())) continue;
                Types.describeType(typeDef, indent + "\t", visited, builder);
                continue;
            }
            String type = typeRef instanceof PrimitiveRef ? "PrimitiveRef" : (typeRef instanceof TypeParamRef ? "TypeParamRef" : (typeRef instanceof VoidRef ? "VoidRef" : (typeRef instanceof WildcardRef ? "WildcardRef" : "Unknown")));
            builder.append(indent).append("\t").append(property).append(" - ").append(type).append("\n");
        }
        visited.remove(def.getFullyQualifiedName());
    }

    public static SpecAndStatus resolveSpecAndStatusTypes(TypeDef definition) {
        ClassRef customResourceRef;
        List arguments;
        Optional<ClassRef> optionalCustomResourceRef = definition.getExtendsList().stream().filter(s -> s.getFullyQualifiedName().equals(CUSTOM_RESOURCE_NAME)).findFirst();
        if (optionalCustomResourceRef.isPresent() && (arguments = (customResourceRef = optionalCustomResourceRef.get()).getArguments()).size() == 2) {
            String specClassName = Types.getClassFQNIfNotVoid((TypeRef)arguments.get(0));
            String statusClassName = Types.getClassFQNIfNotVoid((TypeRef)arguments.get(1));
            return new SpecAndStatus(specClassName, statusClassName);
        }
        return SpecAndStatus.UNRESOLVED;
    }

    public static boolean isNamespaced(TypeDef definition) {
        return Types.isNamespaced(definition, new HashSet<TypeDef>());
    }

    public static boolean isNamespaced(TypeDef definition, Set<TypeDef> visited) {
        if (definition.getFullyQualifiedName().equals(NAMESPACED)) {
            return true;
        }
        if (visited.contains(definition) || definition.getPackageName().startsWith("java.")) {
            return false;
        }
        HashSet<TypeDef> newVisited = new HashSet<TypeDef>(visited);
        newVisited.add(definition);
        for (ClassRef i : definition.getImplementsList()) {
            if (!Types.isNamespaced(GetDefinition.of((ClassRef)i), newVisited)) continue;
            return true;
        }
        for (ClassRef e : definition.getExtendsList()) {
            if (!Types.isNamespaced(GetDefinition.of((ClassRef)e), newVisited)) continue;
            return true;
        }
        return false;
    }

    public static Optional<Property> findStatusProperty(TypeDef typeDef) {
        return typeDef.getProperties().stream().filter(Types::isStatusProperty).findFirst();
    }

    public static boolean isStatusProperty(Property property) {
        return "status".equals(property.getName()) && Types.getClassFQNIfNotVoid(property.getTypeRef()) != null;
    }

    private static String getClassFQNIfNotVoid(TypeRef typeRef) {
        if (!(typeRef instanceof ClassRef)) {
            return null;
        }
        String fullyQualifiedName = ((ClassRef)typeRef).getFullyQualifiedName();
        return JAVA_LANG_VOID.equals(fullyQualifiedName) ? null : fullyQualifiedName;
    }

    public static class SpecAndStatus {
        private static final SpecAndStatus UNRESOLVED = new SpecAndStatus(null, null);
        private final String specClassName;
        private final String statusClassName;
        private final boolean unreliable;

        public SpecAndStatus(String specClassName, String statusClassName) {
            this.specClassName = specClassName;
            this.statusClassName = statusClassName;
            this.unreliable = specClassName == null || statusClassName == null;
        }

        public String getSpecClassName() {
            return this.specClassName;
        }

        public String getStatusClassName() {
            return this.statusClassName;
        }

        public boolean isUnreliable() {
            return this.unreliable;
        }
    }
}

