/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.fabric8.crd.generator.AbstractCustomResourceHandler;
import io.fabric8.crd.generator.CRDGenerationInfo;
import io.fabric8.crd.generator.CustomResourceInfo;
import io.fabric8.crd.generator.Resources;
import io.fabric8.crd.generator.utils.Types;
import io.fabric8.crd.generator.v1beta1.CustomResourceHandler;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRDGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRDGenerator.class);
    private final Resources resources;
    private final Map<String, AbstractCustomResourceHandler> handlers = new HashMap<String, AbstractCustomResourceHandler>(2);
    private CRDOutput<? extends OutputStream> output;
    private boolean parallel;
    private Map<String, CustomResourceInfo> infos;
    public static final ObjectMapper YAML_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true)).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)).configure(SerializationFeature.INDENT_OUTPUT, true)).withConfigOverride(Map.class, configOverride -> configOverride.setInclude(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL)))).serializationInclusion(JsonInclude.Include.NON_EMPTY)).build();

    public CRDGenerator() {
        this.resources = new Resources();
        Types.resetGenerationContext();
    }

    public CRDGenerator inOutputDir(File outputDir) {
        this.output = new DirCRDOutput(outputDir);
        return this;
    }

    public CRDGenerator withOutput(CRDOutput<? extends OutputStream> output) {
        this.output = output;
        return this;
    }

    public CRDGenerator withParallelGenerationEnabled(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    public CRDGenerator forCRDVersions(List<String> versions) {
        return versions != null && !versions.isEmpty() ? this.forCRDVersions(versions.toArray(new String[0])) : this;
    }

    public CRDGenerator forCRDVersions(String ... versions) {
        if (versions != null) {
            block8: for (String version : versions) {
                if (version == null) continue;
                switch (version) {
                    case "v1": {
                        this.handlers.computeIfAbsent("v1", s -> new io.fabric8.crd.generator.v1.CustomResourceHandler(this.resources, this.parallel));
                        continue block8;
                    }
                    case "v1beta1": {
                        LOGGER.warn("CRD generator for v1beta1 is deprecated, consider using v1 instead.");
                        this.handlers.computeIfAbsent("v1beta1", s -> new CustomResourceHandler(this.resources, this.parallel));
                        continue block8;
                    }
                    default: {
                        LOGGER.warn("Ignoring unsupported CRD version: {}", (Object)version);
                    }
                }
            }
        }
        return this;
    }

    Map<String, AbstractCustomResourceHandler> getHandlers() {
        return this.handlers;
    }

    public final CRDGenerator customResourceClasses(Class<? extends CustomResource<?, ?>> ... crClasses) {
        return this.customResources((CustomResourceInfo[])Stream.of(crClasses).map(CustomResourceInfo::fromClass).toArray(CustomResourceInfo[]::new));
    }

    public CRDGenerator customResources(CustomResourceInfo ... infos) {
        if (infos != null && infos.length > 0) {
            if (this.infos == null) {
                this.infos = new HashMap<String, CustomResourceInfo>(infos.length);
            }
            Arrays.stream(infos).filter(Objects::nonNull).forEach(info -> this.infos.put(CRDGenerator.getOutputName(info.crdName(), info.version()), (CustomResourceInfo)info));
        }
        return this;
    }

    Set<CustomResourceInfo> getCustomResourceInfos() {
        return this.infos == null ? Collections.emptySet() : new HashSet<CustomResourceInfo>(this.infos.values());
    }

    public int generate() {
        return this.detailedGenerate().numberOfGeneratedCRDs();
    }

    public CRDGenerationInfo detailedGenerate() {
        if (this.getCustomResourceInfos().isEmpty()) {
            LOGGER.warn("No resources were registered with the 'customResources' method to be generated");
            return CRDGenerationInfo.EMPTY;
        }
        if (this.output == null) {
            LOGGER.warn("No output option was selected either using 'inOutputDir' or 'withOutput' methods. Skipping generation.");
            return CRDGenerationInfo.EMPTY;
        }
        if (this.handlers.isEmpty()) {
            this.forCRDVersions("v1", "v1beta1");
        }
        for (CustomResourceInfo info : this.infos.values()) {
            if (info == null) continue;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Generating '{}' version '{}' with {} (spec: {} / status {})...", new Object[]{info.crdName(), info.version(), info.crClassName(), info.specClassName().orElse("undetermined"), info.statusClassName().orElse("undetermined")});
            }
            this.handlers.values().forEach(h -> h.handle(info));
        }
        CRDGenerationInfo crdGenerationInfo = new CRDGenerationInfo();
        for (HasMetadata crd : this.resources.generate().getItems()) {
            String version = ApiVersionUtil.trimVersion((String)crd.getApiVersion());
            String crdName = crd.getMetadata().getName();
            try {
                String outputName = CRDGenerator.getOutputName(crdName, version);
                OutputStream outputStream = this.output.outputFor(outputName);
                Throwable throwable = null;
                try {
                    outputStream.write("# Generated by Fabric8 CRDGenerator, manual edits might get overwritten!\n".getBytes());
                    YAML_MAPPER.writeValue(outputStream, (Object)crd);
                    URI fileURI = this.output.crdURI(outputName);
                    crdGenerationInfo.add(crdName, version, fileURI);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream == null) continue;
                    if (throwable != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return crdGenerationInfo;
    }

    public static String getOutputName(String crdName, String crdSpecVersion) {
        return crdName + "-" + crdSpecVersion;
    }

    static class DirCRDOutput
    extends AbstractCRDOutput<FileOutputStream> {
        private final File dir;

        public DirCRDOutput(File dir) {
            if (!(dir.isDirectory() && dir.canWrite() && dir.exists())) {
                throw new IllegalArgumentException(dir + " must exist, be a writeable output directory");
            }
            this.dir = dir;
        }

        @Override
        protected FileOutputStream createStreamFor(String crdName) throws IOException {
            File file = this.getCRDFile(crdName);
            return new FileOutputStream(file);
        }

        private File getCRDFile(String crdName) {
            return new File(this.dir, crdName + ".yml");
        }

        @Override
        public URI crdURI(String crdName) {
            return this.getCRDFile(crdName).toURI();
        }
    }

    public static abstract class AbstractCRDOutput<T extends OutputStream>
    implements CRDOutput<T> {
        private final Map<String, T> crds = new HashMap<String, T>(7);

        @Override
        public T outputFor(String crdName) throws IOException {
            T outputStream = this.createStreamFor(crdName);
            this.crds.put(crdName, outputStream);
            return outputStream;
        }

        protected abstract T createStreamFor(String var1) throws IOException;

        protected T getStreamFor(String crdName) {
            return (T)((OutputStream)this.crds.get(crdName));
        }

        @Override
        public void close() throws IOException {
            for (OutputStream stream : this.crds.values()) {
                stream.close();
            }
        }
    }

    public static interface CRDOutput<T extends OutputStream>
    extends Closeable {
        public T outputFor(String var1) throws IOException;

        default public URI crdURI(String crdName) {
            return URI.create("file:///" + crdName);
        }
    }
}

