/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.fabric8.crd.generator.InternalSchemaSwaps;
import io.fabric8.crd.generator.annotation.SchemaSwap;
import io.fabric8.crd.generator.utils.Types;
import io.fabric8.generator.annotation.ValidationRule;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Quantity;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.model.AnnotationRef;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import io.sundr.model.functions.GetDefinition;
import io.sundr.model.utils.Collections;
import io.sundr.model.utils.Optionals;
import io.sundr.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonSchema<T, B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonSchema.class);
    protected static final TypeDef OBJECT = TypeDef.forName((String)Object.class.getName());
    protected static final TypeDef QUANTITY = TypeDef.forName((String)Quantity.class.getName());
    protected static final TypeDef DURATION = TypeDef.forName((String)Duration.class.getName());
    protected static final TypeDef INT_OR_STRING = TypeDef.forName((String)IntOrString.class.getName());
    protected static final TypeRef OBJECT_REF = OBJECT.toReference(new TypeRef[0]);
    protected static final TypeRef QUANTITY_REF = QUANTITY.toReference(new TypeRef[0]);
    protected static final TypeRef DURATION_REF = DURATION.toReference(new TypeRef[0]);
    protected static final TypeRef INT_OR_STRING_REF = INT_OR_STRING.toReference(new TypeRef[0]);
    protected static final TypeDef DATE = TypeDef.forName((String)Date.class.getName());
    protected static final TypeRef DATE_REF = DATE.toReference(new TypeRef[0]);
    private static final String VALUE = "value";
    private static final String INT_OR_STRING_MARKER = "int_or_string";
    private static final String STRING_MARKER = "string";
    private static final String INTEGER_MARKER = "integer";
    private static final String NUMBER_MARKER = "number";
    private static final String BOOLEAN_MARKER = "boolean";
    protected static final TypeRef P_INT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("int")).build();
    protected static final TypeRef P_LONG_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("long")).build();
    protected static final TypeRef P_FLOAT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("float")).build();
    protected static final TypeRef P_DOUBLE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("double")).build();
    protected static final TypeRef P_BOOLEAN_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("boolean")).build();
    private static final Map<TypeRef, String> COMMON_MAPPINGS = new HashMap<TypeRef, String>();
    public static final String ANNOTATION_JSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";
    public static final String ANNOTATION_JSON_PROPERTY_DESCRIPTION = "com.fasterxml.jackson.annotation.JsonPropertyDescription";
    public static final String ANNOTATION_JSON_IGNORE = "com.fasterxml.jackson.annotation.JsonIgnore";
    public static final String ANNOTATION_JSON_ANY_GETTER = "com.fasterxml.jackson.annotation.JsonAnyGetter";
    public static final String ANNOTATION_JSON_ANY_SETTER = "com.fasterxml.jackson.annotation.JsonAnySetter";
    public static final String ANNOTATION_DEFAULT = "io.fabric8.generator.annotation.Default";
    public static final String ANNOTATION_MIN = "io.fabric8.generator.annotation.Min";
    public static final String ANNOTATION_MAX = "io.fabric8.generator.annotation.Max";
    public static final String ANNOTATION_PATTERN = "io.fabric8.generator.annotation.Pattern";
    public static final String ANNOTATION_NULLABLE = "io.fabric8.generator.annotation.Nullable";
    public static final String ANNOTATION_REQUIRED = "io.fabric8.generator.annotation.Required";
    public static final String ANNOTATION_SCHEMA_FROM = "io.fabric8.crd.generator.annotation.SchemaFrom";
    public static final String ANNOTATION_PERSERVE_UNKNOWN_FIELDS = "io.fabric8.crd.generator.annotation.PreserveUnknownFields";
    public static final String ANNOTATION_SCHEMA_SWAP = "io.fabric8.crd.generator.annotation.SchemaSwap";
    public static final String ANNOTATION_SCHEMA_SWAPS = "io.fabric8.crd.generator.annotation.SchemaSwaps";
    public static final String ANNOTATION_VALIDATION_RULE = "io.fabric8.generator.annotation.ValidationRule";
    public static final String ANNOTATION_VALIDATION_RULES = "io.fabric8.generator.annotation.ValidationRules";
    public static final String JSON_NODE_TYPE = "com.fasterxml.jackson.databind.JsonNode";
    public static final String ANY_TYPE = "io.fabric8.kubernetes.api.model.AnyType";
    private boolean resolving = false;

    public static String getSchemaTypeFor(TypeRef typeRef) {
        String type = COMMON_MAPPINGS.get(typeRef);
        if (type == null && typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            TypeDef def = Types.typeDefFrom(classRef);
            type = def.isEnum() ? STRING_MARKER : "object";
        }
        return type;
    }

    protected T internalFrom(TypeDef definition, String ... ignore) {
        InternalSchemaSwaps schemaSwaps = new InternalSchemaSwaps();
        return this.internalFromImpl(definition, new HashSet<String>(), schemaSwaps, ignore);
    }

    private static ClassRef extractClassRef(Object type) {
        if (type != null) {
            if (type instanceof ClassRef) {
                return (ClassRef)type;
            }
            if (type instanceof Class) {
                return Types.typeDefFrom((Class)type).toReference(new TypeRef[0]);
            }
            throw new IllegalArgumentException("Unmanaged type passed to the annotation " + type);
        }
        return null;
    }

    private void extractSchemaSwaps(ClassRef definitionType, AnnotationRef annotation, InternalSchemaSwaps schemaSwaps) {
        String fullyQualifiedName;
        switch (fullyQualifiedName = annotation.getClassRef().getFullyQualifiedName()) {
            case "io.fabric8.crd.generator.annotation.SchemaSwap": {
                this.extractSchemaSwap(definitionType, annotation, schemaSwaps);
                break;
            }
            case "io.fabric8.crd.generator.annotation.SchemaSwaps": {
                Object[] values;
                Map params = annotation.getParameters();
                for (Object value : values = (Object[])params.get(VALUE)) {
                    this.extractSchemaSwap(definitionType, value, schemaSwaps);
                }
                break;
            }
        }
    }

    private void extractSchemaSwap(ClassRef definitionType, Object annotation, InternalSchemaSwaps schemaSwaps) {
        if (annotation instanceof SchemaSwap) {
            SchemaSwap schemaSwap = (SchemaSwap)annotation;
            schemaSwaps.registerSwap(definitionType, AbstractJsonSchema.extractClassRef(schemaSwap.originalType()), schemaSwap.fieldName(), AbstractJsonSchema.extractClassRef(schemaSwap.targetType()), schemaSwap.depth());
        } else if (annotation instanceof AnnotationRef && ((AnnotationRef)annotation).getClassRef().getFullyQualifiedName().equals(ANNOTATION_SCHEMA_SWAP)) {
            Map params = ((AnnotationRef)annotation).getParameters();
            schemaSwaps.registerSwap(definitionType, AbstractJsonSchema.extractClassRef(params.get("originalType")), (String)params.get("fieldName"), AbstractJsonSchema.extractClassRef(params.getOrDefault("targetType", Void.TYPE)), params.getOrDefault("depth", 0));
        } else {
            throw new IllegalArgumentException("Unmanaged annotation type passed to the SchemaSwaps: " + annotation);
        }
    }

    private static Stream<KubernetesValidationRule> extractKubernetesValidationRules(AnnotationRef annotationRef) {
        switch (annotationRef.getClassRef().getFullyQualifiedName()) {
            case "io.fabric8.generator.annotation.ValidationRule": {
                return Stream.of(KubernetesValidationRule.from(annotationRef));
            }
            case "io.fabric8.generator.annotation.ValidationRules": {
                return Arrays.stream((ValidationRule[])annotationRef.getParameters().get(VALUE)).map(KubernetesValidationRule::from);
            }
        }
        return Stream.empty();
    }

    private T internalFromImpl(TypeDef definition, Set<String> visited, InternalSchemaSwaps schemaSwaps, String ... ignore) {
        LinkedHashSet<String> ignores = ignore.length > 0 ? new LinkedHashSet<String>(Arrays.asList(ignore)) : java.util.Collections.emptySet();
        ArrayList<String> required = new ArrayList<String>();
        boolean isJsonNode = definition.getFullyQualifiedName() != null && (definition.getFullyQualifiedName().equals(JSON_NODE_TYPE) || definition.getFullyQualifiedName().equals(ANY_TYPE));
        B builder = isJsonNode ? this.newBuilder(null) : this.newBuilder();
        boolean preserveUnknownFields = isJsonNode;
        InternalSchemaSwaps swaps = schemaSwaps = schemaSwaps.branchAnnotations();
        definition.getAnnotations().forEach(annotation -> this.extractSchemaSwaps(definition.toReference(new TypeRef[0]), (AnnotationRef)annotation, swaps));
        Map<String, Method> accessors = this.indexPotentialAccessors(definition);
        for (Property property : definition.getProperties()) {
            String description;
            if (isJsonNode) break;
            String name = property.getName();
            if (property.isStatic() || ignores.contains(name)) {
                LOGGER.debug("Ignoring property {}", (Object)name);
                continue;
            }
            schemaSwaps = schemaSwaps.branchDepths();
            InternalSchemaSwaps.SwapResult swapResult = schemaSwaps.lookupAndMark(definition.toReference(new TypeRef[0]), name);
            if (swapResult.onGoing) {
                visited.clear();
            }
            PropertyFacade facade = new PropertyFacade(property, accessors, swapResult.classRef);
            Property possiblyRenamedProperty = facade.process();
            name = possiblyRenamedProperty.getName();
            if (facade.required) {
                required.add(name);
            } else if (facade.ignored) continue;
            T schema = this.internalFromImpl(name, possiblyRenamedProperty.getTypeRef(), visited, schemaSwaps);
            if (facade.preserveUnknownFields) {
                preserveUnknownFields = true;
            }
            T possiblyUpdatedSchema = (description = facade.description) == null ? schema : this.addDescription(schema, description);
            SchemaPropsOptions options = new SchemaPropsOptions(facade.defaultValue, facade.min, facade.max, facade.pattern, facade.validationRules, facade.nullable, facade.required, facade.preserveUnknownFields);
            this.addProperty(possiblyRenamedProperty, builder, possiblyUpdatedSchema, options);
        }
        List<KubernetesValidationRule> validationRules = Stream.concat(definition.getAnnotations().stream(), definition.getExtendsList().stream().flatMap(classRef -> GetDefinition.of((ClassRef)classRef).getAnnotations().stream())).flatMap(AbstractJsonSchema::extractKubernetesValidationRules).filter(Objects::nonNull).collect(Collectors.toList());
        swaps.throwIfUnmatchedSwaps();
        return this.build(builder, required, validationRules, preserveUnknownFields);
    }

    private Map<String, Method> indexPotentialAccessors(TypeDef definition) {
        List methods = definition.getMethods();
        HashMap<String, Method> accessors = new HashMap<String, Method>(methods.size());
        methods.stream().filter(this::isPotentialAccessor).forEach(m -> accessors.put(m.getName(), (Method)m));
        return accessors;
    }

    private boolean isPotentialAccessor(Method method) {
        String name = method.getName();
        return name.startsWith("is") || name.startsWith("get") || name.startsWith("set");
    }

    private String extractUpdatedNameFromJacksonPropertyIfPresent(Property property) {
        String name = property.getName();
        boolean ignored = property.getAnnotations().stream().anyMatch(a -> a.getClassRef().getFullyQualifiedName().equals(ANNOTATION_JSON_IGNORE));
        if (ignored) {
            return null;
        }
        return property.getAnnotations().stream().filter(a -> a.getClassRef().getFullyQualifiedName().equals(ANNOTATION_JSON_PROPERTY)).findAny().map(a -> {
            String fromAnnotation = (String)a.getParameters().get(VALUE);
            if (!Strings.isNullOrEmpty((String)fromAnnotation) && !name.equals(fromAnnotation)) {
                return fromAnnotation;
            }
            return name;
        }).orElse(property.getName());
    }

    public abstract B newBuilder();

    public abstract B newBuilder(String var1);

    public abstract void addProperty(Property var1, B var2, T var3, SchemaPropsOptions var4);

    public abstract T build(B var1, List<String> var2, List<KubernetesValidationRule> var3, boolean var4);

    public T internalFrom(String name, TypeRef typeRef) {
        return this.internalFromImpl(name, typeRef, new HashSet<String>(), new InternalSchemaSwaps());
    }

    private T internalFromImpl(String name, TypeRef typeRef, Set<String> visited, InternalSchemaSwaps schemaSwaps) {
        if (typeRef.getDimensions() > 0 || Collections.isCollection((TypeRef)typeRef)) {
            TypeRef collectionType = (TypeRef)TypeAs.combine((Function[])new Function[]{TypeAs.UNWRAP_ARRAY_OF, TypeAs.UNWRAP_COLLECTION_OF}).apply(typeRef);
            T schema = this.internalFromImpl(name, collectionType, visited, schemaSwaps);
            return this.arrayLikeProperty(schema);
        }
        if (((Boolean)Collections.IS_MAP.apply(typeRef)).booleanValue()) {
            TypeRef valueType;
            T schema;
            TypeRef keyType = (TypeRef)TypeAs.UNWRAP_MAP_KEY_OF.apply(typeRef);
            if (!(keyType instanceof ClassRef) || !((ClassRef)keyType).getFullyQualifiedName().equals("java.lang.String")) {
                LOGGER.warn("Property '{}' with '{}' key type is mapped to 'string' because of CRD schemas limitations", (Object)name, (Object)typeRef);
            }
            if ((schema = this.internalFromImpl(name, valueType = (TypeRef)TypeAs.UNWRAP_MAP_VALUE_OF.apply(typeRef), visited, schemaSwaps)) == null) {
                LOGGER.warn("Property '{}' with '{}' value type is mapped to 'object' because its CRD representation cannot be extracted.", (Object)name, (Object)typeRef);
                schema = this.internalFromImpl(name, OBJECT_REF, visited, schemaSwaps);
            }
            return this.mapLikeProperty(schema);
        }
        if (Optionals.isOptional((TypeRef)typeRef)) {
            return this.internalFromImpl(name, (TypeRef)TypeAs.UNWRAP_OPTIONAL_OF.apply(typeRef), visited, schemaSwaps);
        }
        String typeName = COMMON_MAPPINGS.get(typeRef);
        if (typeName != null) {
            if (INT_OR_STRING_MARKER.equals(typeName)) {
                return this.mappedProperty(typeRef);
            }
            return this.singleProperty(typeName);
        }
        if (typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            TypeDef def = Types.typeDefFrom(classRef);
            if (def.isEnum()) {
                JsonNode[] enumValues = (JsonNode[])def.getProperties().stream().filter(Property::isEnumConstant).map(this::extractUpdatedNameFromJacksonPropertyIfPresent).filter(Objects::nonNull).sorted().map(arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).textNode(arg_0)).toArray(JsonNode[]::new);
                return this.enumProperty(enumValues);
            }
            if (!classRef.getFullyQualifiedName().equals(io.sundr.model.utils.Types.VOID.getName())) {
                return this.resolveNestedClass(name, def, visited, schemaSwaps);
            }
        }
        return null;
    }

    private T resolveNestedClass(String name, TypeDef def, Set<String> visited, InternalSchemaSwaps schemaSwaps) {
        if (!this.resolving) {
            visited.clear();
            this.resolving = true;
        } else {
            String visitedName = name + ":" + def.getFullyQualifiedName();
            if (!def.getFullyQualifiedName().startsWith("java") && visited.contains(visitedName)) {
                throw new IllegalArgumentException("Found a cyclic reference involving the field " + name + " of type " + def.getFullyQualifiedName());
            }
            visited.add(visitedName);
        }
        T res = this.internalFromImpl(def, visited, schemaSwaps, new String[0]);
        this.resolving = false;
        return res;
    }

    protected abstract T mappedProperty(TypeRef var1);

    protected abstract T arrayLikeProperty(T var1);

    protected abstract T mapLikeProperty(T var1);

    protected abstract T singleProperty(String var1);

    protected abstract T enumProperty(JsonNode ... var1);

    protected abstract T addDescription(T var1, String var2);

    static {
        COMMON_MAPPINGS.put((TypeRef)io.sundr.model.utils.Types.STRING_REF, STRING_MARKER);
        COMMON_MAPPINGS.put(DATE_REF, STRING_MARKER);
        COMMON_MAPPINGS.put((TypeRef)io.sundr.model.utils.Types.INT_REF, INTEGER_MARKER);
        COMMON_MAPPINGS.put(P_INT_REF, INTEGER_MARKER);
        COMMON_MAPPINGS.put((TypeRef)io.sundr.model.utils.Types.LONG_REF, INTEGER_MARKER);
        COMMON_MAPPINGS.put(P_LONG_REF, INTEGER_MARKER);
        COMMON_MAPPINGS.put((TypeRef)io.sundr.model.utils.Types.FLOAT_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(P_FLOAT_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put((TypeRef)io.sundr.model.utils.Types.DOUBLE_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(P_DOUBLE_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(io.sundr.model.utils.Types.BOOLEAN_REF, BOOLEAN_MARKER);
        COMMON_MAPPINGS.put(P_BOOLEAN_REF, BOOLEAN_MARKER);
        COMMON_MAPPINGS.put(QUANTITY_REF, INT_OR_STRING_MARKER);
        COMMON_MAPPINGS.put(INT_OR_STRING_REF, INT_OR_STRING_MARKER);
        COMMON_MAPPINGS.put(DURATION_REF, STRING_MARKER);
    }

    protected static class KubernetesValidationRule {
        private String fieldPath;
        private String message;
        private String messageExpression;
        private Boolean optionalOldSelf;
        private String reason;
        private String rule;

        protected KubernetesValidationRule() {
        }

        public String getFieldPath() {
            return this.fieldPath;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageExpression() {
            return this.messageExpression;
        }

        public Boolean getOptionalOldSelf() {
            return this.optionalOldSelf;
        }

        public String getReason() {
            return this.reason;
        }

        public String getRule() {
            return this.rule;
        }

        static KubernetesValidationRule from(AnnotationRef annotationRef) {
            KubernetesValidationRule result = new KubernetesValidationRule();
            result.rule = (String)annotationRef.getParameters().get(AbstractJsonSchema.VALUE);
            result.reason = KubernetesValidationRule.mapNotEmpty((String)annotationRef.getParameters().get("reason"));
            result.message = KubernetesValidationRule.mapNotEmpty((String)annotationRef.getParameters().get("message"));
            result.messageExpression = KubernetesValidationRule.mapNotEmpty((String)annotationRef.getParameters().get("messageExpression"));
            result.fieldPath = KubernetesValidationRule.mapNotEmpty((String)annotationRef.getParameters().get("fieldPath"));
            result.optionalOldSelf = Boolean.TRUE.equals(annotationRef.getParameters().get("optionalOldSelf")) ? Boolean.TRUE : null;
            return result;
        }

        static KubernetesValidationRule from(ValidationRule validationRule) {
            KubernetesValidationRule result = new KubernetesValidationRule();
            result.rule = validationRule.value();
            result.reason = KubernetesValidationRule.mapNotEmpty(validationRule.reason());
            result.message = KubernetesValidationRule.mapNotEmpty(validationRule.message());
            result.messageExpression = KubernetesValidationRule.mapNotEmpty(validationRule.messageExpression());
            result.fieldPath = KubernetesValidationRule.mapNotEmpty(validationRule.fieldPath());
            result.optionalOldSelf = validationRule.optionalOldSelf() ? Boolean.valueOf(true) : null;
            return result;
        }

        private static String mapNotEmpty(String s) {
            if (s == null) {
                return null;
            }
            if (s.isEmpty()) {
                return null;
            }
            return s;
        }
    }

    private static class PropertyFacade {
        private final List<PropertyOrAccessor> propertyOrAccessors = new ArrayList<PropertyOrAccessor>(4);
        private String renamedTo;
        private String description;
        private String defaultValue;
        private Double min;
        private Double max;
        private String pattern;
        private boolean nullable;
        private boolean required;
        private boolean ignored;
        private boolean preserveUnknownFields;
        private final Property original;
        private String nameContributedBy;
        private String descriptionContributedBy;
        private TypeRef schemaFrom;
        private List<KubernetesValidationRule> validationRules;

        public PropertyFacade(Property property, Map<String, Method> potentialAccessors, ClassRef schemaSwap) {
            this.original = property;
            String capitalized = property.getNameCapitalized();
            String name = property.getName();
            this.propertyOrAccessors.add(PropertyOrAccessor.fromProperty(property));
            Method method = potentialAccessors.get("is" + capitalized);
            if (method != null) {
                this.propertyOrAccessors.add(PropertyOrAccessor.fromMethod(method, name));
            }
            if ((method = potentialAccessors.get("get" + capitalized)) != null) {
                this.propertyOrAccessors.add(PropertyOrAccessor.fromMethod(method, name));
            }
            if ((method = potentialAccessors.get("set" + capitalized)) != null) {
                this.propertyOrAccessors.add(PropertyOrAccessor.fromMethod(method, name));
            }
            this.schemaFrom = schemaSwap;
            this.defaultValue = null;
            this.min = null;
            this.max = null;
            this.pattern = null;
            this.validationRules = new LinkedList<KubernetesValidationRule>();
        }

        public Property process() {
            String name = this.original.getName();
            this.propertyOrAccessors.forEach(p -> {
                p.process();
                String contributorName = p.toString();
                if (p.contributeName()) {
                    if (this.renamedTo == null) {
                        this.renamedTo = p.getRenamedTo();
                        this.nameContributedBy = contributorName;
                    } else {
                        LOGGER.debug("Property {} has already been renamed to {} by {}", new Object[]{name, this.renamedTo, this.nameContributedBy});
                    }
                }
                if (p.contributeDescription()) {
                    if (this.description == null) {
                        this.description = p.getDescription();
                        this.descriptionContributedBy = contributorName;
                    } else {
                        LOGGER.debug("Description for property {} has already been contributed by: {}", (Object)name, (Object)this.descriptionContributedBy);
                    }
                }
                this.defaultValue = p.getDefault().orElse(this.defaultValue);
                this.min = p.getMin().orElse(this.min);
                this.max = p.getMax().orElse(this.max);
                this.pattern = p.getPattern().orElse(this.pattern);
                p.getValidationRules().ifPresent(rules -> this.validationRules.addAll((Collection<KubernetesValidationRule>)rules));
                if (p.isNullable()) {
                    this.nullable = true;
                }
                if (p.isRequired()) {
                    this.required = true;
                } else if (p.isIgnored()) {
                    this.ignored = true;
                }
                boolean bl = this.preserveUnknownFields = p.isPreserveUnknownFields() || this.preserveUnknownFields;
                if (p.contributeSchemaFrom()) {
                    this.schemaFrom = p.getSchemaFrom();
                }
            });
            TypeRef typeRef = this.schemaFrom != null ? this.schemaFrom : this.original.getTypeRef();
            String finalName = this.renamedTo != null ? this.renamedTo : this.original.getName();
            return new Property(this.original.getAnnotations(), typeRef, finalName, this.original.getComments(), false, false, this.original.getModifiers(), this.original.getAttributes());
        }
    }

    private static class PropertyOrAccessor {
        private final Collection<AnnotationRef> annotations;
        private final String name;
        private final String propertyName;
        private final String type;
        private String renamedTo;
        private String defaultValue;
        private Double min;
        private Double max;
        private String pattern;
        private List<KubernetesValidationRule> validationRules;
        private boolean nullable;
        private boolean required;
        private boolean ignored;
        private boolean preserveUnknownFields;
        private String description;
        private TypeRef schemaFrom;

        private PropertyOrAccessor(Collection<AnnotationRef> annotations, String name, String propertyName, boolean isMethod) {
            this.annotations = annotations;
            this.name = name;
            this.propertyName = propertyName;
            this.type = isMethod ? "accessor" : "field";
        }

        static PropertyOrAccessor fromProperty(Property property) {
            return new PropertyOrAccessor(property.getAnnotations(), property.getName(), property.getName(), false);
        }

        static PropertyOrAccessor fromMethod(Method method, String propertyName) {
            return new PropertyOrAccessor(method.getAnnotations(), method.getName(), propertyName, true);
        }

        public void process() {
            this.annotations.forEach(a -> {
                switch (a.getClassRef().getFullyQualifiedName()) {
                    case "io.fabric8.generator.annotation.Default": {
                        this.defaultValue = (String)a.getParameters().get(AbstractJsonSchema.VALUE);
                        break;
                    }
                    case "io.fabric8.generator.annotation.Nullable": {
                        this.nullable = true;
                        break;
                    }
                    case "io.fabric8.generator.annotation.Max": {
                        this.max = (Double)a.getParameters().get(AbstractJsonSchema.VALUE);
                        break;
                    }
                    case "io.fabric8.generator.annotation.Min": {
                        this.min = (Double)a.getParameters().get(AbstractJsonSchema.VALUE);
                        break;
                    }
                    case "io.fabric8.generator.annotation.Pattern": {
                        this.pattern = (String)a.getParameters().get(AbstractJsonSchema.VALUE);
                        break;
                    }
                    case "io.fabric8.generator.annotation.Required": {
                        this.required = true;
                        break;
                    }
                    case "com.fasterxml.jackson.annotation.JsonProperty": {
                        String nameFromAnnotation = (String)a.getParameters().get(AbstractJsonSchema.VALUE);
                        if (Strings.isNullOrEmpty((String)nameFromAnnotation) || this.propertyName.equals(nameFromAnnotation)) break;
                        this.renamedTo = nameFromAnnotation;
                        break;
                    }
                    case "com.fasterxml.jackson.annotation.JsonPropertyDescription": {
                        String descriptionFromAnnotation = (String)a.getParameters().get(AbstractJsonSchema.VALUE);
                        if (Strings.isNullOrEmpty((String)descriptionFromAnnotation)) break;
                        this.description = descriptionFromAnnotation;
                        break;
                    }
                    case "com.fasterxml.jackson.annotation.JsonIgnore": {
                        this.ignored = true;
                        break;
                    }
                    case "com.fasterxml.jackson.annotation.JsonAnyGetter": 
                    case "com.fasterxml.jackson.annotation.JsonAnySetter": 
                    case "io.fabric8.crd.generator.annotation.PreserveUnknownFields": {
                        this.preserveUnknownFields = true;
                        break;
                    }
                    case "io.fabric8.crd.generator.annotation.SchemaFrom": {
                        this.schemaFrom = AbstractJsonSchema.extractClassRef(a.getParameters().get("type"));
                        break;
                    }
                    case "io.fabric8.generator.annotation.ValidationRule": 
                    case "io.fabric8.generator.annotation.ValidationRules": {
                        this.validationRules = AbstractJsonSchema.extractKubernetesValidationRules(a).collect(Collectors.toList());
                    }
                }
            });
        }

        public String getRenamedTo() {
            return this.renamedTo;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public Optional<String> getDefault() {
            return Optional.ofNullable(this.defaultValue);
        }

        public Optional<Double> getMax() {
            return Optional.ofNullable(this.max);
        }

        public Optional<Double> getMin() {
            return Optional.ofNullable(this.min);
        }

        public Optional<String> getPattern() {
            return Optional.ofNullable(this.pattern);
        }

        public Optional<List<KubernetesValidationRule>> getValidationRules() {
            return Optional.ofNullable(this.validationRules);
        }

        public boolean isRequired() {
            return this.required;
        }

        public boolean isIgnored() {
            return this.ignored;
        }

        public boolean isPreserveUnknownFields() {
            return this.preserveUnknownFields;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean contributeName() {
            return this.renamedTo != null;
        }

        public boolean contributeDescription() {
            return this.description != null;
        }

        public TypeRef getSchemaFrom() {
            return this.schemaFrom;
        }

        public boolean contributeSchemaFrom() {
            return this.schemaFrom != null;
        }

        public String toString() {
            return "'" + this.name + "' " + this.type;
        }
    }

    protected static class SchemaPropsOptions {
        final String defaultValue;
        final Double min;
        final Double max;
        final String pattern;
        final boolean nullable;
        final boolean required;
        final boolean preserveUnknownFields;
        final List<KubernetesValidationRule> validationRules;

        SchemaPropsOptions() {
            this.defaultValue = null;
            this.min = null;
            this.max = null;
            this.pattern = null;
            this.nullable = false;
            this.required = false;
            this.preserveUnknownFields = false;
            this.validationRules = null;
        }

        public SchemaPropsOptions(String defaultValue, Double min, Double max, String pattern, List<KubernetesValidationRule> validationRules, boolean nullable, boolean required, boolean preserveUnknownFields) {
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
            this.pattern = pattern;
            this.nullable = nullable;
            this.required = required;
            this.preserveUnknownFields = preserveUnknownFields;
            this.validationRules = validationRules;
        }

        public Optional<String> getDefault() {
            return Optional.ofNullable(this.defaultValue);
        }

        public Optional<Double> getMin() {
            return Optional.ofNullable(this.min);
        }

        public Optional<Double> getMax() {
            return Optional.ofNullable(this.max);
        }

        public Optional<String> getPattern() {
            return Optional.ofNullable(this.pattern);
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean getRequired() {
            return this.required;
        }

        public boolean isPreserveUnknownFields() {
            return this.preserveUnknownFields;
        }

        public List<KubernetesValidationRule> getValidationRules() {
            return Optional.ofNullable(this.validationRules).orElseGet(java.util.Collections::emptyList);
        }
    }
}

