/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1beta1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.v1beta1.decorator.AddCustomResourceDefinitionResourceDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.CustomResourceDefinitionDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersionBuilder;
import java.util.function.Predicate;

public class AddCustomResourceDefinitionVersionDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    private String version;

    public AddCustomResourceDefinitionVersionDecorator(String name, String version) {
        super(name);
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        Predicate<CustomResourceDefinitionVersionBuilder> predicate = candidate -> candidate.getName().equals(this.version);
        spec.removeMatchingFromVersions(predicate);
        ((CustomResourceDefinitionSpecFluent.VersionsNested)spec.addNewVersion().withName(this.version)).endVersion();
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{AddCustomResourceDefinitionResourceDecorator.class};
    }

    public String toString() {
        return this.getClass().getName() + " [name:" + this.getName() + ", version:" + this.version + "]";
    }
}

