/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.fabric8.crd.generator.utils.Types;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Quantity;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.model.AnnotationRef;
import io.sundr.model.ClassRef;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.Property;
import io.sundr.model.TypeDef;
import io.sundr.model.TypeRef;
import io.sundr.model.utils.Collections;
import io.sundr.model.utils.Optionals;
import io.sundr.utils.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonSchema<T, B> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonSchema.class);
    protected static final TypeDef QUANTITY = (TypeDef)ClassTo.TYPEDEF.apply(Quantity.class);
    protected static final TypeDef DURATION = (TypeDef)ClassTo.TYPEDEF.apply(Duration.class);
    protected static final TypeDef INT_OR_STRING = (TypeDef)ClassTo.TYPEDEF.apply(IntOrString.class);
    protected static final TypeDef BOOLEAN = (TypeDef)ClassTo.TYPEDEF.apply(Boolean.class);
    protected static final TypeDef STRING = (TypeDef)ClassTo.TYPEDEF.apply(String.class);
    protected static final TypeDef INT = (TypeDef)ClassTo.TYPEDEF.apply(Integer.class);
    protected static final TypeDef LONG = (TypeDef)ClassTo.TYPEDEF.apply(Long.class);
    protected static final TypeDef DOUBLE = (TypeDef)ClassTo.TYPEDEF.apply(Double.class);
    protected static final TypeDef DATE = (TypeDef)ClassTo.TYPEDEF.apply(Date.class);
    protected static final TypeRef QUANTITY_REF = QUANTITY.toReference(new TypeRef[0]);
    protected static final TypeRef DURATION_REF = DURATION.toReference(new TypeRef[0]);
    protected static final TypeRef INT_OR_STRING_REF = INT_OR_STRING.toReference(new TypeRef[0]);
    protected static final TypeRef BOOLEAN_REF = BOOLEAN.toReference(new TypeRef[0]);
    protected static final TypeRef STRING_REF = STRING.toReference(new TypeRef[0]);
    protected static final TypeRef INT_REF = INT.toReference(new TypeRef[0]);
    protected static final TypeRef LONG_REF = LONG.toReference(new TypeRef[0]);
    protected static final TypeRef DOUBLE_REF = DOUBLE.toReference(new TypeRef[0]);
    protected static final TypeRef DATE_REF = DATE.toReference(new TypeRef[0]);
    private static final String INT_OR_STRING_MARKER = "int_or_string";
    private static final String STRING_MARKER = "string";
    private static final String NUMBER_MARKER = "number";
    private static final String BOOLEAN_MARKER = "boolean";
    protected static final TypeRef P_INT_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("int")).build();
    protected static final TypeRef P_LONG_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("long")).build();
    protected static final TypeRef P_DOUBLE_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("double")).build();
    protected static final TypeRef P_BOOLEAN_REF = ((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName("boolean")).build();
    private static final Map<TypeRef, String> COMMON_MAPPINGS = new HashMap<TypeRef, String>();
    public static final String ANNOTATION_JSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";

    public static String getSchemaTypeFor(TypeRef typeRef) {
        String type = COMMON_MAPPINGS.get(typeRef);
        if (type == null && typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            TypeDef def = Types.typeDefFrom(classRef);
            type = def.isEnum() ? STRING_MARKER : "object";
        }
        return type;
    }

    protected T internalFrom(TypeDef definition, String ... ignore) {
        B builder = this.newBuilder();
        LinkedHashSet<String> ignores = ignore.length > 0 ? new LinkedHashSet<String>(Arrays.asList(ignore)) : java.util.Collections.emptySet();
        ArrayList<String> required = new ArrayList<String>();
        List methods = definition.getMethods();
        for (Property property : definition.getProperties()) {
            String name = property.getName();
            Property[] updated = new Property[1];
            if (property.isStatic() || ignores.contains(name)) {
                LOGGER.debug("Ignoring property {}", (Object)name);
                continue;
            }
            property.getAnnotations().forEach(a -> {
                switch (a.getClassRef().getFullyQualifiedName()) {
                    case "javax.validation.constraints.NotNull": {
                        required.add(name);
                        break;
                    }
                    case "com.fasterxml.jackson.annotation.JsonProperty": {
                        this.updatePropertyFromAnnotationIfNeeded(property, name, updated, (AnnotationRef)a);
                    }
                }
            });
            if (updated[0] == null) {
                methods.stream().filter(m -> m.getName().matches("(is|get|set)" + property.getNameCapitalized())).forEach(m -> m.getAnnotations().stream().filter(a -> a.getClassRef().getFullyQualifiedName().equals(ANNOTATION_JSON_PROPERTY)).findAny().ifPresent(a -> this.updatePropertyFromAnnotationIfNeeded(property, name, updated, (AnnotationRef)a)));
            } else {
                LOGGER.debug("Property {} has already been renamed to {} by field annotation", (Object)name, (Object)updated[0].getName());
            }
            Property possiblyRenamedProperty = updated[0] != null ? updated[0] : property;
            this.addProperty(possiblyRenamedProperty, builder, this.internalFrom(possiblyRenamedProperty.getName(), possiblyRenamedProperty.getTypeRef()));
        }
        return this.build(builder, required);
    }

    private void updatePropertyFromAnnotationIfNeeded(Property property, String name, Property[] updated, AnnotationRef a) {
        String fromAnnotation = (String)a.getParameters().get("value");
        if (!Strings.isNullOrEmpty((String)fromAnnotation) && !name.equals(fromAnnotation)) {
            updated[0] = new Property(property.getAnnotations(), property.getTypeRef(), fromAnnotation, property.getComments(), property.getModifiers(), property.getAttributes());
        }
    }

    public abstract B newBuilder();

    public abstract void addProperty(Property var1, B var2, T var3);

    public abstract T build(B var1, List<String> var2);

    public T internalFrom(String name, TypeRef typeRef) {
        if (typeRef.getDimensions() > 0 || Collections.isCollection((TypeRef)typeRef)) {
            TypeRef collectionType = (TypeRef)TypeAs.combine((Function[])new Function[]{TypeAs.UNWRAP_ARRAY_OF, TypeAs.UNWRAP_COLLECTION_OF}).apply(typeRef);
            T schema = this.internalFrom(name, collectionType);
            return this.arrayLikeProperty(schema);
        }
        if (((Boolean)Collections.IS_MAP.apply(typeRef)).booleanValue()) {
            TypeRef keyType = (TypeRef)TypeAs.UNWRAP_MAP_KEY_OF.apply(typeRef);
            boolean degraded = false;
            if (keyType instanceof ClassRef) {
                ClassRef classRef = (ClassRef)keyType;
                if (!classRef.getFullyQualifiedName().equals("java.lang.String")) {
                    degraded = true;
                } else {
                    TypeRef valueType = (TypeRef)TypeAs.UNWRAP_MAP_VALUE_OF.apply(typeRef);
                    classRef = (ClassRef)valueType;
                    if (!classRef.getFullyQualifiedName().equals("java.lang.String")) {
                        degraded = true;
                    }
                }
            } else {
                degraded = true;
            }
            if (degraded) {
                LOGGER.warn("Property '{}' with '{}' type is mapped to a string to string mapping because of CRD schemas limitations", (Object)name, (Object)typeRef);
            }
            return this.mapLikeProperty();
        }
        if (Optionals.isOptional((TypeRef)typeRef)) {
            return this.internalFrom(name, (TypeRef)TypeAs.UNWRAP_OPTIONAL_OF.apply(typeRef));
        }
        String typeName = COMMON_MAPPINGS.get(typeRef);
        if (typeName != null) {
            if (INT_OR_STRING_MARKER.equals(typeName)) {
                return this.mappedProperty(typeRef);
            }
            return this.singleProperty(typeName);
        }
        if (typeRef instanceof ClassRef) {
            ClassRef classRef = (ClassRef)typeRef;
            TypeDef def = Types.typeDefFrom(classRef);
            if (def.isEnum()) {
                JsonNode[] enumValues = (JsonNode[])def.getProperties().stream().map(Property::getName).filter(n -> !n.startsWith("$")).map(arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).textNode(arg_0)).toArray(JsonNode[]::new);
                return this.enumProperty(enumValues);
            }
            return this.internalFrom(def, new String[0]);
        }
        return null;
    }

    protected abstract T mappedProperty(TypeRef var1);

    protected abstract T arrayLikeProperty(T var1);

    protected abstract T mapLikeProperty();

    protected abstract T singleProperty(String var1);

    protected abstract T enumProperty(JsonNode ... var1);

    static {
        COMMON_MAPPINGS.put(STRING_REF, STRING_MARKER);
        COMMON_MAPPINGS.put(DATE_REF, STRING_MARKER);
        COMMON_MAPPINGS.put(INT_REF, "integer");
        COMMON_MAPPINGS.put(P_INT_REF, "integer");
        COMMON_MAPPINGS.put(LONG_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(P_LONG_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(DOUBLE_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(P_DOUBLE_REF, NUMBER_MARKER);
        COMMON_MAPPINGS.put(BOOLEAN_REF, BOOLEAN_MARKER);
        COMMON_MAPPINGS.put(P_BOOLEAN_REF, BOOLEAN_MARKER);
        COMMON_MAPPINGS.put(QUANTITY_REF, INT_OR_STRING_MARKER);
        COMMON_MAPPINGS.put(INT_OR_STRING_REF, INT_OR_STRING_MARKER);
        COMMON_MAPPINGS.put(DURATION_REF, STRING_MARKER);
    }
}

