/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator;

import io.fabric8.kubernetes.api.model.Namespaced;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.model.Scope;
import io.sundr.codegen.functions.ClassTo;
import io.sundr.codegen.model.TypeDef;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;

public class CustomResourceInfo {
    private final String group;
    private final String version;
    private final String kind;
    private final String singular;
    private final String plural;
    private final String[] shortNames;
    private final boolean storage;
    private final boolean served;
    private final Scope scope;
    private final TypeDef definition;
    private final String crClassName;
    private final Optional<String> specClassName;
    private final Optional<String> statusClassName;
    private static final String TYPE_NAME = CustomResource.class.getTypeName();
    private static final String VOID_TYPE_NAME = Void.class.getTypeName();

    public CustomResourceInfo(String group, String version, String kind, String singular, String plural, String[] shortNames, boolean storage, boolean served, Scope scope, TypeDef definition, String crClassName, String specClassName, String statusClassName) {
        this.group = group;
        this.version = version;
        this.kind = kind;
        this.singular = singular;
        this.plural = plural;
        this.shortNames = shortNames;
        this.storage = storage;
        this.served = served;
        this.scope = scope;
        this.definition = definition;
        this.crClassName = crClassName;
        this.specClassName = Optional.ofNullable(specClassName);
        this.statusClassName = Optional.ofNullable(statusClassName);
    }

    public boolean storage() {
        return this.storage;
    }

    public boolean served() {
        return this.served;
    }

    public String key() {
        return this.crdName();
    }

    public Scope scope() {
        return this.scope;
    }

    public String crdName() {
        return this.plural() + "." + this.group;
    }

    public String[] shortNames() {
        return this.shortNames;
    }

    public String singular() {
        return this.singular;
    }

    public String plural() {
        return this.plural;
    }

    public String kind() {
        return this.kind;
    }

    public String version() {
        return this.version;
    }

    public String group() {
        return this.group;
    }

    public String crClassName() {
        return this.crClassName;
    }

    public Optional<String> specClassName() {
        return this.specClassName;
    }

    public Optional<String> statusClassName() {
        return this.statusClassName;
    }

    public TypeDef definition() {
        return this.definition;
    }

    public static CustomResourceInfo fromClass(Class<? extends CustomResource> customResource) {
        try {
            Type[] types;
            CustomResource instance = customResource.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            String[] shortNames = CustomResource.getShortNames(customResource);
            Scope scope = Arrays.stream(customResource.getInterfaces()).filter(t -> t.getTypeName().equals(Namespaced.class.getTypeName())).findFirst().map(t -> Scope.NAMESPACED).orElse(Scope.CLUSTER);
            TypeDef definition = (TypeDef)ClassTo.TYPEDEF.apply(customResource);
            Type genericSuperclass = customResource.getGenericSuperclass();
            String typeName = genericSuperclass.getTypeName();
            while (!TYPE_NAME.equals(typeName) && !(genericSuperclass instanceof ParameterizedType)) {
                genericSuperclass = ((Class)genericSuperclass).getGenericSuperclass();
                typeName = genericSuperclass.getTypeName();
            }
            String specClassName = null;
            String statusClassName = null;
            if (genericSuperclass instanceof ParameterizedType && (types = ((ParameterizedType)genericSuperclass).getActualTypeArguments()).length == 2) {
                specClassName = types[0].getTypeName();
                statusClassName = types[1].getTypeName();
            }
            return new CustomResourceInfo(instance.getGroup(), instance.getVersion(), instance.getKind(), instance.getSingular(), instance.getPlural(), shortNames, instance.isStorage(), instance.isServed(), scope, definition, customResource.getCanonicalName(), specClassName, statusClassName);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

